/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLFetcher;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLTable;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DDLGenerator {
    protected BufferedWriter m_ddlFile = null;

    public void writeDDLFile(String filePath, List<DataSource> dataSrcs, DDLFetcher fetcher) throws IOException {
        File f = new File(filePath);
        f.createNewFile();
        FileWriter fstream = new FileWriter(filePath);
        this.m_ddlFile = new BufferedWriter(fstream);
        this.writeScriptHeader(dataSrcs);
        fetcher.start();
        while (fetcher.hasNext()) {
            DDLTable dbQS = fetcher.next();
            if (!this.writeTableHeader(dbQS)) continue;
            dbQS.start();
            while (dbQS.hasNext()) {
                DDLColumn qi = dbQS.next();
                String colName = qi.getExternalName();
                if (colName == null) continue;
                this.writeColumn(qi, dbQS.hasNext());
            }
            this.writeCreateTableFooter();
        }
        this.writeScriptFooter();
        this.m_ddlFile.flush();
        this.m_ddlFile.close();
        this.m_ddlFile = null;
    }

    protected abstract void writeColumn(DDLColumn var1, boolean var2) throws IOException;

    private boolean writeTableHeader(DDLTable dbQS) throws IOException {
        boolean foundTableName = dbQS.foundTableName();
        String schemaName = dbQS.getSchemaName();
        String tableName = dbQS.getTableName();
        if (foundTableName) {
            this.writeCreateTableHeader(schemaName, tableName);
        }
        return foundTableName;
    }

    protected String nullableValue(DDLColumn qi) {
        if (qi.getNullable()) {
            return "NULL";
        }
        return "NOT NULL";
    }

    protected abstract void writeCreateTableHeader(String var1, String var2) throws IOException;

    protected abstract void writeCreateTableFooter() throws IOException;

    protected abstract String getDataType(DDLColumn var1);

    protected void writeScriptHeader(List<DataSource> dataSrcs) throws IOException {
    }

    protected void writeScriptFooter() throws IOException {
    }
}

