/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLGenerator;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import java.io.IOException;

public class DDLGeneratorDB2
extends DDLGenerator {
    protected String getDataType(DDLColumn qi) {
        FmDatatype dt = qi.getDatatype();
        if (dt == FmDatatype.NVARCHAR) {
            return "VARCHAR(" + qi.getSize() + ")";
        }
        if (dt == FmDatatype.INT32) {
            return "INTEGER";
        }
        if (dt == FmDatatype.INT16) {
            return "INTEGER";
        }
        if (dt == FmDatatype.INT64) {
            return "BIGINT";
        }
        if (dt == FmDatatype.BLOB) {
            return "BLOB";
        }
        if (dt == FmDatatype.CHARACTER) {
            return "CHAR(" + qi.getSize() + ")";
        }
        if (dt == FmDatatype.DATE) {
            return "DATE";
        }
        if (dt == FmDatatype.DECIMAL) {
            return "DECIMAL";
        }
        if (dt == FmDatatype.FLOAT64) {
            return "DOUBLE";
        }
        if (dt == FmDatatype.FLOAT) {
            return "FLOAT";
        }
        if (dt == FmDatatype.FLOAT32) {
            return "FLOAT";
        }
        if (dt == FmDatatype.NUMERIC) {
            return "NUMERIC";
        }
        if (dt == FmDatatype.TIME) {
            return "TIME";
        }
        if (dt == FmDatatype.TIMESTAMPTZ) {
            return "TIMESTAMP";
        }
        if (dt == FmDatatype.DATETIME) {
            return "DATE";
        }
        if (dt == FmDatatype.CHARACTERLENGTH16) {
            return "VARCHAR";
        }
        return "unknown - " + qi.getDatatype().toString();
    }

    protected void writeCreateTableHeader(String schemaName, String tableName) throws IOException {
        this.m_ddlFile.write("\nCREATE TABLE \"" + schemaName + "\".\"" + tableName + "\"" + "(\n");
    }

    protected void writeCreateTableFooter() throws IOException {
        this.m_ddlFile.write("\n);\n");
    }

    protected void writeColumn(DDLColumn qi, boolean hasNext) throws IOException {
        String colName = qi.getExternalName();
        if (colName != null) {
            this.m_ddlFile.write("\t\"" + colName + "\" " + this.getDataType(qi) + " " + this.nullableValue(qi));
            if (hasNext) {
                this.m_ddlFile.write(",");
            }
            this.m_ddlFile.write("\n");
        }
    }
}

