/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLGenerator;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLGeneratorSQLServer
extends DDLGenerator {
    @Override
    protected String getDataType(DDLColumn qi) {
        switch (qi.getDatatype()) {
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INTEGER";
            }
            case INT64: {
                return "BIGINT";
            }
            case CHARACTER: {
                return "CHAR";
            }
            case CHARACTERLENGTH16: {
                return "VARCHAR";
            }
            case NVARCHAR: {
                return "NVARCHAR";
            }
            case DECIMAL: {
                return "DECIMAL";
            }
            case DATE: {
                return "DATE";
            }
            case DATETIME: {
                return "DATETIME";
            }
            case FLOAT64: {
                return "FLOAT";
            }
            case TEXTBLOB: {
                return "NVARCHAR";
            }
        }
        return "unknown - " + qi.getDatatype().toString();
    }

    @Override
    protected void writeScriptHeader(List<DataSource> dataSrcs) throws IOException {
        this.m_ddlFile.write("USE [master]\n");
        this.m_ddlFile.write("\n");
        this.m_ddlFile.write("GO\n");
        this.m_ddlFile.write("\n");
        LinkedHashMap dbs = new LinkedHashMap();
        for (DataSource ds : dataSrcs) {
            String db = ds.getCmDataSourceName();
            if (!dbs.containsKey(db)) {
                dbs.put(db, new LinkedHashSet());
            }
            ((LinkedHashSet)dbs.get(db)).add(ds.getSchemaName());
        }
        for (String db : dbs.keySet()) {
            this.m_ddlFile.write("/****** Object:  Database [" + db + "]    Script Date: 07/11/2013 13:32:04 ******/\n");
            this.m_ddlFile.write("IF  EXISTS (SELECT name FROM sys.databases WHERE name = N'" + db + "')\n");
            this.m_ddlFile.write("DROP DATABASE [" + db + "]\n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("USE [master]\n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("/****** Object:  Database [" + db + "]    Script Date: 07/11/2013 13:32:04 ******/\n");
            this.m_ddlFile.write("CREATE DATABASE [" + db + "] ON  PRIMARY \n");
            this.m_ddlFile.write("( NAME = N'" + db + "', FILENAME = N'C:\\Program Files\\Microsoft SQL Server\\MSSQL10_50.MSSQLSERVER\\MSSQL\\DATA\\" + db + ".mdf' , SIZE = 6144KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )\n");
            this.m_ddlFile.write(" LOG ON \n");
            this.m_ddlFile.write("( NAME = N'" + db + "_log', FILENAME = N'C:\\Program Files\\Microsoft SQL Server\\MSSQL10_50.MSSQLSERVER\\MSSQL\\DATA\\" + db + "_log.ldf' , SIZE = 1280KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)\n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET COMPATIBILITY_LEVEL = 100\n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))\n");
            this.m_ddlFile.write("begin\n");
            this.m_ddlFile.write("EXEC [" + db + "].[dbo].[sp_fulltext_database] @action = 'enable'\n");
            this.m_ddlFile.write("end\n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET ANSI_NULL_DEFAULT OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET ANSI_NULLS OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET ANSI_PADDING OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET ANSI_WARNINGS OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET ARITHABORT OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET AUTO_CLOSE OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET AUTO_CREATE_STATISTICS ON \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET AUTO_SHRINK OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET AUTO_UPDATE_STATISTICS ON \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET CURSOR_CLOSE_ON_COMMIT OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET CURSOR_DEFAULT  GLOBAL \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET CONCAT_NULL_YIELDS_NULL OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET NUMERIC_ROUNDABORT OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET QUOTED_IDENTIFIER OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET RECURSIVE_TRIGGERS OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET  DISABLE_BROKER \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET AUTO_UPDATE_STATISTICS_ASYNC OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET DATE_CORRELATION_OPTIMIZATION OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET TRUSTWORTHY OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET ALLOW_SNAPSHOT_ISOLATION OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET PARAMETERIZATION SIMPLE \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET READ_COMMITTED_SNAPSHOT OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET HONOR_BROKER_PRIORITY OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET  READ_WRITE \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET RECOVERY FULL \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET  MULTI_USER \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET PAGE_VERIFY CHECKSUM  \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("ALTER DATABASE [" + db + "] SET DB_CHAINING OFF \n");
            this.m_ddlFile.write("GO\n");
            this.m_ddlFile.write("\n");
            this.m_ddlFile.write("use [" + db + "]\ngo\n\n");
            LinkedHashSet schemas = (LinkedHashSet)dbs.get(db);
            for (String schema : schemas) {
                this.m_ddlFile.write("CREATE SCHEMA [" + schema + "] authorization [dbo]\n");
                this.m_ddlFile.write("GO\n");
                this.m_ddlFile.write("\n");
            }
        }
    }

    @Override
    protected void writeCreateTableHeader(String schemaName, String tableName) throws IOException {
        this.m_ddlFile.write("\nCREATE TABLE [" + schemaName + "].[" + tableName + "]" + "(\n");
    }

    @Override
    protected void writeCreateTableFooter() throws IOException {
        this.m_ddlFile.write(") ON [PRIMARY]\nGO\n\n");
    }

    @Override
    protected void writeColumn(DDLColumn qi, boolean hasNext) throws IOException {
        String colName = qi.getExternalName();
        FmDatatype dt = qi.getDatatype();
        String size = "";
        if (FmDatatype.isString(dt).booleanValue()) {
            size = "(" + qi.getSize() + ")";
        }
        if (colName != null) {
            this.m_ddlFile.write("\t[" + colName + "] [" + this.getDataType(qi) + "]" + size + " " + this.nullableValue(qi));
            if (hasNext) {
                this.m_ddlFile.write(",");
            }
            this.m_ddlFile.write("\n");
        }
    }
}

