/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackContext;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestAttributeReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestChangeFilterUsage;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestCreateMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestDeleteEmptySecurityViews;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestDeleteInvalidAggregationRules;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestDeleteJoins;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestDeleteLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestDeleteLevelsWithNoSources;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestDeleteObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestMoveLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestRemoveSecurityFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestion;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmSuggestions;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FilterApplication;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Suggestions;
import com.ibm.cognos.fmeng.fmmd.model.TaskAnalyseObject;
import com.ibm.cognos.fmeng.fmmd.model.TaskSuggestFixes;
import com.ibm.cognos.fmeng.fmmd.util.FmRoute;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutes;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.icu.util.LocaleData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTaskSuggestFixes
implements TaskSuggestFixes {
    private static FmTaskSuggestFixes m_Instance = null;
    private TaskAnalyseObject m_Analysis = null;
    private FMMDSession m_Session;

    public static FmTaskSuggestFixes getInstance(FMMDSession session) {
        if (m_Instance == null) {
            m_Instance = new FmTaskSuggestFixes(session);
        }
        return m_Instance;
    }

    private FmTaskSuggestFixes(FMMDSession session) {
        this.m_Session = session;
        this.m_Analysis = session.getTaskAnalyseObject();
    }

    @Override
    public Suggestions getSuggestions(FeedbackMessage message) {
        return this.getSuggestions(message, TaskAnalyseObject.AnalysisContext.publish);
    }

    @Override
    public Suggestions getSuggestions(FeedbackMessage message, TaskAnalyseObject.AnalysisContext context) {
        FmSuggestions suggestions = new FmSuggestions();
        FeedbackMessage messageOfInterest = null;
        ArrayList<FeedbackMessage> messages = new ArrayList<FeedbackMessage>();
        for (BaseObject object : message.getObjects()) {
            this.m_Analysis.analyseObject(object, context, messages);
        }
        for (FeedbackMessage newMessage : messages) {
            if (!((FmFeedbackMessage)newMessage).equals(message)) continue;
            messageOfInterest = newMessage;
            break;
        }
        if (messageOfInterest == null) {
            return suggestions;
        }
        FmFeedbackMessage feedbackMessage = (FmFeedbackMessage)messageOfInterest;
        switch (feedbackMessage.getFeedbackCode()) {
            case UNABLE_TO_REWRITE_EXPRESSION: 
            case UNSUPPORTED_DATATYPE_FOR_MEASURE: 
            case UNSUPPORTED_DATATYPE_FOR_QUERY_ITEM: {
                this.deleteObject(feedbackMessage, suggestions);
                break;
            }
            case NO_MEASURE_DIMENSIONS_FOUND: {
                this.createMeasureDimension(feedbackMessage, suggestions);
                break;
            }
            case MULTIPLE_JOINED_TABLES: {
                this.deleteJoins(feedbackMessage, suggestions);
                break;
            }
            case AMBIGUOUS_JOIN_PATH: {
                this.deleteJoinPaths(feedbackMessage, suggestions);
                break;
            }
            case CIRCULAR_JOINS: {
                this.breakCircularJoins(feedbackMessage, suggestions);
                break;
            }
            case HIERARCHY_BAD_ALL_LEVEL: {
                this.moveLevel(feedbackMessage, suggestions, true);
                this.deleteLevelReference(feedbackMessage, suggestions);
                break;
            }
            case HIERARCHY_MULTIPLE_ALL_LEVELS: {
                this.deleteLevelReference(feedbackMessage, suggestions);
                break;
            }
            case UNKNOWN_ATTRIBUTE_REFERENCE: {
                this.substituteReferences(feedbackMessage, suggestions);
                break;
            }
            case EMPTY_SECURITY_VIEWS_IN_CUBE: {
                this.deleteEmptySecurityViews(feedbackMessage, suggestions);
                break;
            }
            case INVALID_SEMI_AGGREGATE: 
            case NO_AGGREGATE_RULES_FOR_UNKNOWN: {
                this.deleteInvalidSemiAggregates(feedbackMessage, suggestions);
                break;
            }
            case NO_SOURCE_OBJECTS_LEVELS: {
                this.deleteLevelsWithNoSources(feedbackMessage, suggestions);
                break;
            }
            case WRONG_FILTER_USAGE_FOR_SECURITY: {
                this.changeFilterUsage(feedbackMessage, suggestions);
                this.removeFilterFromSecurityViews(feedbackMessage, suggestions);
                break;
            }
        }
        return suggestions;
    }

    private void removeFilterFromSecurityViews(FmFeedbackMessage feedbackMessage, FmSuggestions suggestions) {
        List<BaseObject> objects = feedbackMessage.getObjects();
        FmMDException.ASSERT(objects.size() == 3, "Bad number of objects for message WRONG_FILTER_USAGE_FOR_SECURITY");
        FmMDException.ASSERT(objects.get(1) instanceof FmRelationalFilter, "Bad object 2 for message WRONG_FILTER_USAGE_FOR_SECURITY: " + objects.get(1).toString());
        FmMDException.ASSERT(objects.get(2) instanceof FmPackage, "Bad object 3 for message WRONG_FILTER_USAGE_FOR_SECURITY: " + objects.get(2).toString());
        suggestions.add(new FmSuggestRemoveSecurityFilter((FmPackage)objects.get(2), (FmRelationalFilter)objects.get(1)));
    }

    private void changeFilterUsage(FmFeedbackMessage feedbackMessage, FmSuggestions suggestions) {
        List<BaseObject> objects = feedbackMessage.getObjects();
        FmMDException.ASSERT(objects.size() == 3, "Bad number of objects for message WRONG_FILTER_USAGE_FOR_SECURITY");
        FmMDException.ASSERT(objects.get(1) instanceof FmRelationalFilter, "Bad object 2 for message WRONG_FILTER_USAGE_FOR_SECURITY: " + objects.get(1).toString());
        FmMDException.ASSERT(objects.get(2) instanceof FmPackage, "Bad object 3 for message WRONG_FILTER_USAGE_FOR_SECURITY: " + objects.get(2).toString());
        suggestions.add(new FmSuggestChangeFilterUsage((FmRelationalFilter)objects.get(1), FilterApplication.EFilterApplication.security));
    }

    private void deleteLevelsWithNoSources(FmFeedbackMessage feedbackMessage, FmSuggestions suggestions) {
        FmMDException.ASSERT(feedbackMessage.getObjects().get(0) instanceof FmVirtualHierarchy, "Bad object for message NO_SOURCE_OBJECTS_LEVELS");
        FmVirtualHierarchy hier = (FmVirtualHierarchy)feedbackMessage.getObjects().get(0);
        suggestions.add(new FmSuggestDeleteLevelsWithNoSources(hier));
    }

    private void deleteInvalidSemiAggregates(FmFeedbackMessage foo, FmSuggestions suggestions) {
        Measure measure = (Measure)foo.getObjects().get(0);
        suggestions.add(new FmSuggestDeleteInvalidAggregationRules(measure));
    }

    private void deleteEmptySecurityViews(FmFeedbackMessage foo, FmSuggestions suggestions) {
        Cube cube = (Cube)foo.getObjects().get(0);
        suggestions.add(new FmSuggestDeleteEmptySecurityViews(cube));
    }

    private void substituteReferences(FmFeedbackMessage foo, FmSuggestions suggestions) {
        FmMDException.ASSERT(foo.getObjects().size() >= 2, "Two objects");
        FmMDException.ASSERT(foo.getObjects().get(1) instanceof FmQueryItem, "Second object is not a query item");
        FmBaseObject src = (FmBaseObject)foo.getObjects().get(0);
        FmQueryItem item = (FmQueryItem)foo.getObjects().get(1);
        FmRelationalDimension dim = (FmRelationalDimension)item.getRelationalParent();
        for (RelationalHierarchy hier : dim.getAllHierarchies()) {
            suggestions.add(new FmSuggestAttributeReference(hier, src, item));
        }
    }

    private void moveLevel(FmFeedbackMessage foo, FmSuggestions suggestions, boolean moveToTop) {
        FmMDException.ASSERT(foo.getObjects().size() >= 2, "Two objects");
        FmMDException.ASSERT(foo.getObjects().get(0) instanceof FmRelationalHierarchy, "First object is not a hierarchy");
        FmMDException.ASSERT(foo.getObjects().get(1) instanceof FmLevel, "Second object is not a level");
        FmRelationalHierarchy hier = (FmRelationalHierarchy)foo.getObjects().get(0);
        FmLevel level = (FmLevel)foo.getObjects().get(1);
        suggestions.add(new FmSuggestMoveLevelReference(hier, level, moveToTop));
    }

    private void deleteLevelReference(FmFeedbackMessage foo, FmSuggestions suggestions) {
        FmMDException.ASSERT(foo.getObjects().size() >= 2, "Two objects");
        FmMDException.ASSERT(foo.getObjects().get(0) instanceof FmRelationalHierarchy, "First object is not a hierarchy");
        FmMDException.ASSERT(foo.getObjects().get(1) instanceof FmLevel, "Second object is not a level");
        FmRelationalHierarchy hier = (FmRelationalHierarchy)foo.getObjects().get(0);
        FmLevel level = (FmLevel)foo.getObjects().get(1);
        suggestions.add(new FmSuggestDeleteLevelReference(hier, level));
    }

    private void breakCircularJoins(FmFeedbackMessage foo, FmSuggestions suggestions) {
        FmRoutes<FmTable, FmJoin> routes = foo.getContext().getRoutes();
        FmRoute<FmTable, FmJoin> route = routes.getRoute(0);
        for (FmJoin join : route.getJoinList()) {
            String tableList = "";
            int otherJoinCount = 0;
            for (FmJoin otherJoin : route.getJoinList()) {
                if (join.equals(otherJoin)) continue;
                if (tableList.equals("")) {
                    tableList = otherJoin.getStart().getName();
                }
                tableList = String.valueOf(tableList) + " -> " + otherJoin.getEnd().getName();
                ++otherJoinCount;
            }
            FmSuggestDeleteJoins del = otherJoinCount == 1 ? new FmSuggestDeleteJoins("BMT_MDA_CIRCULAR_JOIN", tableList) : new FmSuggestDeleteJoins("BMT_MDA_CIRCULAR_JOINS", tableList);
            del.addJoin(join);
            for (FmJoin otherJoin : route.getJoinList()) {
                if (join.equals(otherJoin)) continue;
                del.addContextJoin(otherJoin);
            }
            suggestions.add(del);
        }
    }

    private void deleteJoinPaths(FmFeedbackMessage msg, FmSuggestions suggestions) {
        ArrayList<FmSuggestion> tempSuggestions;
        FmFeedbackContext context = msg.getContext();
        FmRoutes<FmTable, FmJoin> routes = context.getRoutes();
        if (this.deleteJoinPathsSmart(routes, tempSuggestions = new ArrayList<FmSuggestion>())) {
            suggestions.add(tempSuggestions);
            return;
        }
        tempSuggestions = new ArrayList();
        if (this.deleteJoinPathsDumb(routes, tempSuggestions)) {
            suggestions.add(tempSuggestions);
            return;
        }
    }

    private boolean deleteJoinPathsSmart(FmRoutes<FmTable, FmJoin> routes, List<FmSuggestion> suggestions) {
        FmRoutes oldRoutes = new FmRoutes(this.m_Session.m_RoutesGovernor.get());
        int joinindex = 0;
        FmRoutes<FmTable, FmJoin> candidateRoutes = new FmRoutes<FmTable, FmJoin>(this.m_Session.m_RoutesGovernor.get());
        HashMap breakCandidatesTemp = new HashMap();
        Vector<FmJoin> breakCandidates = null;
        candidateRoutes.addAll(routes);
        boolean unique = true;
        int i = 0;
        while (i < candidateRoutes.size()) {
            unique = true;
            FmRoute candidateRoute = candidateRoutes.getRoute(i);
            breakCandidates = new Vector<FmJoin>();
            if (joinindex == candidateRoute.getJoinCount()) {
                return false;
            }
            for (FmJoin nthJoin1 : candidateRoute.getJoinList()) {
                if (nthJoin1 == null) break;
                int j = 0;
                while (j < candidateRoutes.size() && unique) {
                    FmRoute otherRoute;
                    if (i != j && joinindex != (otherRoute = candidateRoutes.getRoute(j)).getJoinCount()) {
                        for (FmJoin nthJoin2 : otherRoute.getJoinList()) {
                            boolean bl = unique = !nthJoin1.equals(nthJoin2);
                            if (!unique) break;
                        }
                    }
                    ++j;
                }
                if (!unique) continue;
                breakCandidates.add(nthJoin1);
            }
            breakCandidatesTemp.put(candidateRoute.toString(), breakCandidates);
            oldRoutes.addRoute(candidateRoute);
            candidateRoutes.remove(i);
        }
        i = 0;
        while (i < breakCandidatesTemp.size()) {
            FmRoute routeMain = oldRoutes.getRoute(i);
            FmSuggestDeleteJoins deleteJoins = new FmSuggestDeleteJoins("BMT_MDA_USE_JOIN_PATH", routeMain.toString());
            deleteJoins.addContextJoins(routeMain.getJoinList());
            for (Map.Entry entry : breakCandidatesTemp.entrySet()) {
                if (((String)entry.getKey()).equals(routeMain.toString())) continue;
                for (FmJoin joinToBreak : (Vector)entry.getValue()) {
                    deleteJoins.addJoin(joinToBreak);
                }
            }
            suggestions.add(deleteJoins);
            ++i;
        }
        return true;
    }

    private boolean deleteJoinPathsDumb(FmRoutes<FmTable, FmJoin> routes, List<FmSuggestion> suggestions) {
        TreeSet<FmJoin> alljoins = new TreeSet<FmJoin>();
        for (FmRoute<FmTable, FmJoin> route : routes.getAllRoutes()) {
            for (FmJoin join : route.getJoinList()) {
                alljoins.add(join);
            }
        }
        for (FmRoute<FmTable, FmJoin> route : routes.getAllRoutes()) {
            TreeSet joinsToBreak = new TreeSet(alljoins);
            StringBuilder joinPath = new StringBuilder();
            for (FmJoin join : route.getJoinList()) {
                joinsToBreak.remove(join);
                if (joinPath.length() > 0) {
                    joinPath.append(join.getStart().getName());
                    joinPath.append("-->");
                }
                joinPath.append(join.getStart().getName());
            }
            FmSuggestDeleteJoins deleteJoins = new FmSuggestDeleteJoins("BMT_MDA_USE_JOIN_PATH", joinPath.toString());
            deleteJoins.addContextJoins(route.getJoinList());
            for (FmJoin joinToBreak : joinsToBreak) {
                deleteJoins.addJoin(joinToBreak);
            }
            suggestions.add(deleteJoins);
        }
        return true;
    }

    private void deleteJoins(FmFeedbackMessage msg, FmSuggestions suggestions) {
        FmFeedbackContext foo = msg.getContext();
        List<Join> contextJoins = foo.getContextJoins();
        if (contextJoins.size() < 2) {
            return;
        }
        for (Join join1 : foo.getContextJoins()) {
            List<Association> associations = join1.getAssociations();
            String rightColumn = "";
            String leftColumn = "";
            int i = 0;
            while (i < associations.size()) {
                if (i == 0) {
                    rightColumn = associations.get(i).getRightColumn();
                    leftColumn = associations.get(i).getLeftColumn();
                } else {
                    rightColumn = String.valueOf(rightColumn) + LocaleData.getInstance().getLocaleSeparator() + associations.get(i).getRightColumn();
                    leftColumn = String.valueOf(leftColumn) + LocaleData.getInstance().getLocaleSeparator() + associations.get(i).getLeftColumn();
                }
                ++i;
            }
            FmSuggestDeleteJoins suggestion = new FmSuggestDeleteJoins("BMT_MDA_USE_JOIN", rightColumn, leftColumn);
            suggestion.addContextJoin(join1);
            for (Join join2 : foo.getContextJoins()) {
                if (join1.equals(join2)) continue;
                suggestion.addJoin(join2);
            }
            suggestions.add(suggestion);
        }
    }

    private void createMeasureDimension(FmFeedbackMessage message, FmSuggestions suggestions) {
        if (message.getObjects().get(0) instanceof Cube) {
            suggestions.add(new FmSuggestCreateMeasureDimension((Cube)message.getObjects().get(0)));
        }
    }

    private void deleteObject(FmFeedbackMessage msg, FmSuggestions suggestions) {
        if (msg.getObjects().get(0) instanceof ReportObject) {
            ReportObject qi = (ReportObject)msg.getObjects().get(0);
            if (qi.getParent() instanceof FmRelationalQuerySubject) {
                FmSuggestDeleteObject suggestion = new FmSuggestDeleteObject(qi, "BMT_MDA_DELETE_QUERY_ITEM");
                suggestions.add(suggestion);
            } else {
                FmSuggestDeleteObject suggestion = new FmSuggestDeleteObject(qi, "BMT_MDA_DELETE_ATTRIBUTE");
                suggestions.add(suggestion);
            }
        }
    }
}

