/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.CopyListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.util.CopyRelationshipsHelper;
import com.ibm.cognos.fmeng.fmmd.util.ObjectReferenceHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDependentRelationships {
    public static void copy(CopyListener listener, Relationship plannedRelationship) {
        if (CreateDependentRelationships.hasDependentRelationships(plannedRelationship)) {
            listener.handleEvent();
        }
    }

    public static void copy(Relationship plannedRelationship) {
        Expression hExpression = plannedRelationship.getExpression();
        RelationshipEnd leftEnd = plannedRelationship.getLeftEnd();
        RelationshipEnd rightEnd = plannedRelationship.getRightEnd();
        CreateDependentRelationships.doCopyDependentRelationships(leftEnd, rightEnd, hExpression);
        CreateDependentRelationships.doCopyDependentRelationships(rightEnd, leftEnd, hExpression);
    }

    private static boolean hasDependentRelationships(Relationship plannedRelationship) {
        RelationshipEnd rightEnd;
        boolean bDependentRelationshipsFound = false;
        RelationshipEnd leftEnd = plannedRelationship.getLeftEnd();
        bDependentRelationshipsFound = CreateDependentRelationships.checkDependentRelationships(leftEnd, rightEnd = plannedRelationship.getRightEnd()) || CreateDependentRelationships.checkDependentRelationships(rightEnd, leftEnd);
        return bDependentRelationshipsFound;
    }

    private static boolean checkDependentRelationships(RelationshipEnd firstEnd, RelationshipEnd otherEnd) {
        boolean bDependentRelationshipsFound = false;
        RelationshipEnd theEnd = firstEnd;
        FmObjectType sObjType = theEnd.getFmObjectType();
        if (sObjType == FmObjectType.shortcut) {
            Shortcut objShortcut = (Shortcut)firstEnd;
            theEnd = (RelationshipEnd)((Object)objShortcut.getRefobj());
        }
        if (CreateDependentRelationships.isDependentEnd(firstEnd)) {
            RelationshipBase theSingleRelationship;
            FmQuerySubject querySubject = (FmQuerySubject)theEnd;
            List<QuerySubjectBase> vTargetModelQueries = CreateDependentRelationships.getTargetModelQueries(querySubject);
            ArrayList<ReportObject> selectedQItems = new ArrayList<ReportObject>();
            for (QuerySubjectBase qs : vTargetModelQueries) {
                selectedQItems.addAll(qs.getAllQueryItems());
            }
            ArrayList<RelationshipBase> hRelationships = new ArrayList<RelationshipBase>();
            CopyRelationshipsHelper helper = new CopyRelationshipsHelper(querySubject, vTargetModelQueries, selectedQItems, null);
            helper.findAllRelationships(hRelationships);
            bDependentRelationshipsFound = !hRelationships.isEmpty();
            RelationshipBase relationshipBase = theSingleRelationship = hRelationships.size() == 1 ? (RelationshipBase)hRelationships.get(0) : null;
            if (theSingleRelationship != null) {
                RelationshipEnd left = theSingleRelationship.getLeftEnd();
                RelationshipEnd right = theSingleRelationship.getRightEnd();
                bDependentRelationshipsFound = left != otherEnd && right != otherEnd;
            }
        }
        return bDependentRelationshipsFound;
    }

    private static boolean isDependentEnd(RelationshipEnd theEnd) {
        Project proj;
        List<Object> referencedRelationships;
        boolean bIsDependent = false;
        RelationshipEnd realEnd = theEnd;
        FmObjectType sObjType = theEnd.getFmObjectType();
        if (sObjType == FmObjectType.shortcut) {
            Shortcut objShortcut = (Shortcut)theEnd;
            realEnd = (RelationshipEnd)((Object)objShortcut.getRefobj());
        }
        if ((sObjType = realEnd.getFmObjectType()) == FmObjectType.querySubject && ((FmQuerySubjectBase)realEnd).getDefinitionType() == QuerySubjectBase.EDefinitionType.kTypeModelQuery && (referencedRelationships = ObjectReferenceHelper.getRelationshipsFor(proj = theEnd.getSession().getProject(), theEnd, true)) != null) {
            bIsDependent = referencedRelationships.size() == 1;
        }
        return bIsDependent;
    }

    private static void doCopyDependentRelationships(RelationshipEnd firstEnd, RelationshipEnd hOtherEnd, Expression joinExpr) {
        RelationshipEnd theEnd = firstEnd;
        FmObjectType sObjType = theEnd.getFmObjectType();
        if (sObjType == FmObjectType.shortcut) {
            Shortcut objShortcut = (Shortcut)firstEnd;
            theEnd = (RelationshipEnd)((Object)objShortcut.getRefobj());
        }
        if (CreateDependentRelationships.isDependentEnd(firstEnd)) {
            FMMDSession session = firstEnd.getSession();
            List<Object> referencedRelationships = ObjectReferenceHelper.getRelationshipsFor(session.getProject(), firstEnd, true);
            Relationship plannedRelationship = (Relationship)FmModelFactory.getInstance().get(session, referencedRelationships.get(0));
            List<QuerySubjectBase> vTargetModelQueries = CreateDependentRelationships.getTargetModelQueries((QuerySubject)theEnd);
            ArrayList<ReportObject> selectedQItems = new ArrayList<ReportObject>();
            for (QuerySubjectBase qs : vTargetModelQueries) {
                selectedQItems.addAll(qs.getAllQueryItems());
            }
            CopyRelationshipsHelper helper = new CopyRelationshipsHelper((QuerySubject)theEnd, vTargetModelQueries, selectedQItems, null);
            helper.copyRelationships();
            CopyRelationshipsHelper.handleDuplicateRelationships(plannedRelationship, firstEnd, hOtherEnd, joinExpr);
        }
    }

    private static List<QuerySubjectBase> getTargetModelQueries(QuerySubject qs) {
        ArrayList<QuerySubjectBase> vhTargetModelQueries = new ArrayList<QuerySubjectBase>();
        List<QueryItem> hTargets = CreateDependentRelationships.getTargetModelQueryItems(qs);
        for (QueryItem qi : hTargets) {
            QuerySubjectBase hParentQS = qi.getQueryParent();
            if (hParentQS == null || hParentQS.getFmObjectType() != FmObjectType.querySubject || vhTargetModelQueries.contains(hParentQS)) continue;
            vhTargetModelQueries.add((QuerySubject)hParentQS);
        }
        return vhTargetModelQueries;
    }

    private static List<QueryItem> getTargetModelQueryItems(QuerySubject qs) {
        ArrayList<QueryItem> hTargets = new ArrayList<QueryItem>();
        if (((FmQuerySubject)qs).getDefinitionType() != QuerySubjectBase.EDefinitionType.kTypeModelQuery) {
            return hTargets;
        }
        List<QueryItem> derivedQIs = qs.getAllQueryItems();
        if (derivedQIs != null) {
            for (QueryItem qi : derivedQIs) {
                List<ReportObject> hAllReference;
                Expression hExpr = qi.getExpression();
                if (hExpr == null || (hAllReference = hExpr.getRefObjs(true)) == null) continue;
                for (ReportObject objTarget : hAllReference) {
                    if (derivedQIs.contains(objTarget)) continue;
                    hTargets.add((QueryItem)objTarget);
                }
            }
        }
        return hTargets;
    }
}

