/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.EObjectSourceType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmScopeRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.util.ObjectReferenceHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.List;

public class FmAdjustScope {
    public static void doAdjust(FMMDSession session, RelationshipEnd hMeasureDim, RelationshipEnd hRegularDim, Measure hMeasure, Level hLevel, boolean exclusionVal) {
        FmDimension target;
        FmShortcut shortcut;
        if (((FmQuerySubjectBase)hMeasureDim).determineSourceType(null) == EObjectSourceType.kMultidimensional || ((FmQuerySubjectBase)hRegularDim).determineSourceType(null) == EObjectSourceType.kMultidimensional) {
            throw new FmMDException("BMT_MD_WARNING_NOT_ALLOW_MD_SCOPE_CHANGE");
        }
        FmObjectType objType = hMeasureDim.getFmObjectType();
        FmMDException.ASSERT(objType == FmObjectType.dimension || objType == FmObjectType.shortcut, "The first parameter must be a valid object of type measure dimension, or shortcut to such an object");
        if (objType == FmObjectType.shortcut) {
            shortcut = (FmShortcut)hMeasureDim;
            target = (FmDimension)shortcut.getRefobj();
            FmMDException.ASSERT(target != null && target.getDimensionStyle() == DimensionBase.DimensionStyle.measure, "Must be a measure dimension!");
        } else {
            FmMDException.ASSERT(((FmDimension)hMeasureDim).getDimensionStyle() == DimensionBase.DimensionStyle.measure, "Must be a measure dimension!");
        }
        objType = hRegularDim.getFmObjectType();
        FmMDException.ASSERT(objType == FmObjectType.dimension || objType == FmObjectType.shortcut, "The second parameter must be a valid object of type regular dimension, or shortcut to such an object");
        if (objType == FmObjectType.shortcut) {
            shortcut = (FmShortcut)hRegularDim;
            target = (FmDimension)shortcut.getRefobj();
            FmMDException.ASSERT(target != null && target.getDimensionStyle() == DimensionBase.DimensionStyle.regular, "Must be a regular dimension!");
        } else {
            FmMDException.ASSERT(((FmDimension)hRegularDim).getDimensionStyle() == DimensionBase.DimensionStyle.regular, "Must be a regular dimension!");
        }
        FmMDException.ASSERT(hMeasure.getQueryParent().equals(hMeasureDim), "measure item must belong to the measure dimension or its target");
        FmMDException.ASSERT(hLevel.getQueryParent().equals(hRegularDim), "level must belong to the regular dimension or its target");
        FmScopeRelationship hScopeRel = FmAdjustScope.getScopeRelationshipHandle(session, hMeasureDim, hRegularDim);
        if (hScopeRel == null) {
            hScopeRel = FmScopeRelationship.createObject(session, (FmDimension)hRegularDim, (FmDimension)hMeasureDim);
        }
        hScopeRel.adjustScope(hMeasure, hLevel, exclusionVal);
    }

    private static FmScopeRelationship getScopeRelationshipHandle(FMMDSession session, RelationshipEnd measureDim, RelationshipEnd regularDim) {
        List<Object> objs = ObjectReferenceHelper.getRelationshipsFor(session.getProject(), measureDim, false);
        if (objs != null) {
            for (Object obj : objs) {
                RelationshipEnd hLeftEnd;
                FmScopeRelationship scopeRel = (FmScopeRelationship)FmModelFactory.getInstance().get(session, obj);
                if (scopeRel == null || !(hLeftEnd = scopeRel.getLeftEnd()).equals(regularDim)) continue;
                return scopeRel;
            }
        }
        return null;
    }
}

