/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.MoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.NecessaryGenericEMFAddCaller;
import com.ibm.cognos.fmeng.fmmd.model.AttributeReference;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Guid;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.QueryChild;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.fmmd.util.ObjectReferenceHelper;
import com.ibm.cognos.fmeng.fmmd.util.SearchFilter;
import com.ibm.cognos.fmeng.genmodel.AggregateCubesType;
import com.ibm.cognos.fmeng.genmodel.LevelsType;
import com.ibm.cognos.fmeng.genmodel.ModelObjectType;
import com.ibm.cognos.fmeng.genmodel.ReportObjectType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmCopyManager
implements NecessaryGenericEMFAddCaller {
    private FMMDSession m_session;
    private FmBaseObject m_targetObj;
    private List<? extends BaseObject> m_sourceObjs;

    private FmCopyManager(FMMDSession session, BaseObject targetParent, List<? extends BaseObject> sourceObjs) {
        this.m_session = session;
        this.m_targetObj = (FmBaseObject)targetParent;
        this.m_sourceObjs = sourceObjs;
    }

    public static List<BaseObject> copy(FMMDSession session, BaseObject targetParent, BaseObject ... sourceObjs) {
        FmCopyManager copyManager = new FmCopyManager(session, targetParent, Arrays.asList(sourceObjs));
        return copyManager.startCopying();
    }

    public static List<BaseObject> copy(FMMDSession session, BaseObject targetParent, List<? extends BaseObject> sourceObjs) {
        FmCopyManager copyManager = new FmCopyManager(session, targetParent, sourceObjs);
        return copyManager.startCopying();
    }

    public static List<BaseObject> copyChildrenOf(FMMDSession session, BaseObject targetParent, BaseObject sourceParent) {
        ArrayList<BaseObject> sources = new ArrayList<BaseObject>();
        sources.add(sourceParent);
        FmCopyManager copyManager = new FmCopyManager(session, targetParent, sources);
        return copyManager.startCopyingChildren();
    }

    public static void move(FMMDSession session, BaseObject targetParent, TopLevelObject sourceObj, MoveListener listener) {
        ArrayList<TopLevelObject> sourceObjs = new ArrayList<TopLevelObject>(1);
        sourceObjs.add(sourceObj);
        FmCopyManager copyManager = new FmCopyManager(session, targetParent, sourceObjs);
        copyManager.startMoving(listener);
    }

    public static void move(FMMDSession session, BaseObject targetParent, List<? extends TopLevelObject> sourceObjs, MoveListener listener) {
        FmCopyManager copyManager = new FmCopyManager(session, targetParent, sourceObjs);
        copyManager.startMoving(listener);
    }

    private List<BaseObject> startCopying() {
        this.validate();
        LinkedHashSet<EObject> objectsToCopy = new LinkedHashSet<EObject>();
        int i = 0;
        while (i < this.m_sourceObjs.size()) {
            FmBaseObject obj = (FmBaseObject)this.m_sourceObjs.get(i);
            objectsToCopy.add((EObject)obj.getInternal());
            if (obj instanceof FmQuerySubjectBase) {
                this.addRelationships(objectsToCopy, (FmQuerySubjectBase)obj);
            }
            ++i;
        }
        return this.copyObjects(objectsToCopy);
    }

    private List<BaseObject> startCopyingChildren() {
        FmBaseObject sourceParent = (FmBaseObject)this.m_sourceObjs.get(0);
        this.m_sourceObjs = new ArrayList<BaseObject>(sourceParent.getChildObjects());
        this.validate();
        LinkedHashSet<EObject> objectsToCopy = new LinkedHashSet<EObject>();
        for (Object eChild : ((EMFSession)this.m_session).getGateway().getChildren(sourceParent.getInternal())) {
            objectsToCopy.add((EObject)eChild);
            TopLevelObject obj = FmModelFactory.getInstance().get(this.m_session, eChild);
            if (!(obj instanceof FmQuerySubjectBase)) continue;
            this.addRelationships(objectsToCopy, (FmQuerySubjectBase)obj);
        }
        return this.copyObjects(objectsToCopy);
    }

    private List<BaseObject> copyObjects(LinkedHashSet<EObject> objectsToCopy) {
        Collection copiedObjects = EcoreUtil.copyAll(objectsToCopy);
        ArrayList<BaseObject> copiedObjs = new ArrayList<BaseObject>();
        for (EObject copy : copiedObjects) {
            FmBaseObject fmCopy = (FmBaseObject)((Object)FmModelFactory.getInstance().get(this.m_session, copy));
            if (fmCopy != null) {
                Guid guid;
                if (this.m_targetObj != null) {
                    fmCopy.postCopyAdoption(this.m_targetObj);
                }
                copiedObjs.add(fmCopy);
                if (!(fmCopy instanceof Guid) || (guid = (Guid)((Object)fmCopy)).getGuid() == null) continue;
                this.updateGuids(copy);
                continue;
            }
            EObject parent = (EObject)this.m_targetObj.getInternal();
            for (EStructuralFeature feature : copy.eClass().getEAllStructuralFeatures()) {
                parent.eSet(feature, (Object)copy);
            }
        }
        return copiedObjs;
    }

    private void updateGuids(EObject obj) {
        Object rot;
        if (obj instanceof ReportObjectType) {
            rot = (ReportObjectType)obj;
            if (rot.getGuid() != null) {
                rot.setGuid(UUID.randomUUID().toString());
            }
        } else if (obj instanceof ModelObjectType && (rot = (ModelObjectType)obj).getGuid() != null) {
            rot.setGuid(UUID.randomUUID().toString());
        }
        TreeIterator allContents = obj.eAllContents();
        while (allContents.hasNext()) {
            EObject currentObj = (EObject)allContents.next();
            if (currentObj instanceof ReportObjectType) {
                ReportObjectType rot2 = (ReportObjectType)currentObj;
                if (rot2.getGuid() == null) continue;
                rot2.setGuid(UUID.randomUUID().toString());
                continue;
            }
            if (currentObj instanceof ModelObjectType) {
                ModelObjectType rot3 = (ModelObjectType)currentObj;
                if (rot3.getGuid() == null) continue;
                rot3.setGuid(UUID.randomUUID().toString());
                continue;
            }
            boolean prune = true;
            if (currentObj instanceof LevelsType || currentObj instanceof AggregateCubesType) {
                prune = false;
            }
            if (!prune) continue;
            allContents.prune();
        }
    }

    private void addRelationships(Set<EObject> dependentItems, FmQuerySubjectBase querySubject) {
        List<Object> relationships = ObjectReferenceHelper.getRelationshipsFor(this.m_session.getProject(), querySubject, true);
        if (relationships != null) {
            Iterator<Object> iter = relationships.iterator();
            while (iter.hasNext()) {
                dependentItems.add((EObject)iter.next());
            }
        }
    }

    private void startMoving(MoveListener listener) {
        FmLevel level;
        this.validate();
        QuerySubjectBase querySubjectTarget = null;
        if (this.m_targetObj instanceof FmQuerySubjectBase) {
            querySubjectTarget = (FmQuerySubjectBase)this.m_targetObj;
        } else if (this.m_targetObj instanceof QueryChild) {
            querySubjectTarget = ((QueryChild)((Object)this.m_targetObj)).getQueryParent();
        }
        if (this.m_targetObj instanceof FmMeasure) {
            FmMDException exc = new FmMDException("BMT_MD_COPY_INVALID_TARGET");
            throw exc;
        }
        if (this.m_targetObj instanceof FmLevel && (level = (FmLevel)this.m_targetObj).isAllLevel()) {
            FmMDException exc = new FmMDException("BMT_MD_ALL_LEVEL_UNSUPPORTED_OPERATION");
            throw exc;
        }
        int i = 0;
        while (i < this.m_sourceObjs.size()) {
            QueryChild qc;
            FmBaseObject obj = (FmBaseObject)this.m_sourceObjs.get(i);
            if (querySubjectTarget != null && obj instanceof QueryChild && !querySubjectTarget.equals((qc = (QueryChild)((Object)obj)).getQueryParent())) {
                FmMDException exc = new FmMDException("BMT_MD_MOVE_TO_QS_OR_QIF");
                throw exc;
            }
            obj.moveObject(this.m_targetObj, listener);
            ++i;
        }
        this.correctRelationships(this.m_sourceObjs);
        this.correctAttributeReferences();
        this.correctAttributeRoles();
    }

    private void correctAttributeRoles() {
        for (BaseObject baseObject : this.m_sourceObjs) {
            if (!(baseObject instanceof FmQueryItem) || !(this.m_targetObj instanceof FmLevel)) continue;
            Level lvl = (Level)((Object)this.m_targetObj);
            QueryItem qiObj = (QueryItem)baseObject;
            LinkedList<Role> roles = new LinkedList<Role>();
            for (QueryItem qi : lvl.getAllQueryItems()) {
                boolean bMoved = false;
                for (BaseObject baseObject2 : this.m_sourceObjs) {
                    if (!qi.equals(baseObject2)) continue;
                    bMoved = true;
                    break;
                }
                if (bMoved) continue;
                for (Role role : qi.getRoles()) {
                    roles.add(role);
                }
            }
            for (Role role : roles) {
                Role.EDefaultRoles defRole = role.getDefaultRole();
                if (defRole == Role.EDefaultRoles.kRoleUnknown) {
                    qiObj.removeCustomRole(role.getName(), qiObj.getSession().getDefaultLocale());
                    continue;
                }
                qiObj.removeDefaultRole(defRole);
            }
        }
    }

    private void correctRelationships(List<? extends BaseObject> soucrObjs) {
        TopLevelObject fmObj;
        final ArrayList relationshipReferencedObjects = new ArrayList();
        HashSet<Integer> recurseInto = new HashSet<Integer>();
        recurseInto.add(88);
        recurseInto.add(148);
        recurseInto.add(28);
        HashSet<Integer> lookingFor = new HashSet<Integer>();
        lookingFor.add(124);
        lookingFor.add(157);
        lookingFor.add(42);
        SearchFilter filter = new SearchFilter(){

            public boolean foundElement(Object elm) {
                relationshipReferencedObjects.add(elm);
                return false;
            }
        };
        for (BaseObject baseObject : this.m_sourceObjs) {
            EmfHelper.traverse(((FmBaseObject)baseObject).getInternal(), recurseInto, lookingFor, filter, true);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object e : relationshipReferencedObjects) {
            List<Object> refdRelationships;
            fmObj = FmModelFactory.getInstance().get(this.m_session, e);
            if (!(fmObj instanceof RelationshipEnd) || (refdRelationships = ObjectReferenceHelper.getRelationshipsFor((FmProject)this.m_targetObj.getProject(), (RelationshipEnd)fmObj, true)) == null) continue;
            hashSet.addAll(refdRelationships);
        }
        for (Object e : hashSet) {
            fmObj = FmModelFactory.getInstance().get(this.m_session, e);
            if (!(fmObj instanceof FmRelationshipBase)) continue;
            FmRelationshipBase fmRelBase = (FmRelationshipBase)fmObj;
            fmRelBase.updateContainership();
        }
    }

    private void correctAttributeReferences() {
        for (BaseObject baseObject : this.m_sourceObjs) {
            RelationalObject relObj;
            if (!(baseObject instanceof FmQueryItem) || !(this.m_targetObj instanceof FmLevel) || !((relObj = ((FmQueryItem)baseObject).getRelationalParent()) instanceof FmRelationalDimension)) continue;
            for (RelationalHierarchy hier : ((FmRelationalDimension)relObj).getAllHierarchies()) {
                List<LevelReference> lvlRefs = hier.getLevelReferences();
                LevelReference lvlRefOfInterst = null;
                for (LevelReference lvlRef : lvlRefs) {
                    if (!lvlRef.getLevel().equals(this.m_targetObj)) continue;
                    lvlRefOfInterst = lvlRef;
                    break;
                }
                if (lvlRefOfInterst == null) continue;
                for (LevelReference lvlRef : lvlRefs) {
                    if (lvlRef.equals(lvlRefOfInterst)) continue;
                    ArrayList<AttributeReference> refsToMove = new ArrayList<AttributeReference>(1);
                    for (AttributeReference ref : lvlRef.getAttributeReferences()) {
                        if (!ref.getAttribute().equals(baseObject)) continue;
                        refsToMove.add(ref);
                        break;
                    }
                    FmCopyManager.move(this.m_session, (BaseObject)lvlRefOfInterst, refsToMove, null);
                }
            }
        }
    }

    private void validate() {
        this.validateContainership();
    }

    private void validateContainership() {
        if (this.m_targetObj != null) {
            int i = 0;
            while (i < this.m_sourceObjs.size()) {
                FmBaseObject source = (FmBaseObject)this.m_sourceObjs.get(i);
                boolean canContain = ((EMFSession)this.m_session).getGateway().canContain(this.m_targetObj.getInternal(), source.getInternal());
                if (!canContain) {
                    Object[] msgParams = new Object[]{this.m_targetObj.getFmObjectTypeName(), ((FmBaseObject)this.m_sourceObjs.get(i)).getFmObjectTypeName()};
                    throw new FmMDException("BMT_MD_INVALID_TYPE_OF_CHILD_OBJECT", msgParams);
                }
                ++i;
            }
        }
    }
}

