/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.EObjectSourceType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDeterminant;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRefobjViaShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmCopyManager;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmDeleteManager;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BasedOn;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Determinant;
import com.ibm.cognos.fmeng.fmmd.model.Dimension;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.DimensionParent;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.Hierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.ShortcutTarget;
import com.ibm.cognos.fmeng.fmmd.util.ObjectReferenceHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmDimensionBuilder {
    private FMMDSession m_session;

    public FmDimensionBuilder(FMMDSession session) {
        this.m_session = session;
    }

    public Dimension populateMeasureDimensionFrom(DimensionParent parent, List<BasedOn> sources, String dimName) {
        if (dimName == null) {
            dimName = this.getSourceNameForHierarchy(sources.get(0));
        }
        FmDimension dim = (FmDimension)parent.createMeasureDimension(dimName);
        this.validateModelDimensionSources(dim, sources);
        for (BasedOn source : sources) {
            if (source instanceof QueryItemParent) {
                dim.createMeasuresExtractedFrom((QueryItemParent)((Object)source), null, null);
                continue;
            }
            if (source instanceof FmQueryItemBase) {
                FmQueryItemBase qi = (FmQueryItemBase)source;
                dim.addMeasureBasedOnQueryItem((FmQueryItemBase)source, qi.getName(), null, null);
                continue;
            }
            if (source instanceof FmShortcut) {
                FmShortcut sc = (FmShortcut)source;
                if (source instanceof QueryItemParent) {
                    dim.createMeasuresExtractedFrom((QueryItemParent)((Object)source), null, sc);
                    continue;
                }
                FmMDException.ASSERT(false, "Unexpected source");
                continue;
            }
            FmMDException.ASSERT(false, "Unexpected source");
        }
        return dim;
    }

    public Measure populateMeasureFromBasedOn(FmDimension dim, BasedOn basedOn, String name, FmEMDObjectNaming makeUnique, FmBaseObject objInsertBefore) {
        List<FmMeasure> measures;
        FmMeasure createdMeasure = null;
        Shortcut sc = null;
        if (basedOn instanceof FmShortcut) {
            ShortcutTarget referencedObj = ((FmShortcut)basedOn).getRefobj();
            if (referencedObj != null && (referencedObj instanceof FmQuerySubject || referencedObj instanceof FmDimension || referencedObj instanceof FmCalculation)) {
                basedOn = (BasedOn)((Object)referencedObj);
            } else {
                FmMDException.ASSERT(false, "Unexpected source");
            }
        } else if (basedOn instanceof FmRefobjViaShortcut) {
            sc = ((FmRefobjViaShortcut)basedOn).getShortcut();
            basedOn = ((FmRefobjViaShortcut)basedOn).getRefobj();
        }
        if (basedOn instanceof FmQueryItemBase) {
            createdMeasure = dim.addMeasureBasedOnQueryItem((FmQueryItemBase)basedOn, name, objInsertBefore, sc);
        } else if (basedOn instanceof FmCalculation) {
            createdMeasure = dim.addMeasureBasedOnCalculation((FmCalculation)basedOn, name, makeUnique, objInsertBefore);
        } else if (basedOn instanceof FmQuerySubject) {
            FmMDException.ASSERT(false, "Did not expact query subject");
        } else if (basedOn instanceof FmQueryItemFolder) {
            measures = dim.createMeasuresExtractedFrom((FmQueryItemFolder)((Object)basedOn), objInsertBefore, null);
            if (measures.size() > 0) {
                createdMeasure = measures.get(0);
            }
        } else if (basedOn instanceof FmDimension) {
            measures = dim.createMeasuresExtractedFrom((FmDimension)basedOn, objInsertBefore, null);
            if (measures.size() > 0) {
                createdMeasure = measures.get(0);
            }
        } else {
            FmMDException.ASSERT(false, "Unexpected source");
        }
        return createdMeasure;
    }

    public Dimension populateRegularDimensionFrom(DimensionParent parent, List<BasedOn> sources, String dimName) {
        if (dimName == null) {
            dimName = this.getSourceNameForHierarchy(sources.get(0));
        }
        Dimension dim = parent.createRegularDimension(dimName);
        this.populateDimensionFrom(dim, sources, null);
        return dim;
    }

    public List<Level> populateDimensionFrom(Dimension dim, List<BasedOn> levelSources, FmLevel insertBefore) {
        Hierarchy hierarchy = null;
        hierarchy = this.findOrCreateFirstHierarchy(dim, levelSources.get(0));
        return this.populateHierarchyFrom(hierarchy, levelSources, insertBefore);
    }

    public List<Level> populateHierarchyFrom(Hierarchy hier, List<BasedOn> levelSources, Level insertBefore) {
        this.validateModelDimensionSources(hier.getDimension(), levelSources);
        if (insertBefore != null && insertBefore.isAllLevel()) {
            throw new FmMDException("BMT_MD_ERROR_ALL_LEVEL_FIRST_LEVEL");
        }
        BasedOn levelSource = levelSources.get(0);
        if (levelSource instanceof FmQuerySubject) {
            return this.addLevelsBasedOnQuerySubjects(hier, levelSources, insertBefore);
        }
        if (levelSource instanceof FmQueryItemBase) {
            return this.addLevelsBasedOnItems(hier, levelSources, insertBefore);
        }
        if (levelSource instanceof FmCalculation) {
            return this.addLevelsBasedOnItems(hier, levelSources, insertBefore);
        }
        if (levelSource instanceof FmShortcut) {
            return this.addLevelsBasedOnItems(hier, levelSources, insertBefore);
        }
        if (levelSource instanceof FmRefobjViaShortcut) {
            return this.addLevelsBasedOnItems(hier, levelSources, insertBefore);
        }
        if (levelSource instanceof FmLevel) {
            return this.addLevelsBasedOnItems(hier, levelSources, insertBefore);
        }
        throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_TYPE");
    }

    private List<Level> addLevelsBasedOnItems(Hierarchy hier, List<BasedOn> sources, Level insertBefore) {
        ArrayList<Level> levels = new ArrayList<Level>();
        FmQueryItemBase identifier = null;
        FmQueryItemBase attribute = null;
        if (sources.size() > 0) {
            BasedOn ls = sources.get(0);
            if (ls instanceof FmLevel) {
                return this.addLevelsBasedOnLevels(hier, sources);
            }
            for (BasedOn source : sources) {
                if (source instanceof FmQueryItemBase) {
                    FmQueryItemBase item = (FmQueryItemBase)source;
                    if (identifier == null && item.getUsage() == FmUsage.identifier) {
                        identifier = item;
                    }
                    if (attribute == null && (item.getDatatype() == FmDatatype.CHARACTER || item.getDatatype() == FmDatatype.CHARACTERLENGTH16 || item.getDatatype() == FmDatatype.CHARACTERLENGTH32)) {
                        attribute = item;
                    }
                    Level createdLevel = this.createLevelBasedOn(hier, item, insertBefore);
                    levels.add(createdLevel);
                    continue;
                }
                levels.add(this.createLevelBasedOn(hier, source, insertBefore));
            }
            return levels;
        }
        return null;
    }

    private List<Level> addLevelsBasedOnLevels(Hierarchy hier, List<Level> levels) {
        for (Level level : levels) {
            if (!hier.getDimension().equals(level.getDimension())) {
                throw new FmMDException("BMT_MD_LEVEL_TARGET_UNSUPPORTED_OPERATION");
            }
            if (!level.isAllLevel()) continue;
            throw new FmMDException("BMT_MD_ALL_LEVEL_UNSUPPORTED_OPERATION");
        }
        return FmCopyManager.copy(this.m_session, (BaseObject)hier, levels);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Level createLevelBasedOn(Hierarchy hier, BasedOn source, Level insertBefore) {
        Level level = null;
        if (source instanceof FmQueryItemBase) {
            FmQueryItemBase qi = (FmQueryItemBase)source;
            level = hier.createLevel(qi.getName());
            ((FmLevel)level).createQueryItemFromQueryItem(qi.getName(), qi, null);
        } else if (source instanceof FmCalculation) {
            FmCalculation calc = (FmCalculation)source;
            level = hier.createLevel(calc.getName());
            ((FmLevel)level).createQueryItemFromCalculation(calc.getName(), calc);
        } else if (source instanceof FmShortcut) {
            FmShortcut sc = (FmShortcut)source;
            ShortcutTarget obj = sc.getRefobj();
            level = hier.createLevel(obj.getName());
            if (obj instanceof FmCalculation) {
                FmCalculation calc = (FmCalculation)obj;
                ((FmLevel)level).createQueryItemFromCalculationShortcut(calc.getName(), sc);
            } else {
                if (!(obj instanceof FmQuerySubject)) throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_TYPE");
                FmQuerySubject qs = (FmQuerySubject)obj;
                ((FmLevel)level).createItemsBasedOnQueryItems(qs.getAllQueryItems(), sc);
            }
        } else if (source instanceof FmRefobjViaShortcut) {
            FmRefobjViaShortcut rvs = (FmRefobjViaShortcut)source;
            QueryItemBase qi = rvs.getRefobj();
            level = hier.createLevel(qi.getName());
            ((FmLevel)level).createQueryItemFromQueryItem(qi.getName(), qi, rvs.getShortcut());
        } else {
            if (!(source instanceof FmLevel)) throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_TYPE");
            FmLevel levelSource = (FmLevel)source;
            level = (FmLevel)FmCopyManager.copy(this.m_session, (BaseObject)hier, levelSource).get(0);
        }
        if (insertBefore == null) return level;
        hier.reorderBefore(level, insertBefore);
        return level;
    }

    public Hierarchy createHierarchy(Dimension dim, BasedOn levelSource) {
        return dim.createHierarchy(this.getSourceNameForHierarchy(levelSource));
    }

    private Hierarchy findOrCreateFirstHierarchy(Dimension dim, BasedOn ro) {
        Hierarchy hierarchy = null;
        List<Hierarchy> childHierarchies = dim.getAllHierarchies();
        if (!childHierarchies.isEmpty()) {
            hierarchy = childHierarchies.get(0);
        }
        if (hierarchy == null) {
            hierarchy = this.createHierarchy(dim, ro);
        }
        return hierarchy;
    }

    private String getSourceNameForHierarchy(BasedOn levelSource) {
        if (levelSource instanceof FmQueryItemBase) {
            return ((FmQueryItemBase)levelSource).getName();
        }
        if (levelSource instanceof FmQuerySubject) {
            return ((FmQuerySubject)levelSource).getName();
        }
        if (levelSource instanceof FmCalculation) {
            return ((FmCalculation)levelSource).getName();
        }
        if (levelSource instanceof FmShortcut) {
            return ((FmShortcut)levelSource).getName();
        }
        if (levelSource instanceof FmRefobjViaShortcut) {
            FmRefobjViaShortcut rs = (FmRefobjViaShortcut)levelSource;
            return rs.getRefobj().getName();
        }
        if (levelSource instanceof FmLevel) {
            return ((FmLevel)levelSource).getName();
        }
        FmMDException.ASSERT(false, "Unexpected level source");
        return null;
    }

    private List<Level> addLevelsBasedOnQuerySubjects(Hierarchy hier, List<BasedOn> fmBasedOns, Level objInsertBefore) {
        ArrayList<BasedOn> fmBasedOnNormalisedQSs = new ArrayList<BasedOn>();
        ArrayList<BasedOn> fmBasedOnNotNormalisedQSs = new ArrayList<BasedOn>();
        this.groupQuerySubjects(fmBasedOns, fmBasedOnNormalisedQSs, fmBasedOnNotNormalisedQSs);
        ArrayList<Level> levels = new ArrayList<Level>();
        for (BasedOn normalisedQS : fmBasedOnNormalisedQSs) {
            levels.add(this.createLevelBasedOnQuerySubject(hier, normalisedQS, objInsertBefore));
        }
        for (BasedOn notNormalisedQS : fmBasedOnNotNormalisedQSs) {
            FmQuerySubject qs = (FmQuerySubject)this.getRealObject(notNormalisedQS);
            List<Determinant> basedOnDeterminants = qs.getDeterminants();
            if (basedOnDeterminants.size() > 0) {
                boolean useQSName = false;
                if (basedOnDeterminants.size() == 1) {
                    useQSName = true;
                }
                for (Determinant determinant : basedOnDeterminants) {
                    levels.add(this.createLevelBasedOnDeterminant(hier, useQSName, notNormalisedQS, determinant, objInsertBefore));
                }
                continue;
            }
            levels.add(this.createLevelBasedOnQuerySubject(hier, qs, objInsertBefore));
        }
        return levels;
    }

    private void groupQuerySubjects(List<BasedOn> fmBasedOns, List<BasedOn> fmBasedOnNormalisedQSs, List<BasedOn> fmBasedOnNotNormalisedQSs) {
        ArrayList<BasedOn> fmNormalisedQuerySubjectsNO = new ArrayList<BasedOn>();
        ArrayList<RelationshipBase> fmDesirableRelationships = new ArrayList<RelationshipBase>();
        ArrayList<RelationshipEnd> fmEnds = new ArrayList<RelationshipEnd>();
        for (BasedOn basedOn : fmBasedOns) {
            ArrayList<RelationshipBase> fmCandidateRelationships = new ArrayList<RelationshipBase>();
            ArrayList<RelationshipEnd> allEnds = new ArrayList<RelationshipEnd>();
            allEnds.add((RelationshipEnd)basedOn);
            Map<RelationshipEnd, List<Object>> relMap = ObjectReferenceHelper.getRelationshipsMapFor(this.m_session.getProject(), allEnds, false);
            List<Object> eRelationships = relMap.get((RelationshipEnd)basedOn);
            if (eRelationships != null) {
                for (Object eRel : eRelationships) {
                    RelationshipBase rel = (RelationshipBase)FmModelFactory.getInstance().get(this.m_session, eRel);
                    if (((FmRelationshipBase)rel).isSelfJoin()) continue;
                    fmCandidateRelationships.add(rel);
                }
            }
            List<RelationshipBase> relationships = this.filterRelationships(fmCandidateRelationships, fmBasedOns);
            this.addToRelationshipCollection(relationships, fmDesirableRelationships);
            switch (relationships.size()) {
                case 0: {
                    fmBasedOnNotNormalisedQSs.add(basedOn);
                    break;
                }
                case 1: {
                    fmEnds.add((RelationshipEnd)basedOn);
                    fmNormalisedQuerySubjectsNO.add(basedOn);
                    break;
                }
                case 2: {
                    if (fmBasedOns.size() == 2) {
                        throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_RELATIONSHIPS");
                    }
                    fmNormalisedQuerySubjectsNO.add(basedOn);
                    break;
                }
                default: {
                    throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_RELATIONSHIPS");
                }
            }
        }
        if (fmNormalisedQuerySubjectsNO.size() >= 2) {
            if (fmEnds.size() != 2) {
                throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_RELATIONSHIPS");
            }
            this.orderNormalizedQuerySubjects(fmNormalisedQuerySubjectsNO, fmDesirableRelationships, fmEnds, fmBasedOnNormalisedQSs);
        }
    }

    private List<RelationshipBase> filterRelationships(List<RelationshipBase> candidateRels, List<BasedOn> selectedQSubjects) {
        ArrayList<RelationshipBase> relationships = new ArrayList<RelationshipBase>();
        for (RelationshipBase fmRel : candidateRels) {
            if (relationships.contains(fmRel) || !this.isRelationshipInternal(fmRel.getLeftEnd(), fmRel.getRightEnd(), selectedQSubjects)) continue;
            relationships.add(fmRel);
        }
        return relationships;
    }

    private boolean isRelationshipInternal(RelationshipEnd left, RelationshipEnd right, List<BasedOn> selectedQSubjects) {
        boolean bResult = selectedQSubjects.contains((FmQuerySubject)left) && selectedQSubjects.contains((FmQuerySubject)right) && !left.equals(right);
        return bResult;
    }

    private void addToRelationshipCollection(List<RelationshipBase> relationships, List<RelationshipBase> desirableRelationships) {
        for (RelationshipBase relationship : relationships) {
            Cardinality.ECardinality leftMaxCard = relationship.getLeftMaxcard();
            Cardinality.ECardinality rightMaxCard = relationship.getRightMaxcard();
            if (!(leftMaxCard == Cardinality.ECardinality.one && rightMaxCard == Cardinality.ECardinality.many || leftMaxCard == Cardinality.ECardinality.many && rightMaxCard == Cardinality.ECardinality.one)) {
                throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_RELATIONSHIPS");
            }
            if (desirableRelationships.contains(relationship)) continue;
            desirableRelationships.add(relationship);
        }
    }

    private void orderNormalizedQuerySubjects(List<BasedOn> fmNormalizedQuerySubjects, List<RelationshipBase> fmConnectingRelationships, List<RelationshipEnd> fmEnds, List<BasedOn> fmOrderedQuerySubjects) {
        if (fmNormalizedQuerySubjects.size() < 2 && fmEnds.size() < 2 && fmConnectingRelationships.size() != fmNormalizedQuerySubjects.size() - 1) {
            assert (false);
            return;
        }
        RelationshipEnd startingPoint = null;
        Cardinality followingRel = null;
        boolean bFound = false;
        block0: for (RelationshipEnd relEnd : fmEnds) {
            for (RelationshipBase aRelationship : fmConnectingRelationships) {
                if ((!aRelationship.getLeftEnd().equals(relEnd) || aRelationship.getLeftMaxcard() != Cardinality.ECardinality.one) && (!aRelationship.getRightEnd().equals(relEnd) || aRelationship.getRightMaxcard() != Cardinality.ECardinality.one)) continue;
                startingPoint = relEnd;
                followingRel = aRelationship;
                if (!bFound) {
                    bFound = true;
                    continue block0;
                }
                throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_RELATIONSHIPS");
            }
        }
        if (!bFound) {
            throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_RELATIONSHIPS");
        }
        fmOrderedQuerySubjects.add(startingPoint);
        block2: do {
            RelationshipEnd nextEndObject = null;
            nextEndObject = followingRel.getLeftMaxcard() == Cardinality.ECardinality.many ? followingRel.getLeftEnd() : followingRel.getRightEnd();
            fmOrderedQuerySubjects.add((FmQuerySubject)nextEndObject);
            followingRel = null;
            for (RelationshipBase aRelationship : fmConnectingRelationships) {
                if ((!aRelationship.getLeftEnd().equals(nextEndObject) || aRelationship.getLeftMaxcard() != Cardinality.ECardinality.one) && (!aRelationship.getRightEnd().equals(nextEndObject) || aRelationship.getRightMaxcard() != Cardinality.ECardinality.one)) continue;
                followingRel = aRelationship;
                continue block2;
            }
        } while (followingRel != null);
        if (fmOrderedQuerySubjects.size() != fmNormalizedQuerySubjects.size()) {
            throw new FmMDException("BMT_MD_DIMENSION_INVALID_PARAMETERS_RELATIONSHIPS");
        }
    }

    private BasedOn getRealObject(BasedOn source) {
        if (source instanceof FmShortcut) {
            FmShortcut sc = (FmShortcut)source;
            return (BasedOn)((Object)sc.getRefobj());
        }
        return source;
    }

    private Level createLevelBasedOnDeterminant(Hierarchy hier, boolean useSourceName, BasedOn source, Determinant det, Level insertBefore) {
        Level newLevel;
        FmQuerySubject qs = (FmQuerySubject)this.getRealObject(source);
        String name = det.getName();
        if (useSourceName) {
            name = ((FmReportObject)((Object)source)).getName();
        }
        if (this.initialiseWithDeterminant(newLevel = hier.createLevel(name), det, qs != source ? (FmShortcut)source : null)) {
            if (insertBefore != null) {
                hier.reorderBefore(newLevel, insertBefore);
            }
        } else {
            ArrayList<FmLevel> objList = new ArrayList<FmLevel>();
            objList.add((FmLevel)newLevel);
            FmDeleteManager del = new FmDeleteManager(this.m_session, objList);
            del.removeObjects();
            newLevel = null;
        }
        return newLevel;
    }

    private Level createLevelBasedOnQuerySubject(Hierarchy hier, BasedOn ls, Level insertBefore) {
        Level newLevel = hier.createLevel(((FmReportObject)((Object)ls)).getName());
        FmMDException.ASSERT(newLevel != null, "Error creating object");
        this.initialiseWithQuerySubject(newLevel, ls);
        if (insertBefore != null) {
            hier.reorderBefore(newLevel, insertBefore);
        }
        return newLevel;
    }

    private void initialiseWithQuerySubject(Level level, BasedOn notNormalisedQS) {
        FmQuerySubject qs = (FmQuerySubject)this.getRealObject(notNormalisedQS);
        List<Determinant> basedOnDeterminants = qs.getDeterminants();
        if (basedOnDeterminants.size() == 0) {
            this.initialiseWithQuerySubjectNoDeterminants(level, notNormalisedQS);
        } else {
            ArrayList<QueryItemBase> keySet = new ArrayList<QueryItemBase>();
            ArrayList<QueryItemBase> attrSet = new ArrayList<QueryItemBase>();
            boolean levelIsUnique = this.traverseKeysForDeterminant(basedOnDeterminants.get(0), keySet, attrSet);
            if (keySet.size() > 0) {
                this.populateLevelBasedOnKeys(level, basedOnDeterminants.get(0), keySet, attrSet, qs.equals(notNormalisedQS) ? null : (FmShortcut)notNormalisedQS);
            }
        }
    }

    private void initialiseWithQuerySubjectNoDeterminants(Level level, BasedOn querySubject) {
        FmQuerySubject qs = (FmQuerySubject)this.getRealObject(querySubject);
        List<QueryItem> qItems = qs.getAllQueryItems();
        for (QueryItem qItem : qItems) {
            FmQueryItem fmQueryItem = ((FmLevel)level).createQueryItemFromQueryItem(qItem.getName(), qItem, qs != querySubject ? (FmShortcut)querySubject : null);
        }
    }

    private boolean initialiseWithDeterminant(Level level, Determinant determinant, Shortcut hShortcut) {
        ArrayList<QueryItemBase> keySet = new ArrayList<QueryItemBase>();
        ArrayList<QueryItemBase> attrSet = new ArrayList<QueryItemBase>();
        boolean levelIsUnique = this.traverseKeysForDeterminant(determinant, keySet, attrSet);
        if (keySet.size() <= 0) {
            return false;
        }
        this.populateLevelBasedOnKeys(level, determinant, keySet, attrSet, hShortcut);
        return true;
    }

    private boolean traverseKeysForDeterminant(Determinant determinant, List<QueryItemBase> outputKeySet, List<QueryItemBase> outputAttrSet) {
        FmQuerySubject parentQs = ((FmDeterminant)determinant).getQueryParent();
        List<Determinant> determinants = parentQs.getDeterminants();
        List<QueryItem> keySet = determinant.getKeys();
        List<QueryItem> attrSet = determinant.getAttributes();
        boolean levelIsUnique = !determinant.getInternal().equals(determinants.get(0).getInternal());
        for (Determinant otherDet : determinants) {
            if (determinant.getInternal().equals(otherDet.getInternal())) break;
            List<QueryItem> otherKeySet = otherDet.getKeys();
            List<QueryItem> otherAttrSet = otherDet.getAttributes();
            for (QueryItem otherKey : otherKeySet) {
                if (!keySet.contains(otherKey)) continue;
                keySet.remove(otherKey);
                levelIsUnique = false;
            }
            for (QueryItem otherAtt : otherAttrSet) {
                if (!attrSet.contains(otherAtt)) continue;
                attrSet.remove(otherAtt);
            }
            for (QueryItem otherAtt : otherAttrSet) {
                if (!keySet.contains(otherAtt)) continue;
                keySet.remove(otherAtt);
            }
            for (QueryItem otherKey : otherKeySet) {
                if (!attrSet.contains(otherKey)) continue;
                attrSet.remove(otherKey);
            }
        }
        for (QueryItem qi : keySet) {
            outputKeySet.add((FmQueryItemBase)((Object)qi));
        }
        for (QueryItem qi : attrSet) {
            outputAttrSet.add((FmQueryItemBase)((Object)qi));
        }
        return levelIsUnique;
    }

    private void populateLevelBasedOnKeys(Level level, Determinant determinant, List<QueryItemBase> keySet, List<QueryItemBase> attrSet, Shortcut shortcut) {
        for (QueryItemBase key : keySet) {
            FmQueryItem newQueryItem = ((FmLevel)level).createQueryItemFromQueryItem(key.getName(), key, shortcut);
            key.equals(keySet.get(0));
        }
        boolean fCaptionSet = false;
        for (QueryItemBase attr : attrSet) {
            FmQueryItem newQueryItem = ((FmLevel)level).createQueryItemFromQueryItem(attr.getName(), attr, shortcut);
            if (fCaptionSet) continue;
        }
    }

    private void validateModelDimensionSources(DimensionBase dim, List<BasedOn> fmBasedOns) {
        if (fmBasedOns == null || fmBasedOns.isEmpty()) {
            return;
        }
        if (((FmDimension)dim).getDefinitionType() != QuerySubjectBase.EDefinitionType.kTypeModelQuery) {
            return;
        }
        int idx = 0;
        while (idx < fmBasedOns.size()) {
            BasedOn basedOn = fmBasedOns.get(idx);
            EObjectSourceType eSourceType = EObjectSourceType.kUnknown;
            if (basedOn instanceof FmQuerySubjectBase) {
                eSourceType = ((FmQuerySubjectBase)basedOn).determineSourceType(null);
            } else if (basedOn instanceof FmQueryItemBase) {
                eSourceType = ((FmQuerySubjectBase)((FmQueryItemBase)basedOn).getQueryParent()).determineSourceType(null);
            } else if (basedOn instanceof FmCalculation) {
                eSourceType = ((FmCalculation)basedOn).determineSourceType(null);
            } else if (basedOn instanceof FmShortcut) {
                FmShortcut sc = (FmShortcut)basedOn;
                ShortcutTarget bo = sc.getRefobj();
                if (bo instanceof FmCalculation) {
                    eSourceType = ((FmCalculation)bo).determineSourceType(null);
                } else if (bo instanceof FmQuerySubjectBase) {
                    eSourceType = ((FmQuerySubjectBase)bo).determineSourceType(null);
                }
            } else if (basedOn instanceof FmRefobjViaShortcut) {
                FmRefobjViaShortcut vs = (FmRefobjViaShortcut)basedOn;
                eSourceType = ((FmQuerySubjectBase)vs.getRefobj().getQueryParent()).determineSourceType(null);
            } else if (basedOn instanceof FmLevel) {
                eSourceType = ((FmLevel)basedOn).getQueryParent().determineSourceType(null);
            }
            if (eSourceType == EObjectSourceType.kMultidimensional) {
                throw new FmMDException("BMT_MD_DIMENSIONAL_MODEL_DIMENSION_UNSUPPORTED");
            }
            ++idx;
        }
    }
}

