/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipShortcut;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Calculation;
import com.ibm.cognos.fmeng.fmmd.model.Dimension;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureFolder;
import com.ibm.cognos.fmeng.fmmd.model.QueryChild;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.ShortcutTarget;
import com.ibm.cognos.fmeng.fmmd.model.Status;
import com.ibm.cognos.fmeng.fmmd.util.CopyRelationshipsHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmMergeManager {
    private FMMDSession m_session;
    private List<BaseObject> m_sources;
    private boolean m_bCreateRelation;
    private Set<QuerySubjectBase> m_qsdims = new HashSet<QuerySubjectBase>();
    private Set<Shortcut> m_shortcuts = new HashSet<Shortcut>();
    private List<ReportObject> m_items = new ArrayList<ReportObject>();
    private Map<Shortcut, List<QueryItemBase>> m_shortcutItemsMap = new HashMap<Shortcut, List<QueryItemBase>>();
    private QuerySubject m_target;

    public FmMergeManager(FMMDSession session, List<BaseObject> sources, boolean bCreateRelation) {
        this.m_session = session;
        this.m_sources = sources;
        this.m_bCreateRelation = bCreateRelation;
    }

    public BaseObject merge() {
        this.examineSources();
        this.createTarget();
        if (this.m_bCreateRelation) {
            this.createRelationships();
        }
        return this.m_target;
    }

    private void examineSources() {
        block11: for (BaseObject obj : this.m_sources) {
            FmObjectType type = obj.getFmObjectType();
            switch (type) {
                case dimension: {
                    this.handleDimension((Dimension)obj);
                    break;
                }
                case querySubject: {
                    this.handleQuerySubject((QuerySubject)obj);
                    break;
                }
                case measure: 
                case queryItem: {
                    this.handleItem((QueryItemBase)obj);
                    break;
                }
                case queryItemFolder: {
                    List<QueryItem> items = ((QueryItemFolder)obj).getAllQueryItems();
                    for (QueryItem i : items) {
                        this.handleItem(i);
                    }
                    continue block11;
                }
                case measureFolder: {
                    List<Measure> measures = ((MeasureFolder)obj).getAllMeasures();
                    for (Measure m : measures) {
                        this.handleItem(m);
                    }
                    continue block11;
                }
                case relationship: {
                    FmRelationship rel = (FmRelationship)obj;
                    if (rel.getStatus() != Status.EStatus.valid) continue block11;
                    this.handleRel((RelationshipBase)obj);
                    break;
                }
                case relationshipShortcut: {
                    FmRelationshipShortcut relsc = (FmRelationshipShortcut)obj;
                    FmRelationshipBase target = relsc.getTarget();
                    while (target instanceof FmRelationshipShortcut) {
                        target = ((FmRelationshipShortcut)target).getTarget();
                    }
                    FmRelationship relTarget = (FmRelationship)target;
                    if (relTarget.getStatus() != Status.EStatus.valid) continue block11;
                    this.handleRel((RelationshipBase)obj);
                    break;
                }
                case shortcut: {
                    this.handleShortcut((Shortcut)obj);
                    break;
                }
                case calculation: {
                    FmCalculation calc = (FmCalculation)obj;
                    if (calc.getStatus() != Status.EStatus.valid) continue block11;
                    this.m_items.add((ReportObject)obj);
                    break;
                }
                default: {
                    throw new FmMDException("BMT_MD_INVALID_MERGE_SOURCE_STATUS");
                }
            }
        }
    }

    private void handleQuerySubject(QuerySubject obj) {
        if (((FmQuerySubjectBase)((Object)obj)).getStatus() == Status.EStatus.valid && this.m_qsdims.add(obj)) {
            this.m_items.addAll(obj.getAllQueryItems());
        }
    }

    private void handleDimension(Dimension dim) {
        if (((FmQuerySubjectBase)((Object)dim)).getStatus() == Status.EStatus.valid && this.m_qsdims.add(dim)) {
            FmHierarchy defHier = (FmHierarchy)dim.getDefaultHierarchy();
            if (defHier != null) {
                this.m_items.addAll(defHier.getAllQueryItems());
            } else {
                this.m_items.addAll(dim.getAllMeasures());
                this.m_items.addAll(dim.getAllQueryItems());
            }
        }
    }

    private void handleShortcut(Shortcut shortcut) {
        if (this.m_shortcuts.add(shortcut)) {
            ShortcutTarget target;
            List<QueryItemBase> vals = this.m_shortcutItemsMap.get(shortcut);
            if (vals == null) {
                vals = new ArrayList<QueryItemBase>();
                this.m_shortcutItemsMap.put(shortcut, vals);
            }
            if ((target = shortcut.getRefobj()) instanceof QuerySubject && ((FmQuerySubjectBase)target).getStatus() == Status.EStatus.valid) {
                vals.addAll(((QuerySubject)target).getAllQueryItems());
            } else if (target instanceof Dimension && ((FmQuerySubjectBase)target).getStatus() == Status.EStatus.valid) {
                Dimension dim = (Dimension)target;
                FmHierarchy defHier = (FmHierarchy)dim.getDefaultHierarchy();
                if (defHier != null) {
                    vals.addAll(defHier.getAllQueryItems());
                } else {
                    vals.addAll(dim.getAllMeasures());
                    vals.addAll(dim.getAllQueryItems());
                }
            }
        }
    }

    private void handleRel(RelationshipBase obj) {
        RelationshipEnd left = obj.getLeftEnd();
        if (left instanceof Shortcut) {
            this.handleShortcut((Shortcut)left);
        } else if (left instanceof QuerySubject) {
            this.handleQuerySubject((QuerySubject)left);
        } else if (left instanceof Dimension) {
            this.handleDimension((Dimension)left);
        }
        RelationshipEnd right = obj.getRightEnd();
        if (right instanceof Shortcut) {
            this.handleShortcut((Shortcut)right);
        } else if (right instanceof QuerySubject) {
            this.handleQuerySubject((QuerySubject)right);
        } else if (right instanceof Dimension) {
            this.handleDimension((Dimension)right);
        }
    }

    private void handleItem(QueryItemBase obj) {
        QuerySubjectBase parent = obj.getQueryParent();
        this.m_qsdims.add(parent);
        this.m_items.add(obj);
    }

    private ReportObject getNamingObject(BaseObject obj, boolean leftPartName) {
        ReportObject namingObj = null;
        FmObjectType objType = obj.getFmObjectType();
        switch (objType) {
            case calculation: 
            case dimension: 
            case querySubject: {
                namingObj = (ReportObject)obj;
                break;
            }
            case relationship: 
            case relationshipShortcut: {
                namingObj = leftPartName ? ((RelationshipBase)obj).getLeftEnd() : ((RelationshipBase)obj).getRightEnd();
                break;
            }
            case measure: 
            case measureFolder: 
            case queryItem: 
            case queryItemFolder: {
                namingObj = (FmQuerySubjectBase)((QueryChild)obj).getQueryParent();
            }
        }
        return namingObj;
    }

    private String buildNamesForTarget() {
        String leftName = this.getNamingObject(this.m_sources.get(0), true).getName();
        String rightName = this.getNamingObject(this.m_sources.get(this.m_sources.size() - 1), false).getName();
        return String.valueOf(leftName) + "_" + rightName;
    }

    private void createTarget() {
        BaseObject commonParent = this.m_sources.get(0);
        int i = 1;
        while (i < this.m_sources.size()) {
            if (!commonParent.isAncestor(this.m_sources.get(i))) {
                Object objCommonParent = ((EMFSession)this.m_session).getGateway().getCommonAncestor(commonParent.getInternal(), this.m_sources.get(i).getInternal());
                commonParent = FmModelFactory.getInstance().get(this.m_session, objCommonParent);
            }
            ++i;
        }
        if (!(commonParent instanceof Section)) {
            commonParent = commonParent.getParentNamespace();
        }
        String qsName = this.buildNamesForTarget();
        this.m_target = FmMergeManager.mergeToModelQuery((Section)commonParent, qsName, this.m_items, this.m_shortcutItemsMap);
    }

    private static QuerySubject mergeToModelQuery(Section parent, String qsName, List<ReportObject> items, Map<Shortcut, List<QueryItemBase>> shortcutItemsMap) {
        QuerySubject qs = parent.createModelQuerySubject(qsName);
        for (ReportObject item : items) {
            String name = item.getName();
            if (item instanceof QueryItem || item instanceof Measure) {
                qs.createQueryItemFromQueryItem(name, (QueryItemBase)item, null);
                continue;
            }
            if (!(item instanceof Calculation)) continue;
            qs.createQueryItemFromCalculation(name, (Calculation)item);
        }
        Set<Map.Entry<Shortcut, List<QueryItemBase>>> entries = shortcutItemsMap.entrySet();
        for (Map.Entry<Shortcut, List<QueryItemBase>> entry : entries) {
            Shortcut shortcut = entry.getKey();
            List<QueryItemBase> itemList = entry.getValue();
            for (ReportObject reportObject : itemList) {
                String name = reportObject.getName();
                qs.createQueryItemFromQueryItem(name, (QueryItemBase)reportObject, shortcut);
            }
        }
        qs.setStatus(Status.EStatus.valid);
        return qs;
    }

    private void createRelationships() {
        ArrayList<QuerySubjectBase> qsdims = new ArrayList<QuerySubjectBase>();
        qsdims.addAll(this.m_qsdims);
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        shortcuts.addAll(this.m_shortcuts);
        CopyRelationshipsHelper helper = new CopyRelationshipsHelper(this.m_target, qsdims, this.m_items, shortcuts);
        helper.copyRelationshipsForMerge();
    }
}

