/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.helpers.XDbQueryHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XQuerySubjectHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XResponseDomHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XStoredProcedureHelper;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDeterminant;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryOperation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmScopeRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityView;
import com.ibm.cognos.fmeng.fmmd.impl.model.ImpactListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmDeleteManager;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XAdaptor;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.MeasureParent;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.QuerySetOperation;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.util.LocaleBasedValue;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmQueryItemSynchronizer {
    private FMMDSession m_session;
    private ESynchMode m_eSynchMode;
    private FmQuerySubjectBase m_object;
    private List<ExternalQItem> m_currExternalQItems = new ArrayList<ExternalQItem>();
    private List<ModeledQItem> m_currModeledQItems = new ArrayList<ModeledQItem>();
    private List<String> m_newProjItemNames = new ArrayList<String>();

    public FmQueryItemSynchronizer(FmQuerySubjectBase obj) {
        this.m_session = obj.getSession();
        this.m_object = obj;
        this.m_eSynchMode = ESynchMode.kSynchUnknown;
    }

    public void update(ImpactListener listener) {
        this.m_eSynchMode = ESynchMode.kSynchExternalItemsOnly;
        this.m_newProjItemNames = this.m_object.getDefinitionType() == QuerySubjectBase.EDefinitionType.kTypeModelSetQuery ? this.doQSRequestForModelSetQuery() : this.doQuerySubjectRequest();
        this.synchronizeQueryItems(listener);
    }

    public void setUpdateTableType(boolean bFlag) {
    }

    private List<String> doQuerySubjectRequest() {
        Element elmNewDefinition = this.getQuerySubjectDefinition();
        XQuerySubjectHelper qsHelper = null;
        if (this.m_object.getDefinitionType() == QuerySubjectBase.EDefinitionType.kTypeDatabaseQuery) {
            qsHelper = new XDbQueryHelper(this.m_session, elmNewDefinition);
        } else if (this.m_object.getDefinitionType() == QuerySubjectBase.EDefinitionType.kTypeStoredProcedureQuery) {
            qsHelper = new XStoredProcedureHelper(this.m_session, elmNewDefinition);
        }
        Element domRequest = qsHelper.make();
        int maxRow = 0;
        boolean bValidate = false;
        boolean bDisableAuthentication = false;
        XAdaptor myAdaptor = XAdaptor.create(this.m_session, bValidate, bDisableAuthentication);
        Element elmResponse = myAdaptor.doQsApiRequest(domRequest, maxRow);
        return XResponseDomHelper.getColumnNamesForQuerySubject(elmResponse);
    }

    private List<String> doQSRequestForModelSetQuery() {
        String setName = "modelSet";
        FmDefinition def = this.m_object.getDefinition();
        FmQueryOperation queryOp = def.getQueryOperation();
        ReportObject leftEnd = queryOp.getQuerySubjectRefs().get(0);
        ReportObject rightEnd = queryOp.getQuerySubjectRefs().get(1);
        QuerySetOperation.ESetOperation operation = queryOp.getSetOperation();
        QuerySetOperation.EDuplicates duplicates = queryOp.getDuplicates();
        XAdaptor myAdaptor = XAdaptor.create(this.m_session, true, false);
        Element elmResponse = myAdaptor.planModelSet(setName, (FmBaseObject)((Object)leftEnd), (FmBaseObject)((Object)rightEnd), operation, duplicates);
        return XResponseDomHelper.getColumnNamesForModelSet(elmResponse);
    }

    private void collectCurrentQueryItems() {
        this.cleanCurrentItems();
        if (this.m_eSynchMode == ESynchMode.kSynchAll || this.m_eSynchMode == ESynchMode.kSynchExternalItemsOnly) {
            List<? extends FmQueryItemBase> hExternalQItems = this.m_object.getQueryItems(FmQuerySubjectBase.EQueryItemsScope.kScopeAll, FmQuerySubjectBase.EQueryItemsSource.kSourceExternalOnly);
            int sIdx = 0;
            while (sIdx < hExternalQItems.size()) {
                String externalName = hExternalQItems.get(sIdx).getExternalName();
                this.m_currExternalQItems.add(new ExternalQItem(hExternalQItems.get(sIdx), externalName));
                ++sIdx;
            }
        }
        if (this.m_eSynchMode == ESynchMode.kSynchAll || this.m_eSynchMode == ESynchMode.kSynchModeledItemsOnly) {
            List<? extends FmQueryItemBase> hModeledQItems = this.m_object.getQueryItems(FmQuerySubjectBase.EQueryItemsScope.kScopeAll, FmQuerySubjectBase.EQueryItemsSource.kSourceModelOnly);
            int mIdx = 0;
            while (mIdx < hModeledQItems.size()) {
                Expression hExpr = hModeledQItems.get(mIdx).getExpression();
                FmMDException.ASSERT(hExpr != null, null);
                this.m_currModeledQItems.add(new ModeledQItem((FmQueryItem)hModeledQItems.get(mIdx), this.m_session, hExpr));
                ++mIdx;
            }
        }
    }

    private void synchronizeQueryItems(ImpactListener listener) {
        this.collectCurrentQueryItems();
        this.removeDroppedQueryItems(listener);
        this.insertNewQueryItems();
    }

    private void insertNewQueryItems() {
        if (this.m_eSynchMode == ESynchMode.kSynchAll || this.m_eSynchMode == ESynchMode.kSynchExternalItemsOnly) {
            this.insertNewExternalItems();
        }
    }

    private void removeDroppedQueryItems(ImpactListener listener) {
        ArrayList vDroppedModeledItems = new ArrayList();
        ArrayList<ExternalQItem> vDroppedExternalItems = new ArrayList<ExternalQItem>();
        if (this.m_eSynchMode == ESynchMode.kSynchAll || this.m_eSynchMode == ESynchMode.kSynchExternalItemsOnly) {
            this.collectDroppedExternalItems(vDroppedExternalItems);
        }
        if (!vDroppedExternalItems.isEmpty() || !vDroppedModeledItems.isEmpty()) {
            ArrayList<FmQueryItemBase> droppedQueryItems = new ArrayList<FmQueryItemBase>();
            for (ExternalQItem sItr : vDroppedExternalItems) {
                droppedQueryItems.add(sItr.s_hItem);
            }
            for (ModeledQItem mItr : vDroppedModeledItems) {
                droppedQueryItems.add(mItr.s_hItem);
            }
            ProxyImpactListener impactListener = new ProxyImpactListener(listener);
            FmDeleteManager delManager = new FmDeleteManager(this.m_session, droppedQueryItems);
            delManager.removeObjects(impactListener);
        }
    }

    private void collectDroppedExternalItems(List<ExternalQItem> vDroppedExternalQItems) {
        for (ExternalQItem csItr : this.m_currExternalQItems) {
            if (this.m_newProjItemNames.contains(csItr.s_extName)) continue;
            vDroppedExternalQItems.add(csItr);
        }
    }

    private void insertNewExternalItems() {
        if (this.m_newProjItemNames == null) {
            return;
        }
        this.collectCurrentQueryItems();
        FmBaseObject parentObj = this.determineParentForNewItems();
        ArrayList<FmQueryItem> vhNewQueryItems = new ArrayList<FmQueryItem>();
        FmQueryItemBase hInsertBefore = null;
        if (this.m_newProjItemNames != null) {
            int j = 0;
            while (j < this.m_newProjItemNames.size()) {
                String colName = this.m_newProjItemNames.get(j);
                boolean nameFound = false;
                ExternalQItem qItr = null;
                int i = 0;
                while (i < this.m_currExternalQItems.size()) {
                    qItr = this.m_currExternalQItems.get(i);
                    if (colName.equals(qItr.s_extName)) {
                        nameFound = true;
                        break;
                    }
                    ++i;
                }
                if (!nameFound) {
                    ArrayList<LocaleBasedValue> localizedNames = new ArrayList<LocaleBasedValue>();
                    localizedNames.add(new LocaleBasedValue(this.m_session.getActiveLocale(), colName));
                    hInsertBefore = parentObj.getFmObjectType() == FmObjectType.dimension && ((FmDimension)parentObj).getDimensionStyle() == DimensionBase.DimensionStyle.measure ? (FmQueryItemBase)((Object)((MeasureParent)((Object)parentObj)).createMeasure(colName)) : (FmQueryItemBase)((Object)((QueryItemParent)((Object)parentObj)).createQueryItem(colName, null));
                    hInsertBefore.setExternalName(colName);
                    if (this.m_object instanceof FmQuerySubject) {
                        vhNewQueryItems.add((FmQueryItem)hInsertBefore);
                    }
                }
                ++j;
            }
        }
        if (this.m_object instanceof FmQuerySubject && !vhNewQueryItems.isEmpty()) {
            ((FmQuerySubject)this.m_object).applyDeterminantCoverage(vhNewQueryItems, FmQueryItemBase.ESourceType.kSourceExternal);
        }
    }

    private FmBaseObject determineParentForNewItems() {
        FmDimension dim;
        FmReportObject hParent = this.m_object;
        if (this.m_object instanceof FmDimension && (dim = (FmDimension)this.m_object).getDimensionStyle() == DimensionBase.DimensionStyle.regular) {
            FmLevel hLeafLevel;
            FmHierarchy hDefaultHierarchy = (FmHierarchy)((FmDimension)this.m_object).getDefaultHierarchy();
            if (hDefaultHierarchy == null) {
                hDefaultHierarchy = FmHierarchy.createHierarchy(this.m_session, (FmDimension)this.m_object, this.m_object.getName(), FmEMDObjectNaming.kMakeUnique, true);
            }
            if ((hLeafLevel = hDefaultHierarchy.getLeafLevel()) == null) {
                hLeafLevel = FmLevel.createLevel(this.m_session, hDefaultHierarchy, this.m_object.getName());
            }
            hParent = hLeafLevel;
        }
        FmMDException.ASSERT(hParent != null, "failed to assign a parent for to-be-inserted queryItems");
        return hParent;
    }

    private void cleanCurrentItems() {
        this.m_currExternalQItems.clear();
        this.m_currModeledQItems.clear();
    }

    private void reorderExistingQueryItem(FmBaseObject hItem, FmBaseObject hBeforeItem) {
    }

    private void preserveCachedSql(Element elmNewDefinition) {
    }

    private Element getQuerySubjectDefinition() {
        FmDefinition def = this.m_object.getDefinition();
        try {
            Document document = DocumentHelper.parseText((String)def.asXML());
            Element elmNewDefinition = document.getRootElement();
            if (this.m_object.getDefinitionType() == QuerySubjectBase.EDefinitionType.kTypeStoredProcedureQuery) {
                Element typeElement = (Element)elmNewDefinition.selectSingleNode(".//*[local-name()='type']");
                typeElement.setText("procedure");
            }
            return elmNewDefinition;
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ESynchMode {
        kSynchUnknown,
        kSynchExternalItemsOnly,
        kSynchModeledItemsOnly,
        kSynchAll;

    }

    class ExternalQItem {
        FmQueryItemBase s_hItem;
        String s_extName;

        ExternalQItem(FmQueryItemBase hQItem, String externalName) {
            this.s_hItem = hQItem;
            this.s_extName = externalName;
        }
    }

    private class ModeledQItem {
        FmQueryItem s_hItem;
        String s_aliasName;
        String s_displayName;

        ModeledQItem(FmQueryItem hQItem, FMMDSession gw, Expression hExpr) {
            this.s_hItem = hQItem;
            this.s_aliasName = "";
            this.s_displayName = "";
        }

        void setAliasName(String sAliasName) {
            this.s_aliasName = sAliasName;
            if (this.s_displayName.equals("")) {
                this.s_displayName = this.s_aliasName;
            }
        }
    }

    private class ProxyImpactListener
    implements ImpactListener {
        private ImpactListener m_listener;

        public ProxyImpactListener(ImpactListener listener) {
            this.m_listener = listener;
        }

        public void deleteDeterminant(FmBaseObject obj, FmDeterminant det) {
            this.m_listener.deleteDeterminant(obj, det);
        }

        public void explicitDeletion(FmBaseObject fmBaseObject) {
            this.m_listener.explicitDeletion(fmBaseObject);
        }

        public void impactedObjectForDeletion(FmBaseObject object) {
            this.m_listener.impactedObjectForDeletion(object);
        }

        public void invalidateObject(FmBaseObject obj) {
            this.m_listener.invalidateObject(obj);
        }

        public void invalidateScopeLevelReference(FmScopeRelationship invalidateScopeLevelReference) {
            this.m_listener.invalidateScopeLevelReference(invalidateScopeLevelReference);
        }

        public void reportError(FmMDException errorMessage) {
        }

        public void securityViewRefRemoved(FmSecurityView fmSecurityView) {
            this.m_listener.securityViewRefRemoved(fmSecurityView);
        }
    }
}

