/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmOperandType;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmRelationshipTransform;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmRelationshipTransformOptions;
import com.ibm.cognos.fmeng.fmmd.model.Determinant;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRelationshipInfo {
    private FMMDSession m_session;
    private int m_numRelationships = 0;
    private FmRelationshipTransformOptions m_options;
    private List<? extends QuerySubject> m_sources = new ArrayList<QuerySubject>();
    private List<QuerySubjectPool> m_poolList = new ArrayList<QuerySubjectPool>();

    public FmRelationshipInfo(FMMDSession session, List<? extends QuerySubject> sources, FmRelationshipTransformOptions options) {
        this.m_session = session;
        this.m_sources = sources;
        this.m_options = options;
    }

    public void execute() {
        this.buildTableList();
        this.processPoolList();
    }

    private void buildTableList() {
        for (QuerySubject querySubject : this.m_sources) {
            QuerySubjectInfo theQuerySubjectInfo = new QuerySubjectInfo();
            ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>();
            theQuerySubjectInfo.m_querySubject = querySubject;
            List<QueryItem> queryItems = querySubject.getAllQueryItems();
            for (QueryItem queryItem : queryItems) {
                theQuerySubjectInfo.m_columnList.add(new QueryItemInfo(queryItem));
            }
            if (!this.m_options.m_indexOption) continue;
            List<Determinant> determinants = querySubject.getDeterminants();
            for (Determinant determinant : determinants) {
                int indexColumnNum = 0;
                IndexInfo theIndexInfo = new IndexInfo();
                theIndexInfo.m_unique = determinant.isIdentifiesRow();
                List<QueryItem> refobjHandles = determinant.getKeys();
                for (QueryItem qi : refobjHandles) {
                    QueryItemInfo aColumn = new QueryItemInfo(qi);
                    theIndexInfo.m_columnList.add(aColumn);
                    ++indexColumnNum;
                }
                if (indexColumnNum <= 0) continue;
                Collections.sort(theIndexInfo.m_columnList);
                indexInfoList.add(theIndexInfo);
            }
            Collections.sort(theQuerySubjectInfo.m_columnList);
            theQuerySubjectInfo.m_completeColumnList.addAll(theQuerySubjectInfo.m_columnList);
            Collections.sort(indexInfoList);
            for (IndexInfo theIndexInfo : indexInfoList) {
                boolean isAcceptable = true;
                Iterator<IndexInfo> uniqueIndexIter = theQuerySubjectInfo.m_uniqueIndexList.iterator();
                while (uniqueIndexIter.hasNext() && isAcceptable) {
                    IndexInfo uniqueIndexInfo = uniqueIndexIter.next();
                    boolean bl = isAcceptable = !this.containsAll(uniqueIndexInfo.m_columnList, theIndexInfo.m_columnList);
                }
                if (!isAcceptable) continue;
                this.removeAll(theQuerySubjectInfo.m_columnList, theIndexInfo.m_columnList);
                if (theIndexInfo.m_unique) {
                    theQuerySubjectInfo.m_uniqueIndexList.add(theIndexInfo);
                    continue;
                }
                theQuerySubjectInfo.m_nonUniqueIndexList.add(theIndexInfo);
            }
            Collections.sort(theQuerySubjectInfo.m_columnList);
            this.mergeIntoPool(theQuerySubjectInfo);
        }
    }

    private void removeAll(List<QueryItemInfo> list, List<QueryItemInfo> list2) {
        Iterator<QueryItemInfo> it = list.iterator();
        while (it.hasNext()) {
            QueryItemInfo inf = it.next();
            boolean found = false;
            for (QueryItemInfo i2 : list2) {
                if (!i2.m_queryItem.getName().equals(inf.m_queryItem.getName())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            it.remove();
        }
    }

    private boolean containsAll(List<QueryItemInfo> list, List<QueryItemInfo> list2) {
        ArrayList<String> outerList = new ArrayList<String>();
        for (QueryItemInfo i : list) {
            String name = i.m_queryItem.getName();
            outerList.add(name);
        }
        ArrayList<String> innerList = new ArrayList<String>();
        for (QueryItemInfo i : list2) {
            String name = i.m_queryItem.getName();
            innerList.add(name);
        }
        return outerList.containsAll(innerList);
    }

    private void mergeIntoPool(QuerySubjectInfo info) {
        boolean bMerged = false;
        Iterator<QuerySubjectPool> theListIter = this.m_poolList.iterator();
        QuerySubjectPool theMerge = null;
        while (theListIter.hasNext()) {
            QuerySubjectPool pool = theListIter.next();
            if (!pool.intersects(info)) continue;
            if (!bMerged) {
                pool.merge(info);
                theMerge = pool;
                bMerged = true;
                continue;
            }
            theMerge.merge(pool);
        }
        if (!bMerged) {
            this.m_poolList.add(new QuerySubjectPool());
            this.m_poolList.get(this.m_poolList.size() - 1).merge(info);
        }
    }

    private void processPoolList() {
        for (QuerySubjectPool querySubjectPool : this.m_poolList) {
            if (querySubjectPool.m_querySubjectList.size() <= 1) continue;
            this.processTableList(querySubjectPool);
        }
    }

    private void processTableList(QuerySubjectPool querySubjectPool) {
        int i = 0;
        while (i < querySubjectPool.m_querySubjectList.size()) {
            QuerySubjectInfo outerTable = querySubjectPool.m_querySubjectList.get(i);
            int j = i + 1;
            while (j < querySubjectPool.m_querySubjectList.size()) {
                QuerySubjectInfo innerTable = querySubjectPool.m_querySubjectList.get(j);
                if (!outerTable.m_isProcessed || !innerTable.m_isProcessed) {
                    ArrayList<QueryItemInfo> intersectColumnList = new ArrayList<QueryItemInfo>();
                    intersectColumnList.addAll(innerTable.m_completeColumnList);
                    this.retainAll(intersectColumnList, outerTable.m_completeColumnList);
                    if (!intersectColumnList.isEmpty()) {
                        CompareResult overallResult = new CompareResult();
                        boolean canGenerate = true;
                        if (this.m_options.m_indexOption) {
                            if (canGenerate) {
                                overallResult = this.compareUniqueIndexes(outerTable, innerTable, intersectColumnList);
                                if (overallResult.m_allLeftMatch && overallResult.m_numberOfMatches > 0) {
                                    this.buildRelationship(overallResult);
                                    canGenerate = false;
                                }
                            }
                            if (canGenerate) {
                                overallResult = this.compareUniqueAndNonUniqueIndexes(outerTable, innerTable, intersectColumnList);
                                if (overallResult.m_allLeftMatch && overallResult.m_numberOfMatches > 0) {
                                    this.buildRelationship(overallResult);
                                    canGenerate = false;
                                }
                            }
                            if (canGenerate) {
                                overallResult = this.compareUniqueIndexesAndColumns(outerTable, innerTable, intersectColumnList);
                                if (overallResult.m_allLeftMatch && overallResult.m_numberOfMatches > 0) {
                                    this.buildRelationship(overallResult);
                                    canGenerate = false;
                                }
                            }
                        }
                        if (canGenerate && this.m_options.m_matchingNamesOption) {
                            overallResult = this.compareMatchingTypes(outerTable, innerTable);
                            if (overallResult.m_allLeftMatch && overallResult.m_numberOfMatches > 0) {
                                this.buildRelationship(overallResult);
                            }
                        }
                    }
                }
                ++j;
            }
            if (!outerTable.m_isProcessed) {
                outerTable.m_isProcessed = true;
            }
            ++i;
        }
    }

    private void retainAll(List<QueryItemInfo> list, List<QueryItemInfo> list2) {
        Iterator<QueryItemInfo> it = list.iterator();
        while (it.hasNext()) {
            QueryItemInfo inf = it.next();
            boolean found = false;
            for (QueryItemInfo i2 : list2) {
                if (!i2.m_queryItem.getName().equals(inf.m_queryItem.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            it.remove();
        }
    }

    private CompareResult compareColumnLists(QuerySubject leftQuerySubject, List<QueryItemInfo> leftColumnList, QuerySubject rightQuerySubject, List<QueryItemInfo> rightColumnList) {
        CompareResult localResults = new CompareResult();
        QueryItemInfo left = null;
        QueryItemInfo right = null;
        int i = 0;
        int j = 0;
        while (i < leftColumnList.size() && j < rightColumnList.size()) {
            left = leftColumnList.get(i);
            right = rightColumnList.get(j);
            if (left.m_queryItem.getName().compareTo(right.m_queryItem.getName()) < 0) {
                localResults.m_allLeftMatch = false;
                ++i;
                continue;
            }
            if (right.m_queryItem.getName().compareTo(left.m_queryItem.getName()) < 0) {
                localResults.m_allRightMatch = false;
                ++j;
                continue;
            }
            if (left.m_type == right.m_type) {
                localResults.m_queryItemMap.put(left.m_queryItem, right.m_queryItem);
                ++localResults.m_numberOfMatches;
            } else {
                localResults.m_allLeftMatch = false;
                localResults.m_allRightMatch = false;
            }
            ++i;
            ++j;
        }
        if (i < leftColumnList.size()) {
            localResults.m_allLeftMatch = false;
        }
        if (j < rightColumnList.size()) {
            localResults.m_allRightMatch = false;
        }
        localResults.m_leftQuerySubject = leftQuerySubject;
        localResults.m_rightQuerySubject = rightQuerySubject;
        localResults.m_largestIndexSize = rightColumnList.size();
        return localResults;
    }

    private CompareResult compareMatchingTypes(QuerySubjectInfo leftTable, QuerySubjectInfo rightTable) {
        CompareResult localResult = this.compareColumnLists(leftTable.m_querySubject, leftTable.m_completeColumnList, rightTable.m_querySubject, rightTable.m_completeColumnList);
        if (localResult.m_numberOfMatches > 0) {
            localResult.m_allLeftMatch = true;
            localResult.m_matchingNames = true;
        }
        return localResult;
    }

    private CompareResult compareUniqueIndexes(QuerySubjectInfo leftTable, QuerySubjectInfo rightTable, List<QueryItemInfo> intersectColumnList) {
        CompareResult latestResult = new CompareResult();
        CompareResult result = new CompareResult();
        for (IndexInfo leftIndex : leftTable.m_uniqueIndexList) {
            ArrayList<QueryItemInfo> localIntersectList = new ArrayList<QueryItemInfo>();
            localIntersectList.addAll(intersectColumnList);
            this.removeAll(localIntersectList, leftIndex.m_columnList);
            if (localIntersectList.isEmpty()) continue;
            for (IndexInfo rightIndex : rightTable.m_uniqueIndexList) {
                latestResult = leftIndex.m_columnList.size() <= rightIndex.m_columnList.size() ? this.compareColumnLists(leftTable.m_querySubject, leftIndex.m_columnList, rightTable.m_querySubject, rightIndex.m_columnList) : this.compareColumnLists(rightTable.m_querySubject, rightIndex.m_columnList, leftTable.m_querySubject, leftIndex.m_columnList);
                if (!latestResult.m_allLeftMatch || result.compareTo(latestResult) >= 0) continue;
                result = latestResult;
            }
        }
        return result;
    }

    private CompareResult compareUniqueAndNonUniqueIndexes(QuerySubjectInfo leftTable, QuerySubjectInfo rightTable, List<QueryItemInfo> intersectColumnList) {
        ArrayList<QueryItemInfo> localIntersectList;
        CompareResult latestResult = new CompareResult();
        CompareResult result = new CompareResult();
        for (IndexInfo uniqueIndex : leftTable.m_uniqueIndexList) {
            localIntersectList = new ArrayList<QueryItemInfo>();
            localIntersectList.addAll(intersectColumnList);
            this.retainAll(localIntersectList, uniqueIndex.m_columnList);
            if (localIntersectList.isEmpty()) continue;
            for (IndexInfo nonUniqueIndex : rightTable.m_nonUniqueIndexList) {
                if (uniqueIndex.m_columnList.size() > nonUniqueIndex.m_columnList.size()) continue;
                latestResult = this.compareColumnLists(leftTable.m_querySubject, uniqueIndex.m_columnList, rightTable.m_querySubject, nonUniqueIndex.m_columnList);
                if (!latestResult.m_allLeftMatch) continue;
                latestResult.m_allRightMatch = false;
                if (result.compareTo(latestResult) >= 0) continue;
                result = latestResult;
            }
        }
        for (IndexInfo uniqueIndex : rightTable.m_uniqueIndexList) {
            localIntersectList = new ArrayList();
            localIntersectList.addAll(intersectColumnList);
            this.retainAll(localIntersectList, uniqueIndex.m_columnList);
            if (localIntersectList.isEmpty()) continue;
            for (IndexInfo nonUniqueIndex : rightTable.m_nonUniqueIndexList) {
                if (uniqueIndex.m_columnList.size() > nonUniqueIndex.m_columnList.size()) continue;
                latestResult = this.compareColumnLists(rightTable.m_querySubject, uniqueIndex.m_columnList, leftTable.m_querySubject, nonUniqueIndex.m_columnList);
                if (!latestResult.m_allLeftMatch) continue;
                latestResult.m_allRightMatch = false;
                if (result.compareTo(latestResult) >= 0) continue;
                result = latestResult;
            }
        }
        return result;
    }

    private CompareResult compareUniqueIndexesAndColumns(QuerySubjectInfo leftTable, QuerySubjectInfo rightTable, List<QueryItemInfo> intersectColumnList) {
        CompareResult latestResult = new CompareResult();
        CompareResult result = new CompareResult();
        ArrayList<QueryItemInfo> localIntersectList = new ArrayList<QueryItemInfo>();
        localIntersectList.addAll(intersectColumnList);
        this.retainAll(localIntersectList, rightTable.m_completeColumnList);
        if (!localIntersectList.isEmpty()) {
            for (IndexInfo uniqueIndex : leftTable.m_uniqueIndexList) {
                if (uniqueIndex.m_columnList.size() > rightTable.m_completeColumnList.size()) continue;
                latestResult = this.compareColumnLists(leftTable.m_querySubject, uniqueIndex.m_columnList, rightTable.m_querySubject, rightTable.m_completeColumnList);
                if (!latestResult.m_allLeftMatch) continue;
                latestResult.m_allRightMatch = false;
                if (result.compareTo(latestResult) >= 0) continue;
                result = latestResult;
            }
        }
        localIntersectList.clear();
        localIntersectList.addAll(intersectColumnList);
        this.retainAll(localIntersectList, leftTable.m_completeColumnList);
        if (!localIntersectList.isEmpty()) {
            for (IndexInfo uniqueIndex : rightTable.m_uniqueIndexList) {
                if (uniqueIndex.m_columnList.size() > leftTable.m_completeColumnList.size()) continue;
                latestResult = this.compareColumnLists(rightTable.m_querySubject, uniqueIndex.m_columnList, leftTable.m_querySubject, leftTable.m_completeColumnList);
                if (!latestResult.m_allLeftMatch) continue;
                latestResult.m_allRightMatch = false;
                if (result.compareTo(latestResult) >= 0) continue;
                result = latestResult;
            }
        }
        return result;
    }

    private void buildRelationship(CompareResult overallResult) {
        this.m_numRelationships += FmRelationshipTransform.relationshipOnIndex(this.m_session, overallResult.m_leftQuerySubject, overallResult.m_rightQuerySubject, overallResult.m_queryItemMap, overallResult.m_allRightMatch, overallResult.m_matchingNames);
    }

    int getNumRelationships() {
        return this.m_numRelationships;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareResult
    implements Comparable<CompareResult> {
        QuerySubject m_leftQuerySubject = null;
        QuerySubject m_rightQuerySubject = null;
        int m_numberOfMatches = 0;
        int m_largestIndexSize = 0;
        boolean m_allLeftMatch = true;
        boolean m_allRightMatch = true;
        boolean m_matchingNames = false;
        Map<QueryItem, QueryItem> m_queryItemMap = new HashMap<QueryItem, QueryItem>();

        private CompareResult() {
        }

        @Override
        public int compareTo(CompareResult o) {
            return this.m_numberOfMatches == o.m_numberOfMatches ? this.m_largestIndexSize - o.m_largestIndexSize : this.m_numberOfMatches - o.m_numberOfMatches;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexInfo
    implements Comparable<IndexInfo> {
        boolean m_unique = false;
        List<QueryItemInfo> m_columnList = new ArrayList<QueryItemInfo>();

        private IndexInfo() {
        }

        @Override
        public int compareTo(IndexInfo o) {
            return o.m_unique == this.m_unique ? this.m_columnList.size() - o.m_columnList.size() : (this.m_unique ? 1 : 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryItemInfo
    implements Comparable<QueryItemInfo> {
        QueryItem m_queryItem;
        FmOperandType m_type;

        QueryItemInfo(QueryItem queryItem) {
            this.m_queryItem = queryItem;
            FmDatatype datatype = queryItem.getDatatype();
            this.m_type = FmOperandType.fromFmDatatype(datatype);
        }

        public boolean equals(Object o) {
            if (o instanceof QueryItemInfo) {
                return this.m_queryItem.getName().equals(((QueryItemInfo)o).m_queryItem.getName());
            }
            return false;
        }

        @Override
        public int compareTo(QueryItemInfo o) {
            return this.m_queryItem.getName().compareTo(o.m_queryItem.getName());
        }
    }

    private class QuerySubjectInfo {
        QuerySubject m_querySubject;
        List<IndexInfo> m_uniqueIndexList = new ArrayList<IndexInfo>();
        List<IndexInfo> m_nonUniqueIndexList = new ArrayList<IndexInfo>();
        List<QueryItemInfo> m_columnList = new ArrayList<QueryItemInfo>();
        List<QueryItemInfo> m_completeColumnList = new ArrayList<QueryItemInfo>();
        boolean m_isProcessed = false;

        private QuerySubjectInfo() {
        }
    }

    private class QuerySubjectPool {
        Set<String> m_columnHashSet = new HashSet<String>();
        List<QuerySubjectInfo> m_querySubjectList = new ArrayList<QuerySubjectInfo>();

        private QuerySubjectPool() {
        }

        boolean intersects(QuerySubjectInfo querySubjectInfo) {
            Iterator<QueryItemInfo> iter = querySubjectInfo.m_completeColumnList.iterator();
            boolean intersects = false;
            while (iter.hasNext() && !intersects) {
                QueryItemInfo next = iter.next();
                intersects = this.m_columnHashSet.contains(next.m_queryItem.getName());
            }
            return intersects;
        }

        void merge(QuerySubjectInfo querySubjectInfo) {
            Iterator<QueryItemInfo> iter = querySubjectInfo.m_completeColumnList.iterator();
            while (iter.hasNext()) {
                this.m_columnHashSet.add(iter.next().m_queryItem.getName());
            }
            this.m_querySubjectList.add(querySubjectInfo);
        }

        void merge(QuerySubjectPool querySubjectPool) {
            Iterator<String> iter = querySubjectPool.m_columnHashSet.iterator();
            while (iter.hasNext()) {
                this.m_columnHashSet.add(iter.next());
            }
            Iterator<QuerySubjectInfo> theListIter = querySubjectPool.m_querySubjectList.iterator();
            while (theListIter.hasNext()) {
                this.m_querySubjectList.add(theListIter.next());
            }
            querySubjectPool.m_columnHashSet.clear();
            querySubjectPool.m_querySubjectList.clear();
        }
    }
}

