/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmRelationshipInfo;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmRelationshipTransformOptions;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRelationshipTransform {
    private FMMDSession m_session;
    private List<? extends QuerySubject> m_inSources;
    private FmRelationshipTransformOptions m_options = null;

    public FmRelationshipTransform(FMMDSession session, List<? extends QuerySubject> inSources, FmRelationshipTransformOptions options) {
        this.m_session = session;
        this.m_inSources = inSources;
        this.m_options = options;
    }

    public int buildRelationships() {
        int numRelationships = 0;
        if (this.m_options.m_indexOption || this.m_options.m_matchingNamesOption) {
            numRelationships = this.relationshipOnIndexes();
        }
        return numRelationships;
    }

    private int relationshipOnIndexes() {
        int numRelationships = 0;
        if (this.m_options.m_insideOption) {
            FmRelationshipInfo info = new FmRelationshipInfo(this.m_session, this.m_inSources, this.m_options);
            info.execute();
            return numRelationships += info.getNumRelationships();
        }
        Object modelEObject = FmModelFactory.getInstance().getProject(this.m_session).getRootNamespace().getInternal();
        ArrayList eQuerySubjects = new ArrayList();
        HashSet<Integer> recurseInto = new HashSet<Integer>();
        recurseInto.add(88);
        recurseInto.add(148);
        HashMap<Integer, List<Object>> collect = new HashMap<Integer, List<Object>>();
        collect.put(124, eQuerySubjects);
        EmfHelper.collect(modelEObject, recurseInto, collect);
        ArrayList<QuerySubject> outsideSources = new ArrayList<QuerySubject>();
        for (Object e : eQuerySubjects) {
            QuerySubject qs = (QuerySubject)FmModelFactory.getInstance().get(this.m_session, e);
            if (this.m_inSources.contains(qs)) continue;
            outsideSources.add(qs);
        }
        for (QuerySubject querySubject : this.m_inSources) {
            for (QuerySubject outsideSource : outsideSources) {
                ArrayList<QuerySubject> sources = new ArrayList<QuerySubject>();
                sources.add(querySubject);
                sources.add(outsideSource);
                FmRelationshipInfo info = new FmRelationshipInfo(this.m_session, sources, this.m_options);
                info.execute();
                numRelationships += info.getNumRelationships();
            }
        }
        return numRelationships;
    }

    static int relationshipOnIndex(FMMDSession session, QuerySubject leftTableHandle, QuerySubject rightTableHandle, Map<QueryItem, QueryItem> columnMap, boolean bothUnique, boolean bMatchingNames) {
        boolean bOuterJoinOption = false;
        boolean bCardinalityOneOption = false;
        ArrayList<QueryItem> leftColumns = new ArrayList<QueryItem>();
        ArrayList<QueryItem> rightColumns = new ArrayList<QueryItem>();
        Set<Map.Entry<QueryItem, QueryItem>> entries = columnMap.entrySet();
        for (Map.Entry<QueryItem, QueryItem> entry : entries) {
            QueryItem leftColumn = entry.getKey();
            QueryItem rightColumn = entry.getValue();
            leftColumns.add(leftColumn);
            rightColumns.add(rightColumn);
        }
        Cardinality card = new Cardinality();
        card = bMatchingNames ? FmRelationshipTransform.setCardinalitiesForMatchingNames(leftColumns, rightColumns, bothUnique, bOuterJoinOption, bCardinalityOneOption) : FmRelationshipTransform.setCardinalitiesForIndexes(bothUnique, bOuterJoinOption, bCardinalityOneOption);
        FmRelationshipTransform.buildRelationship(session, leftTableHandle, rightTableHandle, leftColumns, rightColumns, card);
        return 1;
    }

    private static void buildRelationship(FMMDSession session, QuerySubject leftTableHandle, QuerySubject rightTableHandle, List<QueryItem> leftColumns, List<QueryItem> rightColumns, Cardinality card) {
        FmExpressionBuilder expr = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
        Iterator<QueryItem> leftIter = leftColumns.iterator();
        Iterator<QueryItem> rightIter = rightColumns.iterator();
        while (leftIter.hasNext()) {
            QueryItem leftQueryItem = leftIter.next();
            QueryItem rightQueryItem = rightIter.next();
            if (expr.getExpressionParts().size() > 0) {
                expr.addExpressionPart(" AND ", null);
            }
            expr.addExpressionPart(leftQueryItem, null, null);
            expr.addExpressionPart(" = ", null);
            expr.addExpressionPart(rightQueryItem, null, null);
        }
        Relationship relationship = session.getProject().getRootNamespace().createRelationship(expr, leftTableHandle, rightTableHandle);
        relationship.setLeftMaxcard(card.s_leftMaxCard);
        relationship.setLeftMincard(card.s_leftMinCard);
        relationship.setRightMaxcard(card.s_rightMaxCard);
        relationship.setRightMincard(card.s_rightMinCard);
    }

    private static Cardinality setCardinalitiesForIndexes(boolean bUnique, boolean bOuterJoinOption, boolean bCardinalityOneOption) {
        Cardinality card = new Cardinality();
        card.s_rightMinCard = card.s_leftMinCard = bOuterJoinOption ? Cardinality.ECardinality.zero : Cardinality.ECardinality.one;
        card.s_leftMaxCard = Cardinality.ECardinality.one;
        card.s_rightMaxCard = bCardinalityOneOption || bUnique ? Cardinality.ECardinality.one : Cardinality.ECardinality.many;
        return card;
    }

    private static Cardinality setCardinalitiesForMatchingNames(List<QueryItem> leftColumnPaths, List<QueryItem> rightColumnPaths, boolean bUnique, boolean bOuterJoinOption, boolean bCardinalityOneOption) {
        Cardinality card = new Cardinality();
        card.s_leftMinCard = Cardinality.ECardinality.one;
        card.s_rightMinCard = Cardinality.ECardinality.one;
        card.s_leftMaxCard = bCardinalityOneOption ? Cardinality.ECardinality.one : Cardinality.ECardinality.many;
        Cardinality.ECardinality eCardinality = card.s_rightMaxCard = bCardinalityOneOption ? Cardinality.ECardinality.one : Cardinality.ECardinality.many;
        if (bOuterJoinOption) {
            card.s_leftMinCard = FmRelationshipTransform.isNullable(rightColumnPaths) ? Cardinality.ECardinality.zero : Cardinality.ECardinality.one;
            card.s_rightMinCard = FmRelationshipTransform.isNullable(leftColumnPaths) ? Cardinality.ECardinality.zero : Cardinality.ECardinality.one;
        }
        return card;
    }

    private static boolean isNullable(List<QueryItem> columns) {
        for (QueryItem item : columns) {
            if (!item.getNullable()) continue;
            return true;
        }
        return false;
    }

    public static class Cardinality {
        Cardinality.ECardinality s_leftMinCard;
        Cardinality.ECardinality s_leftMaxCard;
        Cardinality.ECardinality s_rightMinCard;
        Cardinality.ECardinality s_rightMaxCard;
    }
}

