/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmScopeRelationship;
import com.ibm.cognos.fmeng.fmmd.model.Dimension;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.ShortcutTarget;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmScopeRelationshipTransform {
    private FMMDSession m_session;
    private List<? extends ReportObject> m_objList = new ArrayList<ReportObject>();

    public FmScopeRelationshipTransform(FMMDSession session, List<? extends ReportObject> objList) {
        this.m_session = session;
        this.m_objList = objList;
    }

    public List<FmScopeRelationship> doTransform() {
        ArrayList<RelationshipEnd> vhSelections = new ArrayList<RelationshipEnd>();
        ArrayList<Dimension> vhSelectionTargets = new ArrayList<Dimension>();
        for (ReportObject reportObject : this.m_objList) {
            Dimension dim = FmScopeRelationshipTransform.getDimensionFor(reportObject);
            vhSelections.add((RelationshipEnd)reportObject);
            vhSelectionTargets.add(dim);
        }
        if (vhSelections.size() == 0) {
            return null;
        }
        ArrayList<RelationshipEnd> arrayList = new ArrayList<RelationshipEnd>();
        ArrayList<RelationshipEnd> vhRegularDims = new ArrayList<RelationshipEnd>();
        if (vhSelections.size() == 1) {
            FmScopeRelationship.findScopingCandidates(this.m_session, (RelationshipEnd)vhSelections.get(0), arrayList, vhRegularDims);
        } else {
            int idx = 0;
            while (idx < vhSelections.size()) {
                FmDimension objDim = (FmDimension)(vhSelectionTargets.get(idx) == null ? (ReportObject)vhSelections.get(idx) : (ReportObject)vhSelectionTargets.get(idx));
                if (objDim.getDimensionStyle() == DimensionBase.DimensionStyle.measure) {
                    arrayList.add((RelationshipEnd)vhSelections.get(idx));
                } else {
                    vhRegularDims.add((RelationshipEnd)vhSelections.get(idx));
                }
                ++idx;
            }
        }
        List<FmScopeRelationship> vhNewScopeRels = new ArrayList<FmScopeRelationship>();
        int mIdx = 0;
        while (mIdx < arrayList.size()) {
            vhNewScopeRels = FmScopeRelationship.transformScopes(this.m_session, (RelationshipEnd)arrayList.get(mIdx), vhRegularDims);
            ++mIdx;
        }
        return vhNewScopeRels;
    }

    public static Dimension getDimensionFor(ReportObject obj) {
        FmObjectType objType = obj.getFmObjectType();
        switch (objType) {
            case dimension: {
                return (Dimension)obj;
            }
            case shortcut: {
                ShortcutTarget refobj = ((Shortcut)obj).getRefobj();
                if (!(refobj instanceof FmDimension)) break;
                return (Dimension)refobj;
            }
        }
        FmMDException.ASSERT(false, "TransformCreateScopeRelationships *** valid only for objects of type dimension or shortcuts to such objects");
        return null;
    }
}

