/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmOperandType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.UsageAggregate;
import com.ibm.cognos.fmeng.fmmd.util.ObjectHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmUsageAggregateTransformer {
    private FMMDSession m_session;
    private boolean m_bReset;
    private Map<FmQuerySubjectBase, List<FmQueryItemBase>> m_queryParentReportItems = new HashMap<FmQuerySubjectBase, List<FmQueryItemBase>>();
    private List<FmCalculation> m_vhCalculations = new ArrayList<FmCalculation>();

    public static void transformUsage(FMMDSession session, List<BaseObject> vhSources, boolean bReset) {
        FmUsageAggregateTransformer myTransformer = new FmUsageAggregateTransformer(session, bReset);
        myTransformer.examineSources(vhSources);
        Set<Map.Entry<FmQuerySubjectBase, List<FmQueryItemBase>>> entries = myTransformer.m_queryParentReportItems.entrySet();
        for (Map.Entry<FmQuerySubjectBase, List<FmQueryItemBase>> entry : entries) {
            FmQuerySubjectBase objQuery = entry.getKey();
            List<FmQueryItemBase> items = entry.getValue();
            objQuery.transformUsage(items, bReset);
        }
        for (FmCalculation cal : myTransformer.m_vhCalculations) {
            myTransformer.determineCalculationUsage(cal);
        }
    }

    public static void transformAggregate(FMMDSession session, List<BaseObject> vhSources, boolean bReset) {
        FmUsageAggregateTransformer myTransformer = new FmUsageAggregateTransformer(session, bReset);
        myTransformer.examineSources(vhSources);
        Set<Map.Entry<FmQuerySubjectBase, List<FmQueryItemBase>>> entries = myTransformer.m_queryParentReportItems.entrySet();
        for (Map.Entry<FmQuerySubjectBase, List<FmQueryItemBase>> entry : entries) {
            FmQuerySubjectBase objQuery = entry.getKey();
            List<FmQueryItemBase> items = entry.getValue();
            objQuery.transformAggregate(items, bReset);
        }
        for (FmCalculation cal : myTransformer.m_vhCalculations) {
            myTransformer.determineCalculationAggregate(cal);
        }
    }

    public FmUsageAggregateTransformer(FMMDSession session, boolean bReset) {
        this.m_session = session;
        this.m_bReset = bReset;
    }

    public void determineBasicUsage(UsageAggregate hReportItem, List<QueryItemBase> vhKeys) {
        if (!this.canSetUsage(hReportItem)) {
            return;
        }
        FmUsage sUsage = vhKeys.contains(hReportItem) ? FmUsage.identifier : this.determineUsageFromDatatype(hReportItem.getDatatype());
        if (FmUsage.unknown != sUsage) {
            hReportItem.setUsage(sUsage);
        }
    }

    public void determineBasedOnUsage(UsageAggregate hReportItem, UsageAggregate hBasedOnReportItem, List<QueryItemBase> vhKeys) {
        if (!this.canSetUsage(hReportItem)) {
            return;
        }
        FmUsage sUsage = FmUsage.unknown;
        if (vhKeys.contains(hReportItem)) {
            sUsage = FmUsage.identifier;
        } else if (hBasedOnReportItem != null) {
            sUsage = hBasedOnReportItem.getUsage();
        }
        if (sUsage == FmUsage.unknown) {
            this.determineBasicUsage(hReportItem, vhKeys);
        } else {
            hReportItem.setUsage(sUsage);
        }
    }

    public void determineBasicAggregate(UsageAggregate reportItem) {
        FmRegularAggregate sRglrAggregate = FmRegularAggregate.unsupported;
        FmRegularAggregate sSemiAggregate = FmRegularAggregate.unsupported;
        FmDatatype datatype = reportItem.getDatatype();
        FmOperandType opType = FmOperandType.fromFmDatatype(datatype);
        switch (opType) {
            case kOperandTypeNumeric: 
            case kOperandTypeTimeInterval: {
                FmUsage usage = reportItem.getUsage();
                if (FmUsage.fact == usage) {
                    sRglrAggregate = FmRegularAggregate.sum;
                    sSemiAggregate = FmRegularAggregate.sum;
                    break;
                }
                sRglrAggregate = FmRegularAggregate.count;
                sSemiAggregate = FmRegularAggregate.unsupported;
                break;
            }
            default: {
                sSemiAggregate = FmRegularAggregate.unsupported;
            }
        }
        if (this.canSetRegularAggregate(reportItem)) {
            reportItem.setRegularAggregate(sRglrAggregate);
        }
        if (this.canSetSemiAggregate(reportItem)) {
            reportItem.setSemiAggregate(sSemiAggregate);
        }
    }

    public void determineBasedOnAggregate(UsageAggregate hReportItem, UsageAggregate hBasedOnReportItem) {
        if (hBasedOnReportItem != null) {
            FmRegularAggregate sRglrAggregate = hBasedOnReportItem.getRegularAggregate();
            FmRegularAggregate sSemiAggregate = hBasedOnReportItem.getSemiAggregate();
            if (this.canSetRegularAggregate(hReportItem)) {
                hReportItem.setRegularAggregate(sRglrAggregate);
            }
            if (this.canSetSemiAggregate(hReportItem)) {
                hReportItem.setSemiAggregate(sSemiAggregate);
            }
        } else {
            this.determineBasicAggregate(hReportItem);
        }
    }

    public void determineUsageForRegularDim(List<QueryItemBase> vhQueryItems) {
        for (QueryItemBase item : vhQueryItems) {
            item.setUsage(FmUsage.attribute);
        }
    }

    public void determineAggregateForRegularDim(List<QueryItemBase> vhQueryItems) {
        for (QueryItemBase item : vhQueryItems) {
            item.setRegularAggregate(FmRegularAggregate.unsupported);
            item.setSemiAggregate(FmRegularAggregate.unsupported);
        }
    }

    public void determineUsageForMeasureDim(List<QueryItemBase> vhQueryItems, List<Measure> vhMeasures) {
        for (QueryItemBase queryItemBase : vhQueryItems) {
            queryItemBase.setUsage(FmUsage.identifier);
        }
        for (Measure measure : vhMeasures) {
            measure.setUsage(FmUsage.fact);
        }
    }

    public void determineAggregateForMeasureDim(List<QueryItemBase> vhQueryItems, List<Measure> vhMeasures) {
        for (QueryItemBase queryItemBase : vhQueryItems) {
            this.determineBasicAggregate(queryItemBase);
        }
        for (Measure measure : vhMeasures) {
            this.determineBasicAggregate(measure);
        }
    }

    private boolean canSetUsage(UsageAggregate hReportItem) {
        if (this.m_bReset) {
            return true;
        }
        FmUsage hProp = hReportItem.getUsage();
        return hProp == FmUsage.unknown;
    }

    private boolean canSetRegularAggregate(UsageAggregate reportItem) {
        if (this.m_bReset) {
            return true;
        }
        FmRegularAggregate hProp = reportItem.getRegularAggregate();
        return hProp == FmRegularAggregate.unsupported;
    }

    private boolean canSetSemiAggregate(UsageAggregate reportItem) {
        if (this.m_bReset) {
            return true;
        }
        FmRegularAggregate hProp = reportItem.getSemiAggregate();
        return hProp == FmRegularAggregate.unsupported;
    }

    private void determineCalculationUsage(FmCalculation cal) {
        FmUsage sUsage = this.determineUsageFromDatatype(cal.getDatatype());
        if (FmUsage.unknown != sUsage) {
            cal.setUsage(sUsage);
        }
    }

    private void determineCalculationAggregate(FmCalculation cal) {
        FmRegularAggregate sRglrAggregate = FmRegularAggregate.unsupported;
        FmRegularAggregate sSemiAggregate = FmRegularAggregate.unsupported;
        FmDatatype datatype = cal.getDatatype();
        FmOperandType opType = FmOperandType.fromFmDatatype(datatype);
        switch (opType) {
            case kOperandTypeNumeric: 
            case kOperandTypeTimeInterval: {
                FmUsage usage = cal.getUsage();
                if (FmUsage.fact == usage) {
                    sRglrAggregate = FmRegularAggregate.automatic;
                    sSemiAggregate = FmRegularAggregate.automatic;
                    break;
                }
                sRglrAggregate = FmRegularAggregate.count;
                sSemiAggregate = FmRegularAggregate.unsupported;
                break;
            }
            default: {
                sSemiAggregate = FmRegularAggregate.unsupported;
            }
        }
        if (!sRglrAggregate.equals((Object)FmRegularAggregate.unsupported)) {
            cal.setRegularAggregate(sRglrAggregate);
        }
        if (!sSemiAggregate.equals((Object)FmRegularAggregate.unsupported)) {
            cal.setSemiAggregate(sSemiAggregate);
        }
    }

    private FmUsage determineUsageFromDatatype(FmDatatype datatype) {
        FmUsage sUsage;
        FmOperandType opType = FmOperandType.fromFmDatatype(datatype);
        switch (opType) {
            case kOperandTypeNumeric: 
            case kOperandTypeTimeInterval: {
                sUsage = FmUsage.fact;
                break;
            }
            case kOperandTypeDate: 
            case kOperandTypeDateTime: 
            case kOperandTypeTime: {
                sUsage = FmUsage.identifier;
                break;
            }
            default: {
                sUsage = FmUsage.attribute;
            }
        }
        return sUsage;
    }

    private void examineSources(List<BaseObject> vhSources) {
        ArrayList<FmBaseObject> vhMDQueryObjects = new ArrayList<FmBaseObject>();
        ArrayList vhEmpty = new ArrayList();
        block7: for (BaseObject obj : vhSources) {
            FmBaseObject sourceObj = (FmBaseObject)obj;
            FmObjectType sObjType = sourceObj.getFmObjectType();
            switch (sObjType) {
                case dimension: 
                case querySubject: {
                    FmQuerySubjectBase qsBaseObj = (FmQuerySubjectBase)sourceObj;
                    if (this.isMultidimensionalQueryObject(qsBaseObj, vhMDQueryObjects)) continue block7;
                    this.m_queryParentReportItems.put(qsBaseObj, vhEmpty);
                    break;
                }
                case measure: 
                case queryItem: {
                    FmQueryItemBase item = (FmQueryItemBase)sourceObj;
                    FmQuerySubjectBase objQuery = (FmQuerySubjectBase)item.getQueryParent();
                    if (this.isMultidimensionalQueryObject(objQuery, vhMDQueryObjects)) continue block7;
                    List<FmQueryItemBase> items = this.m_queryParentReportItems.get(objQuery);
                    if (items == null) {
                        items = new ArrayList<FmQueryItemBase>();
                        this.m_queryParentReportItems.put(objQuery, items);
                    }
                    items.add(item);
                    break;
                }
                case hierarchy: 
                case level: 
                case queryItemFolder: {
                    FmQueryItemBase item = (FmQueryItem)sourceObj;
                    FmQuerySubjectBase objQuery = (FmQuerySubjectBase)item.getQueryParent();
                    if (this.isMultidimensionalQueryObject(objQuery, vhMDQueryObjects)) continue block7;
                    List<QueryItem> vhQueryItems = objQuery.getAllQueryItems();
                    for (QueryItem queryItem : vhQueryItems) {
                        FmQueryItem qItem = (FmQueryItem)queryItem;
                        List<FmQueryItemBase> items = this.m_queryParentReportItems.get(objQuery);
                        if (items == null) {
                            items = new ArrayList<FmQueryItemBase>();
                            this.m_queryParentReportItems.put(objQuery, items);
                        }
                        items.add(qItem);
                    }
                    continue block7;
                }
                case measureFolder: {
                    FmDimension hParentQSubj = (FmDimension)((FmQueryItem)sourceObj).getQueryParent();
                    List<Measure> vhMeasures = hParentQSubj.getAllMeasures();
                    if (this.isMultidimensionalQueryObject(hParentQSubj, vhMDQueryObjects)) continue block7;
                    for (Measure measure : vhMeasures) {
                        List<FmQueryItemBase> items = this.m_queryParentReportItems.get(hParentQSubj);
                        if (items == null) {
                            items = new ArrayList<FmQueryItemBase>();
                            this.m_queryParentReportItems.put(hParentQSubj, items);
                        }
                        items.add((FmMeasure)measure);
                    }
                    continue block7;
                }
                case calculation: {
                    this.m_vhCalculations.add((FmCalculation)sourceObj);
                    break;
                }
                default: {
                    throw new FmMDException("BMT_MD_FEATURE_NOT_IMPLEMENTED");
                }
            }
        }
        if (!vhMDQueryObjects.isEmpty()) {
            FmMDException error = new FmMDException();
            FmQuerySubjectBase queryObject = (FmQuerySubjectBase)vhMDQueryObjects.get(0);
            String localizedDefinitionType = queryObject.getLocalizedDefinitionType();
            int indentLevel = 1;
            boolean includeType = true;
            String renderedObjectNameList = ObjectHelper.renderObjects(this.m_session, vhMDQueryObjects, indentLevel, includeType);
            Object[] msgParams = new Object[]{renderedObjectNameList, localizedDefinitionType};
            FmMessage fmMessage = new FmMessage("BMT_MD_UNSUPPORTED_OPERATION_TYPE", msgParams);
            error.addMessage(fmMessage);
            throw error;
        }
    }

    private boolean isMultidimensionalQueryObject(FmQuerySubjectBase objQuery, List<FmBaseObject> vhMDQueryObjects) {
        boolean bIsTypeMD;
        QuerySubjectBase.EDefinitionType eQueryObjDefType = objQuery.getDefinitionType();
        boolean bl = bIsTypeMD = eQueryObjDefType == QuerySubjectBase.EDefinitionType.kTypeMultiDimensionalQuery;
        if (bIsTypeMD) {
            vhMDQueryObjects.add(objQuery);
        }
        return bIsTypeMD;
    }
}

