/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.UiComponentEnum;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityView;
import com.ibm.cognos.fmeng.fmmd.model.LocalizedValue;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.EventCallbackHandler;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.EMFCustomModelSerializer;
import com.ibm.cognos.fmeng.utility.FileUtils;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import com.ibm.cognos.fmeng.utility.soap.ContentManagerServiceRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class ModelPublisher {
    private FMMDSession m_session;

    public ModelPublisher(FMMDSession session) {
        this.m_session = session;
    }

    public String publishModelToCM(String parentSearchPath, String packageName, String modelName, ReportObject obj) {
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_session, "Start publish model to CM: " + parentSearchPath);
        String ret = this.addPackageToSesssion(parentSearchPath, packageName, modelName, obj);
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_session, "End publish model to CM: " + parentSearchPath + ":\n\t" + ret);
        return ret;
    }

    String addPackageToSesssion(String parentPath, String pkgName, String modelName, ReportObject obj) {
        FmPackage kPackage = null;
        ArrayList<String> names = new ArrayList<String>();
        if (obj != null) {
            pkgName = obj.getName(this.m_session.getProject().getDefaultLocale());
            if (obj instanceof FmPackage) {
                kPackage = (FmPackage)obj;
            }
            for (LocalizedValue lv : obj.getNames()) {
                names.add(lv.getValue());
            }
        } else {
            if (pkgName == null || pkgName.isEmpty()) {
                FmMDException.ASSERT(true, "The package that you are attempting to publish is neither a Report object nor does it have a name assigned to it.");
            }
            names.add(pkgName);
        }
        ContentManagerServiceRequest cmsr = new ContentManagerServiceRequest(this.m_session.getActiveLocale(), this.m_session.getPassport());
        ArrayList<UiComponentEnum> userInterfaces = new ArrayList<UiComponentEnum>();
        HashMap<String, List<BaseClass>> securityViews = new HashMap<String, List<BaseClass>>();
        BaseClass foundPkg = cmsr.findPackage(parentPath, names, null, userInterfaces, securityViews);
        String pkgPath = null;
        BaseClass everyoneRole = cmsr.queryForRole("CAMID(\"::Everyone\")");
        FmMDException.ASSERT(everyoneRole != null, "Failed to get Everyone");
        ArrayList<BaseClass> everyoneRoles = new ArrayList<BaseClass>(1);
        everyoneRoles.add(everyoneRole);
        securityViews.put("[].[securityViews].[_Everyone]", everyoneRoles);
        if (foundPkg == null) {
            pkgPath = cmsr.createPackage(parentPath, pkgName, this.m_session.getProject().getDefaultLocale(), obj);
        } else {
            EventCallbackHandler callback;
            CmHelper cmHelper;
            pkgPath = foundPkg.getSearchPath().getValue();
            if (obj instanceof FmPackage && ((cmHelper = CmHelper.get(this.m_session, this.m_session.getPassport())).checkIfCMObjectHasMultiLocaleRenameIssues(foundPkg, ((FmReportObject)obj).getNames()) ? (callback = this.m_session.getEventCallbackHandler()) != null && !callback.doBooleanPrompt(new FmMessage("BMT_UIP_FAILED_TO_DEPLOY_PACKAGE_NAME_COLLISION_IN_MULTIPLE_LOCALE", obj.getName())) : (callback = this.m_session.getEventCallbackHandler()) != null && !callback.doBooleanPrompt(new FmMessage("BMT_UIP_REPLUBLISH_PACKAGE_CONFIRMATION", obj.getName())))) {
                throw new FmMDException("BMT_MD_CANCELED");
            }
            pkgPath = cmsr.updatePackage(pkgPath, pkgName, this.m_session.getProject().getDefaultLocale(), obj);
        }
        if (userInterfaces.size() == 0) {
            cmsr.updateUIInterfacesForDynamicCubes(pkgPath);
        }
        if (!"~~".equals(parentPath) && !cmsr.packageConfigurationExists(parentPath, pkgName)) {
            cmsr.createPackageConfiguration(parentPath, pkgName);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(1000000);
        try {
            GZIPOutputStream gzipstream = new GZIPOutputStream(stream);
            EMFCustomModelSerializer serializer = new EMFCustomModelSerializer(gzipstream, (XMLResource)((EMFSession)this.m_session).getResource(), null);
            serializer.serialize((EObject)this.m_session.getProject().getInternal(), true);
            gzipstream.flush();
            stream.flush();
            gzipstream.close();
            this.dumpStream(stream, false);
            boolean bQueryMode = this.m_session.getProject().getDynamicQueryMode();
            String modelPath = cmsr.createModel(pkgPath, true, modelName, bQueryMode, stream);
            List<FmSecurityView> views = ((FmProject)this.m_session.getProject()).getSecurityViewsFolder().getSecurityViews();
            if (views.size() > 0) {
                for (FmSecurityView sv : views) {
                    String modelViewName = sv.getID();
                    cmsr.addModelView(modelPath, modelViewName, securityViews.get(modelViewName));
                }
            } else {
                FmSecurityView sv = null;
                String svName = "All";
                if (kPackage != null && (sv = kPackage.getSecurityView()) != null) {
                    svName = sv.getName();
                }
                cmsr.addModelView(modelPath, "[].[securityViews].[" + svName + "]", null);
            }
            return modelPath;
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    private void dumpStream(ByteArrayOutputStream stream, boolean bDump) {
        if (!bDump) {
            return;
        }
        byte[] bytes = stream.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        StringBuilder builder = new StringBuilder("..//temp//lwmstream_");
        builder.append(System.nanoTime());
        builder.append(".xml");
        File blat = new File(builder.toString());
        try {
            GZIPInputStream gin = new GZIPInputStream(in);
            FileOutputStream out = new FileOutputStream(blat);
            FileUtils.copyStreams(gin, out);
            out.flush();
            out.close();
            in.close();
        }
        catch (FileNotFoundException e1) {
            FmEngApplicationLog.getApplicationLog().logException(e1);
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
    }

    public boolean loadModelFile(GZIPOutputStream gzipStream, String sModelPath) throws IOException {
        FileInputStream fileModelData = new FileInputStream(sModelPath);
        int nBytesFileInputSize = fileModelData.available();
        int nBytesChunkSize = nBytesFileInputSize < 1000000 ? nBytesFileInputSize : 1000000;
        int nBytesRead = 0;
        do {
            byte[] bytesRead = new byte[nBytesChunkSize];
            if (nBytesRead <= 0) continue;
            gzipStream.write(bytesRead, 0, nBytesRead);
        } while (nBytesRead >= 0);
        gzipStream.close();
        fileModelData.close();
        return true;
    }
}

