/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.util.StringHelper;
import java.util.HashSet;
import java.util.Set;

public class PhysicalSqlName {
    public static final String DOUBLE_QUOTES = "\"\"";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String DEFAULT_COLUMN_PREFIX = "C_";
    public static final String UNDERSCORE = "_";

    public static String makePhysicalSqlName(String orig) {
        String origNew = PhysicalSqlName.removeDoubleQuotes(orig);
        if ("".equals(origNew)) {
            return origNew;
        }
        if (!SQLKeywords.isKeyword(origNew = PhysicalSqlName.makeValidSqlIdentifier(origNew))) {
            return origNew;
        }
        String returnValue = DOUBLE_QUOTE;
        returnValue = String.valueOf(returnValue) + StringHelper.replaceAll(origNew, DOUBLE_QUOTE, DOUBLE_QUOTES);
        returnValue = String.valueOf(returnValue) + DOUBLE_QUOTE;
        return returnValue;
    }

    private static final String removeDoubleQuotes(String orig) {
        if (orig.length() <= 1) {
            return orig;
        }
        String retval = orig;
        char startChar = orig.charAt(0);
        char endChar = orig.charAt(retval.length() - 1);
        if (startChar == '\"' && endChar == '\"') {
            retval = retval.substring(1, retval.length() - 1);
        }
        retval = StringHelper.replaceAll(retval, DOUBLE_QUOTES, DOUBLE_QUOTE);
        return retval;
    }

    private static final String makeValidSqlIdentifier(String name) {
        name = PhysicalSqlName.replaceNonAlphaNumericWithUnderScore(name);
        StringBuffer sbName = new StringBuffer(name);
        if (!Character.isLetter(name.codePointAt(0))) {
            sbName.insert(0, DEFAULT_COLUMN_PREFIX);
        }
        if (SQLKeywords.isKeyword(sbName.toString())) {
            sbName.append("0");
        }
        return sbName.toString();
    }

    private static String replaceNonAlphaNumericWithUnderScore(String theString) {
        StringBuffer sBuffer = new StringBuffer(theString.length());
        int underScoreCodePoint = UNDERSCORE.codePointAt(0);
        int i = 0;
        while (i < theString.length()) {
            int codePoint = theString.codePointAt(i);
            if (Character.isLetterOrDigit(codePoint) || underScoreCodePoint == codePoint) {
                sBuffer.append(theString.charAt(i));
            } else {
                sBuffer.append(UNDERSCORE);
            }
            ++i;
        }
        return sBuffer.toString();
    }

    private static final class SQLKeywords {
        private static final String[] RESERVED_KEYWORDS = new String[]{"ABSOLUTE", "ACTION", "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALIAS", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "BEFORE", "BEGIN", "BINARY", "BIT", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHECK", "CLASS", "CLOB", "CLOSE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "COMPLETION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTINUE", "CORRESPONDING", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DESTROY", "DESTRUCTOR", "DETERMINISTIC", "DICTIONARY", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELSE", "END", "END-EXEC", "EQUALS", "ESCAPE", "EVERY", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FREE", "FULL", "FUNCTION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HAVING", "HOST", "HOUR", "IDENTITY", "IGNORE", "IMMEDIATE", "IN", "INDICATOR", "INITIALIZE", "INITIALLY", "INNER", "INOUT", "INPUT", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "KEY", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "MAP", "MATCH", "MINUTE", "MODIFIES", "MODIFY", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NONE", "NOT", "NULL", "NUMERIC", "OBJECT", "OF", "OFF", "OLD", "ON", "ONLY", "OPEN", "OPERATION", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "PAD", "PARAMETER", "PARAMETERS", "PARTIAL", "PATH", "POSTFIX", "PRECISION", "PREFIX", "PREORDER", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "RELATIVE", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "SAVEPOINT", "SCHEMA", "SCROLL", "SCOPE", "SEARCH", "SECOND", "SECTION", "SELECT", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETS", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STATE", "STATEMENT", "STATIC", "STRUCTURE", "SYSTEM_USER", "TABLE", "TEMPORARY", "TERMINATE", "THAN", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATION", "TREAT", "TRIGGER", "TRUE", "UNDER", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"};
        private static final String[] KEYWORDS = new String[]{"as", "at", "by", "in", "is", "ln", "no", "of", "on", "or", "to", "abs", "all", "and", "any", "asc", "avg", "day", "dec", "end", "exp", "for", "int", "max", "min", "mod", "not", "out", "row", "set", "sum", "top", "both", "call", "case", "cast", "ceil", "char", "cube", "date", "desc", "else", "from", "full", "hour", "into", "join", "last", "left", "like", "null", "over", "perc", "rank", "ravg", "real", "rmax", "rmin", "rsum", "rows", "sets", "some", "sqrt", "then", "time", "trim", "true", "user", "when", "with", "xavg", "xmax", "xmin", "xsum", "year", "zone", "count", "cross", "dbkey", "false", "first", "float", "floor", "group", "inner", "local", "lower", "month", "nchar", "ntile", "nulls", "order", "outer", "power", "range", "rdiff", "right", "table", "union", "upper", "using", "where", "xlast", "xperc", "xrank", "_local", "bigint", "cursor", "create", "delete", "double", "escape", "except", "exists", "filter", "having", "insert", "minute", "nullif", "others", "rcount", "rollup", "scroll", "second", "select", "stddev", "update", "values", "window", "within", "xcount", "xfirst", "xratio", "xntile", "_cursor", "_rowset", "between", "boolean", "ceiling", "current", "decimal", "declare", "extract", "integer", "leading", "natural", "numeric", "qualify", "tertile", "unknown", "varchar", "varying", "var_pop", "without", "xstddev", "coalesce", "distinct", "filename", "grouping", "interval", "national", "nvarchar", "position", "smallint", "snapshot", "trailing", "variance", "var_samp", "xtertile", "character", "cume_dist", "intersect", "following", "localtime", "partition", "precision", "preceding", "prefilter", "recursive", "returning", "substring", "timestamp", "updatable", "unbounded", "xvariance", "bit_length", "dense_rank", "last_value", "percentile", "row_number", "stddev_pop", "xmovingavg", "xmovingsum", "char_length", "first_value", "stddev_samp", "xstddev_pop", "current_date", "current_time", "octet_length", "percent_rank", "timezone_hour", "xvariance_pop", "localtimestamp", "percentile_cont", "percentile_disc", "ratio_to_report", "timezone_minute", "character_length", "current_timestamp"};
        private static SQLKeywords instance = new SQLKeywords();
        private Set<String> keywordSet = new HashSet<String>();
        private Set<String> reservedKeywordSet = null;

        private SQLKeywords() {
            String keyword;
            String[] stringArray = KEYWORDS;
            int n = KEYWORDS.length;
            int n2 = 0;
            while (n2 < n) {
                keyword = stringArray[n2];
                this.keywordSet.add(keyword.toLowerCase());
                ++n2;
            }
            this.reservedKeywordSet = new HashSet<String>();
            stringArray = RESERVED_KEYWORDS;
            n = RESERVED_KEYWORDS.length;
            n2 = 0;
            while (n2 < n) {
                keyword = stringArray[n2];
                this.reservedKeywordSet.add(keyword.toLowerCase());
                ++n2;
            }
        }

        public static boolean isKeyword(String str) {
            String lowerStr = str.toLowerCase();
            if (SQLKeywords.isReservedKeyword(lowerStr)) {
                return true;
            }
            return SQLKeywords.instance.keywordSet.contains(lowerStr);
        }

        public static boolean isReservedKeyword(String str) {
            String lowerStr = str.toLowerCase();
            return SQLKeywords.instance.reservedKeywordSet.contains(lowerStr);
        }
    }
}

