/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDeterminant;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmScopeRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityView;
import com.ibm.cognos.fmeng.fmmd.impl.model.ImpactListener;
import com.ibm.cognos.fmeng.fmmd.util.ObjectHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewRemoveListener
implements ImpactListener {
    private List<FmMessage> m_errorMessages;
    private Map<FmBaseObject, List<FmMessage>> m_impactedObjects;
    private Set<FmBaseObject> m_deletedObjects;
    private FMMDSession m_session;

    public PreviewRemoveListener(FMMDSession session) {
        this.m_session = session;
        this.m_errorMessages = new ArrayList<FmMessage>();
        this.m_impactedObjects = new HashMap<FmBaseObject, List<FmMessage>>();
        this.m_deletedObjects = new HashSet<FmBaseObject>();
    }

    public List<FmMessage> getErrorMessages() {
        return this.m_errorMessages;
    }

    public Set<FmBaseObject> getDeletedObjects() {
        return this.m_deletedObjects;
    }

    public Map<FmBaseObject, List<FmMessage>> getImpactedObjects() {
        return this.m_impactedObjects;
    }

    @Override
    public void deleteDeterminant(FmBaseObject obj, FmDeterminant det) {
        Object[] args = new Object[]{det.getLocalizedTypeName(), det.getName()};
        FmMessage message = new FmMessage("BMT_MD_VERIFY_DELETE_IMPACTED_OBJECTS_DELETE", args);
        this.addImpactWarning(obj, message);
    }

    @Override
    public void impactedObjectForDeletion(FmBaseObject object) {
        this.addImpactWarning(object, this.buildVerifyObjectMessage(object, (short)2));
    }

    @Override
    public void invalidateObject(FmBaseObject object) {
        this.addImpactWarning(object, this.buildVerifyObjectMessage(object, (short)0));
    }

    @Override
    public void invalidateScopeLevelReference(FmScopeRelationship fmScopeRelationship) {
        String impactMessageID = "BMT_MD_VERIFY_DELETE_IMPACTED_SCOPE_INFO";
        this.addImpactWarning(fmScopeRelationship, this.buildMessage(impactMessageID, fmScopeRelationship));
    }

    @Override
    public void explicitDeletion(FmBaseObject obj) {
        this.m_deletedObjects.add(obj);
    }

    private void addImpactWarning(FmBaseObject object, FmMessage message) {
        List<FmMessage> impactMsgs = this.m_impactedObjects.get(object);
        if (impactMsgs == null) {
            impactMsgs = new ArrayList<FmMessage>();
            this.m_impactedObjects.put(object, impactMsgs);
        }
        impactMsgs.add(message);
    }

    @Override
    public void reportError(FmMDException errorMessage) {
        this.m_errorMessages.add(errorMessage.getMessage(0));
    }

    @Override
    public void securityViewRefRemoved(FmSecurityView fmSecurityView) {
        List<FmPackage> pkg = fmSecurityView.getReferencingPackages();
        Object[] args = new Object[]{pkg.get(0).getLocalizedType(), pkg.get(0).getID()};
        FmMessage msg = new FmMessage("BMT_MD_VERIFY_DELETE_IMPACTED_OBJECTS_MAY_BECOME_EMPTY", args);
        this.addImpactWarning(pkg.get(0), msg);
    }

    private FmMessage buildVerifyObjectMessage(FmBaseObject affectedObject, short impact) {
        String impactMessageID;
        switch (impact) {
            case 2: {
                impactMessageID = "BMT_MD_VERIFY_DELETE_IMPACTED_OBJECTS_DELETE";
                break;
            }
            case 0: {
                impactMessageID = "BMT_MD_VERIFY_DELETE_IMPACTED_OBJECTS_INVALIDATED";
                break;
            }
            case 1: {
                if (affectedObject.getFmObjectType() == FmObjectType.securityView) {
                    affectedObject = ((FmSecurityView)affectedObject).getPackage();
                }
                impactMessageID = "BMT_MD_VERIFY_DELETE_IMPACTED_OBJECTS_MAY_BECOME_EMPTY";
                break;
            }
            default: {
                FmMDException.ASSERT(false, "");
                return null;
            }
        }
        return this.buildMessage(impactMessageID, affectedObject);
    }

    private FmMessage buildMessage(String impactMessageID, FmBaseObject affectedObject) {
        Object[] msgParams = new Object[]{affectedObject.getFmObjectTypeName(), affectedObject.getID()};
        FmMessage mdMessage = new FmMessage(impactMessageID, msgParams);
        return mdMessage;
    }

    public void throwIfMessagesPresent() {
        if (this.getErrorMessages().size() > 0) {
            FmMDException errors = new FmMDException();
            errors.addMessages(this.getErrorMessages());
            throw errors;
        }
        FmMDException warnings = new FmMDException();
        warnings.setSeverity(0);
        for (FmBaseObject obj : this.getDeletedObjects()) {
            if (!(obj instanceof FmParameterMap)) continue;
            Object[] params = new Object[]{obj.getLocalizedType(), ((FmParameterMap)obj).getName()};
            FmMessage msg = new FmMessage("BMT_MD_VERIFY_DELETE_IMPACT_GENERAL", params);
            warnings.addMessage(msg);
        }
        if (this.getImpactedObjects().size() > 0) {
            int indentLevel = 1;
            String renderedObjectNameList = ObjectHelper.renderObjects(this.m_session, this.getDeletedObjects(), indentLevel, false);
            Object[] msgParams = new Object[]{renderedObjectNameList};
            FmMessage warningMsg = new FmMessage("BMT_MD_VERIFY_DELETE", msgParams);
            boolean addedIntroductionWarning = false;
            Set<Map.Entry<FmBaseObject, List<FmMessage>>> entries = this.getImpactedObjects().entrySet();
            for (Map.Entry<FmBaseObject, List<FmMessage>> entry : entries) {
                if (this.getDeletedObjects().contains(entry.getKey())) continue;
                if (!addedIntroductionWarning) {
                    addedIntroductionWarning = true;
                    warnings.addMessage(warningMsg);
                }
                warnings.addMessages(entry.getValue());
            }
        }
        if (warnings.getMessageCount() > 0) {
            throw warnings;
        }
    }
}

