/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.NamedObject;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorderHelper {
    private FMMDSession m_session;

    public ReorderHelper(FMMDSession session) {
        this.m_session = session;
    }

    public ReorderResult doParentsReorder(List<FmBaseObject> reorderObjects, Boolean ascending, Boolean selectedItems, Boolean childrenOfSelected, Boolean recursive) {
        if (selectedItems.booleanValue()) {
            this.sort(reorderObjects, ascending);
        }
        if (reorderObjects.size() != 0) {
            FmBaseObject parentObject = (FmBaseObject)reorderObjects.get(0).getParent();
            for (FmBaseObject current : reorderObjects) {
                if (parentObject.equals(current.getParent())) continue;
                FmMDException exc = new FmMDException("BMT_MD_INVALID_SELECTION");
                exc.setSeverity(1);
                throw exc;
            }
            if (selectedItems.booleanValue()) {
                parentObject.reorderBefore(reorderObjects, (BaseObject)reorderObjects.get(reorderObjects.size() - 1));
            }
            if (childrenOfSelected.booleanValue()) {
                for (FmBaseObject obj : reorderObjects) {
                    this.sortChildren(obj, ascending, recursive);
                }
            }
        }
        return ReorderResult.kReorderInfoNone;
    }

    void sortChildren(BaseObject hContainer, boolean bAscending, boolean bRecursive) {
        List<BaseObject> children = hContainer.getChildObjects();
        if (bRecursive) {
            for (BaseObject child : children) {
                this.sortChildren(child, bAscending, bRecursive);
            }
        }
        this.sort(children, bAscending);
        if (children.size() > 0) {
            ((FmBaseObject)hContainer).reorderBefore(children, children.get(children.size() - 1));
        }
    }

    void sort(List<? extends BaseObject> reorderObjHandles, final boolean bAscending) {
        for (BaseObject baseObject : reorderObjHandles) {
            boolean bReadOnly = false;
            boolean bIsSegmentOrLink = false;
            boolean isLevel = baseObject instanceof FmLevel;
            if (!bReadOnly && !bIsSegmentOrLink && !isLevel) continue;
            if (isLevel) {
                FmMDException exc = new FmMDException("BMT_MD_REORDER_LEVELS_INFO");
                throw exc;
            }
            if (bReadOnly) {
                FmMDException exc = new FmMDException("BMT_MD_REORDER_READONLY_INFO");
                throw exc;
            }
            if (!bIsSegmentOrLink) continue;
            FmMDException exc = new FmMDException("BMT_MD_REORDER_READONLY_INFO");
            throw exc;
        }
        Comparator<BaseObject> comparator = new Comparator<BaseObject>(){

            @Override
            public int compare(BaseObject arg0, BaseObject arg1) {
                Collator collator = Collator.getInstance(ReorderHelper.this.m_session.getActiveLocale());
                String n1 = ((NamedObject)arg0).getName();
                String n2 = ((NamedObject)arg1).getName();
                if (bAscending) {
                    return collator.compare(n1, n2);
                }
                return collator.compare(n2, n1);
            }
        };
        Collections.sort(reorderObjHandles, comparator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReorderResult {
        kReorderInfoNone,
        kReorderInfoLevels,
        kReorderInfoReadonly,
        kReorderInfoSegmented;

    }
}

