/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmCopyManager;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipShortcut;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.util.FmObjectAncestry;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StarSchemaTransformer {
    private FMMDSession mSession = null;
    private ETransformType mType = null;
    private ETransformTarget mTarget = null;
    private ArrayList<TransformObjInfo> mTransformObjs = null;

    public StarSchemaTransformer(FMMDSession session, ETransformType eType, ETransformTarget eTarget) {
        this.mSession = session;
        this.mType = eType;
        this.mTarget = eTarget;
    }

    public void createGrouping(List<? extends QuerySubjectBase> vInputSet, String sTargetName) {
        this.validateSources(vInputSet);
        Section objTarget = this.determineTargetParent(vInputSet, sTargetName);
        this.analyzeSources(vInputSet);
        if (this.mType == ETransformType.kMove) {
            this.createGroupingThroughMove(objTarget);
            this.fixCopyRelationships(objTarget);
        } else {
            this.createGroupingThroughShortcuts(objTarget);
        }
    }

    public void getGroupingObjects(List<QuerySubjectBase> vMovedObjs, List<Shortcut> vShortcutObjs) {
        FmMDException.ASSERT(vMovedObjs != null && vShortcutObjs != null, "StarSchemaTransformer - getOutputObjects: expecting valid collections");
        for (TransformObjInfo objTransfrom : this.mTransformObjs) {
            if (objTransfrom.mShortcut == null) {
                vMovedObjs.add(objTransfrom.mSourceObject);
                continue;
            }
            vShortcutObjs.add(objTransfrom.mShortcut);
        }
        FmMDException.ASSERT(this.mTransformObjs.size() == vMovedObjs.size() + vShortcutObjs.size(), "StarSchemaTransformer - getOutputObjects: expecting an output for every input object");
    }

    private void validateSources(List<? extends QuerySubjectBase> vInputSet) {
        FmMDException.ASSERT(vInputSet.size() > 0, "StarSchemaTransformer - Requires at least one input object");
        boolean bAllDimension = false;
        boolean bAllQuerySubject = false;
        boolean bSingleFact = false;
        for (BaseObject baseObject : vInputSet) {
            FmObjectType inObjType = baseObject.getFmObjectType();
            if (inObjType == FmObjectType.querySubject) {
                if (bAllDimension) {
                    throw new FmMDException("BMT_MD_VERIFY_CREATE_STAR_SCHEMA_GROUPING_MIXED_SOURCES");
                }
                bAllQuerySubject = true;
                continue;
            }
            if (bAllQuerySubject) {
                throw new FmMDException("BMT_MD_VERIFY_CREATE_STAR_SCHEMA_GROUPING_MIXED_SOURCES");
            }
            bAllDimension = true;
            if (((FmDimension)baseObject).getDimensionStyle() != DimensionBase.DimensionStyle.measure) continue;
            if (bSingleFact) {
                throw new FmMDException("BMT_MD_VERIFY_CREATE_STAR_SCHEMA_GROUPING_SINGLE_FACT");
            }
            bSingleFact = true;
        }
    }

    private Section determineSourceParent(List<? extends QuerySubjectBase> vInputSet) {
        BaseObject sourceParent = FmObjectAncestry.getCommonAncestor(vInputSet);
        FmMDException.ASSERT(sourceParent != null, "Unable to find a valid common ancestry for the selected set of obejcts");
        FmMDException.ASSERT(sourceParent.getFmObjectType() == FmObjectType.folder || sourceParent.getFmObjectType() == FmObjectType.namespace, "Common parent for the selected objects must be either a namespace or a folder");
        return (Section)sourceParent;
    }

    private Section determineTargetParent(List<? extends QuerySubjectBase> vInputSet, String sTargetName) {
        Section targetContainer = this.determineSourceParent(vInputSet);
        if (targetContainer.isReadOnly()) {
            targetContainer = this.mSession.getProject().getRootNamespace();
        }
        if (this.mTarget == ETransformTarget.kSame) {
            return targetContainer;
        }
        FmMDException.ASSERT(sTargetName != null && sTargetName.length() > 0, "Expecting a valid name when creating a target container");
        FmMDException.ASSERT(targetContainer instanceof Section, "The container holding the target of the star transformation must be section");
        Section newTarget = null;
        if (this.mTarget == ETransformTarget.kNewNamespace) {
            newTarget = targetContainer.createNamespace(sTargetName);
        } else if (this.mTarget == ETransformTarget.kNewFolder) {
            newTarget = targetContainer.createFolder(sTargetName);
        } else {
            FmMDException.ASSERT(false, "Unexpected target type when creating a star schema grouping");
        }
        return newTarget;
    }

    private void analyzeSources(List<? extends QuerySubjectBase> vInputSet) {
        this.mTransformObjs = new ArrayList(vInputSet.size());
        for (QuerySubjectBase querySubjectBase : vInputSet) {
            TransformObjInfo objTransform = new TransformObjInfo(querySubjectBase);
            HashSet<BaseObject> vReferences = new HashSet<BaseObject>();
            querySubjectBase.getReferencingObjects(vReferences);
            for (BaseObject aRef : vReferences) {
                if (aRef.getFmObjectType() != FmObjectType.relationship && aRef.getFmObjectType() != FmObjectType.relationshipShortcut) continue;
                RelationshipBase aRefRel = (RelationshipBase)aRef;
                boolean bBothEndAreSelected = vInputSet.contains(aRefRel.getLeftEnd()) && vInputSet.contains(aRefRel.getRightEnd());
                objTransform.addRelation(aRefRel, !bBothEndAreSelected);
            }
            this.mTransformObjs.add(objTransform);
        }
    }

    private void createGroupingThroughMove(Section objTarget) {
        ArrayList<QuerySubjectBase> vObjToMove = new ArrayList<QuerySubjectBase>();
        for (TransformObjInfo objTransfrom : this.mTransformObjs) {
            if (objTransfrom.mReachesOut) {
                Shortcut newShortcut;
                objTransfrom.mShortcut = newShortcut = objTarget.createShortcut(objTransfrom.mSourceObject, BaseObject.PrefixName.kShortcutCreatePrefixAsNeeded);
                continue;
            }
            if (objTransfrom.mReachesOut || this.mTarget == ETransformTarget.kSame) continue;
            vObjToMove.add(objTransfrom.mSourceObject);
        }
        if (vObjToMove.size() > 0) {
            FmCopyManager.move(this.mSession, (BaseObject)objTarget, vObjToMove, null);
        }
    }

    private void fixCopyRelationships(Section objTarget) {
        ArrayList<RelationshipBase> vRelsToBeFixed = new ArrayList<RelationshipBase>();
        List<RelationshipBase> vAllRels = this.getAffectedRelationships();
        for (RelationshipBase aRel : vAllRels) {
            TransformObjInfo infoLeftEnd = this.getRelEndInfo(aRel.getLeftEnd());
            TransformObjInfo infoRightEnd = this.getRelEndInfo(aRel.getRightEnd());
            if (!infoLeftEnd.mReachesOut && !infoRightEnd.mReachesOut) continue;
            FmObjectType relType = aRel.getFmObjectType();
            FmMDException.ASSERT(relType == FmObjectType.relationship || relType == FmObjectType.relationshipShortcut, "StarSchemaTransformer:fixCopyRelationships --- Expecting only a relation or a shortcut to a relation");
            if (infoLeftEnd.mShortcut != null && infoRightEnd.mShortcut != null) {
                if (relType == FmObjectType.relationship) {
                    ExpressionBuilder builder = BuilderFactory.createExpressionBuilder(((FmRelationship)aRel).getExpression());
                    Relationship newRel = objTarget.createRelationship(builder, infoLeftEnd.mShortcut, infoRightEnd.mShortcut);
                    vRelsToBeFixed.add(newRel);
                    continue;
                }
                objTarget.createRelationshipShortcut(((FmRelationshipShortcut)aRel).getTarget(), infoLeftEnd.mShortcut, infoRightEnd.mShortcut);
                continue;
            }
            if (infoLeftEnd.mShortcut != null) {
                aRel.setLeftEnd(infoLeftEnd.mShortcut);
            } else if (infoRightEnd.mShortcut != null) {
                aRel.setRightEnd(infoRightEnd.mShortcut);
            }
            vRelsToBeFixed.add(aRel);
        }
        Map<QuerySubjectBase, Shortcut> mapViaShortcut = this.collectViaShortcutMapping();
        for (RelationshipBase tobeFixedRel : vRelsToBeFixed) {
            if (tobeFixedRel.getFmObjectType() == FmObjectType.relationship) {
                ((FmExpression)((FmRelationship)tobeFixedRel).getExpression()).retargetViaShortcut(mapViaShortcut);
            }
            ((FmRelationshipBase)tobeFixedRel).updateContainership();
        }
    }

    private void createGroupingThroughShortcuts(Section objTarget) {
        for (TransformObjInfo objTransfrom : this.mTransformObjs) {
            objTransfrom.mShortcut = objTarget.createShortcut(objTransfrom.mSourceObject, BaseObject.PrefixName.kShortcutCreatePrefixAsNeeded);
        }
        List<RelationshipBase> vAllRels = this.getAffectedRelationships();
        for (RelationshipBase aRel : vAllRels) {
            TransformObjInfo infoLeftEnd = this.getRelEndInfo(aRel.getLeftEnd());
            TransformObjInfo infoRightEnd = this.getRelEndInfo(aRel.getRightEnd());
            FmObjectType relType = aRel.getFmObjectType();
            FmMDException.ASSERT(relType == FmObjectType.relationship || relType == FmObjectType.relationshipShortcut, "StarSchemaTransformer:createGroupingThroughShortcuts --- Expecting only a relation or a shortcut to a relation");
            if (infoLeftEnd.mShortcut == null || infoRightEnd.mShortcut == null) continue;
            RelationshipShortcut newRSC = null;
            newRSC = relType == FmObjectType.relationship ? objTarget.createRelationshipShortcut(aRel, infoLeftEnd.mShortcut, infoRightEnd.mShortcut) : objTarget.createRelationshipShortcut(((FmRelationshipShortcut)aRel).getTarget(), infoLeftEnd.mShortcut, infoRightEnd.mShortcut);
            newRSC.setName(aRel.getName());
        }
    }

    private List<RelationshipBase> getAffectedRelationships() {
        ArrayList<RelationshipBase> outRels = new ArrayList<RelationshipBase>(this.mTransformObjs.size() - 1);
        for (TransformObjInfo objTransfrom : this.mTransformObjs) {
            for (RelationshipBase aRel : objTransfrom.mRelations) {
                if (outRels.contains(aRel)) continue;
                outRels.add(aRel);
            }
        }
        return outRels;
    }

    private TransformObjInfo getRelEndInfo(BaseObject aRelEnd) {
        for (TransformObjInfo objTransfrom : this.mTransformObjs) {
            if (!objTransfrom.mSourceObject.equals(aRelEnd)) continue;
            return objTransfrom;
        }
        FmMDException.ASSERT(false, "Expecting to find a relationship end among list of objects selected for star schena grouping");
        return null;
    }

    private Map<QuerySubjectBase, Shortcut> collectViaShortcutMapping() {
        HashMap<QuerySubjectBase, Shortcut> mapViaShortcut = new HashMap<QuerySubjectBase, Shortcut>();
        for (TransformObjInfo objTransfrom : this.mTransformObjs) {
            if (objTransfrom.mShortcut == null) continue;
            mapViaShortcut.put(objTransfrom.mSourceObject, objTransfrom.mShortcut);
        }
        return mapViaShortcut;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ETransformTarget {
        kNewFolder,
        kNewNamespace,
        kSame;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ETransformType {
        kCreateShortcut,
        kMove;

    }

    private class TransformObjInfo {
        QuerySubjectBase mSourceObject;
        boolean mReachesOut;
        ArrayList<RelationshipBase> mRelations;
        Shortcut mShortcut;

        TransformObjInfo(QuerySubjectBase objInput) {
            this.mSourceObject = objInput;
            this.mReachesOut = false;
            this.mRelations = null;
            this.mShortcut = null;
        }

        void addRelation(RelationshipBase objRel, boolean bReachesOut) {
            if (bReachesOut) {
                this.mReachesOut = true;
            } else {
                if (this.mRelations == null) {
                    this.mRelations = new ArrayList();
                }
                this.mRelations.add(objRel);
            }
        }
    }
}

