/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task;

import com.ibm.cognos.fmeng.fmmd.helpers.XExecuteCommandHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XQueryHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XValidateCommandHelper;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XAdaptor;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.NamedObject;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.util.TestOptions;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestObjectMixin {
    private static void addTestableItems(FMMDSession session, List<FmBaseObject> eSources, List<ReportObject> testableItems) {
        block11: for (FmBaseObject obj : eSources) {
            FmObjectType objType = obj.getFmObjectType();
            switch (objType) {
                case dimension: {
                    testableItems.addAll(((FmDimension)obj).getAllQueryItems());
                    testableItems.addAll(((FmDimension)obj).getAllMeasures());
                    break;
                }
                case updateSubject: {
                    if (eSources.size() <= 1) continue block11;
                    throw new FmMDException("BMT_MD_ERROR_OBJECT_UPDATESUBJECT_ALONE");
                }
                case hierarchy: {
                    testableItems.addAll(((FmHierarchy)obj).getAllQueryItems());
                    break;
                }
                case level: {
                    testableItems.addAll(((FmLevel)obj).getAllQueryItems());
                    break;
                }
                case measure: 
                case queryItem: {
                    testableItems.add((FmQueryItemBase)obj);
                    break;
                }
                case queryItemFolder: {
                    testableItems.addAll(((FmQueryItemFolder)obj).getAllQueryItems());
                    break;
                }
                case calculation: {
                    testableItems.add((FmReportObject)obj);
                    break;
                }
                case measureFolder: {
                    testableItems.addAll(((FmMeasureFolder)obj).getAllMeasures());
                    break;
                }
                case querySubject: {
                    testableItems.addAll(((FmQuerySubject)obj).getAllQueryItems());
                    break;
                }
                default: {
                    throw new FmMDException("BMT_MD_ERROR_INVALID_OBJECT_TO_TEST");
                }
            }
        }
    }

    public static int doCountRows(List<FmBaseObject> eSources, FMMDSession session) {
        int rowNo = 0;
        ArrayList<ReportObject> objects = new ArrayList<ReportObject>();
        TestObjectMixin.addTestableItems(session, eSources, objects);
        if (!objects.isEmpty()) {
            XExecuteCommandHelper hlprExecuteCmd = new XExecuteCommandHelper(session);
            hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.columnList);
            XQueryHelper pHlprFirstQuery = hlprExecuteCmd.addQuery("SingleCount");
            pHlprFirstQuery.setAutoSummary(false);
            pHlprFirstQuery.setQueryRef("CountResultQuery");
            String dataItemExpr = "[CountResultQuery].[2]";
            pHlprFirstQuery.addDataItem("Count", dataItemExpr);
            XQueryHelper pHlprSecondQuery = hlprExecuteCmd.addQuery("CountResultQuery");
            pHlprSecondQuery.setAutoSummary(true);
            pHlprSecondQuery.setQueryRef("aBmtQuerySubject");
            String nestedQItem = "count([aBmtQuerySubject].[";
            String qItemName = ((NamedObject)objects.get(0)).getName();
            nestedQItem = String.valueOf(nestedQItem) + qItemName;
            nestedQItem = String.valueOf(nestedQItem) + "])";
            pHlprSecondQuery.addDataItem("1", nestedQItem);
            pHlprSecondQuery.addDataItem("2", "count(1)");
            XQueryHelper pHlprThirdQuery = hlprExecuteCmd.addQuery("aBmtQuerySubject");
            pHlprThirdQuery.setAutoSummary(false);
            for (ReportObject obj : objects) {
                FmObjectType objType = obj.getFmObjectType();
                switch (objType) {
                    case calculation: 
                    case dimension: 
                    case hierarchy: 
                    case level: 
                    case measure: 
                    case queryItem: 
                    case queryItemFolder: 
                    case querySubject: 
                    case updateSubject: {
                        break;
                    }
                    default: {
                        throw new FmMDException("BMT_MD_ERROR_INVALID_OBJECT_TO_TEST");
                    }
                }
                String objID = obj.getID();
                String objName = obj.getName();
                pHlprThirdQuery.addDataItem(objName, objID);
            }
            int maxRow = 1;
            Element countRequest = hlprExecuteCmd.make();
            boolean bValidate = false;
            boolean bDisableAuthentication = false;
            XAdaptor myAdaptor = XAdaptor.create(session, bValidate, bDisableAuthentication);
            Element countResponse = myAdaptor.doQsApiRequest(countRequest, maxRow);
            Element resultElem = (Element)countResponse.selectSingleNode(".//*[local-name()='value']");
            if (resultElem != null) {
                String countStr = resultElem.attributeValue("v");
                rowNo = Integer.parseInt(countStr);
            }
        }
        return rowNo;
    }

    public static Element doTest(FMMDSession session, TestOptions sTestOptions, FmBaseObject testObject) {
        ArrayList<FmBaseObject> testObjects = new ArrayList<FmBaseObject>();
        testObjects.add(testObject);
        return TestObjectMixin.doTestQueryItems(session, sTestOptions, testObjects);
    }

    /*
     * WARNING - void declaration
     */
    public static Element doTestQueryItems(FMMDSession session, TestOptions sTestOptions, List<FmBaseObject> eSources) {
        ArrayList<ReportObject> testableItems = new ArrayList<ReportObject>();
        TestObjectMixin.addTestableItems(session, eSources, testableItems);
        Element outElement = null;
        if (testableItems.size() > 0) {
            void var7_12;
            boolean bValidate;
            XExecuteCommandHelper hlprExecuteCmd = new XExecuteCommandHelper(session);
            hlprExecuteCmd.setQOSSeverityLevel(XExecuteCommandHelper.convertNagLevel2SeverityLevel(sTestOptions.s_nagLevel));
            hlprExecuteCmd.addRequestHint(XExecuteCommandHelper.ERequestHint.designMode, sTestOptions.s_bDesignMode ? "true" : "false");
            hlprExecuteCmd.addRequestHint(XExecuteCommandHelper.ERequestHint.executionOptimization, sTestOptions.s_bIsBulk ? XExecuteCommandHelper.EQueryOptimization.allRows.toString() : XExecuteCommandHelper.EQueryOptimization.firstRow.toString());
            hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.nativeCommandText);
            hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.CognosCommandText);
            hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.connections);
            hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.executionPlan);
            hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.columnList);
            XQueryHelper pHlprQuery = hlprExecuteCmd.addQuery("fmQuery");
            pHlprQuery.setAutoSummary(sTestOptions.s_bAutoSum);
            if (sTestOptions.s_bIsForEvaluate) {
                pHlprQuery.addHint(XQueryHelper.EQueryHint.measureRefiner, "disabled");
            }
            for (BaseObject baseObject : testableItems) {
                FmReportObject item = (FmReportObject)baseObject;
                String qItemName = item.getName();
                String id = item.getID();
                pHlprQuery.addDataItem(qItemName, id);
            }
            Element element = hlprExecuteCmd.make();
            boolean bl = bValidate = sTestOptions.s_bIsForEvaluate || sTestOptions.s_maxRow == 0;
            if (bValidate) {
                XValidateCommandHelper hlprValidateCmd = new XValidateCommandHelper(element);
                Element element2 = hlprValidateCmd.make();
            }
            boolean bDisableAuthentication = false;
            XAdaptor myAdaptor = XAdaptor.create(session, bValidate, bDisableAuthentication);
            outElement = myAdaptor.doQsApiRequest((Element)var7_12, sTestOptions.s_maxRow);
            if (bValidate) {
                XValidateCommandHelper.checkReponse(outElement);
            }
        }
        return outElement;
    }
}

