/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task.planner;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.DataSourceConnection;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XConnectionManager;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheEntry {
    private final XConnectionManager connectionManager;
    Map<String, String> s_promptStrValueMap;
    Map<String, Node> s_promptDomValueMap;
    boolean s_bUsePromptValues;
    boolean s_bDisableAuthentication;
    Element s_domConnection = null;
    Locale s_pProductLocale;
    Locale s_pRunLocale;
    String s_lastPassport;
    List<DataSourceConnection> s_dataSourceConnections = new ArrayList<DataSourceConnection>();

    CacheEntry(XConnectionManager connectionManager, FMMDSession session) {
        this.connectionManager = connectionManager;
        this.s_pProductLocale = FmModelFactory.getInstance().getProject(session).getDefaultLocale1();
        this.s_pRunLocale = session.getActiveLocale();
        this.s_lastPassport = session.getPassport();
        this.s_bUsePromptValues = true;
        this.s_bDisableAuthentication = false;
    }

    void closeQSConnection() {
    }

    boolean isGoodFor(FMMDSession gw) {
        String strPassport = gw.getPassport();
        boolean bResult = this.s_lastPassport.equals(strPassport) && this.s_pProductLocale == FmModelFactory.getInstance().getProject(gw).getDefaultLocale1() && this.s_pRunLocale == gw.getActiveLocale();
        return bResult;
    }

    void renewConnectionSpecFor(FMMDSession gw) {
        this.closeQSConnection();
        this.s_domConnection = this.connectionManager.makeConnection(gw, this.s_bDisableAuthentication);
        this.s_pProductLocale = FmModelFactory.getInstance().getProject(gw).getDefaultLocale1();
        this.s_pRunLocale = gw.getActiveLocale();
        this.s_lastPassport = gw.getPassport();
    }

    void setDataSourceConnection(String dataSourceName, String connectionName, String signonName, boolean bSearchPath) {
        DataSourceConnection ds = null;
        for (DataSourceConnection connection : this.s_dataSourceConnections) {
            if (!connection.s_dataSourceName.equals(dataSourceName)) continue;
            ds = connection;
            break;
        }
        if (ds != null) {
            ds.s_connectionName = connectionName;
            ds.s_signonName = signonName;
            ds.s_logonUID = "";
            ds.s_logonPWD = "";
            ds.s_cubePassword = "";
            ds.s_namespaceName = "";
            ds.s_bSearchPath = bSearchPath;
        } else {
            this.s_dataSourceConnections.add(new DataSourceConnection(dataSourceName, connectionName, signonName, bSearchPath));
        }
    }

    void setDataSourceConnection(String dataSourceName, String connectionName, String logonUID, String logonPWD, String cubePassword, String namespaceName, boolean bSearchPath) {
        DataSourceConnection ds = null;
        for (DataSourceConnection connection : this.s_dataSourceConnections) {
            if (!connection.s_dataSourceName.equals(dataSourceName)) continue;
            ds = connection;
            break;
        }
        if (ds != null) {
            ds.s_connectionName = connectionName;
            ds.s_signonName = "";
            ds.s_logonUID = logonUID;
            ds.s_logonPWD = logonPWD;
            ds.s_cubePassword = cubePassword;
            ds.s_namespaceName = namespaceName;
            ds.s_bSearchPath = bSearchPath;
        } else {
            this.s_dataSourceConnections.add(new DataSourceConnection(dataSourceName, connectionName, logonUID, logonPWD, cubePassword, namespaceName, bSearchPath));
        }
    }

    List<DataSourceConnection> getDataSourceConnections() {
        return this.s_dataSourceConnections;
    }

    void setDisableAuthentication(boolean bDisableAuthentication) {
        this.s_bDisableAuthentication = bDisableAuthentication;
    }

    void clearDataSourceCache() {
        this.s_dataSourceConnections.clear();
    }
}

