/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task.planner;

import com.ibm.cognos.fmeng.fmmd.helpers.XCancelQueryHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XExecuteCommandHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XQueryHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XValidateCommandHelper;
import com.ibm.cognos.fmeng.fmmd.impl.model.EObjectSourceType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.DataSourceConnection;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XConnectionManager;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySetOperation;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.util.ObjectHelper;
import com.ibm.cognos.fmeng.fmmd.util.ObjectReferenceHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAdaptor {
    protected static final String fmmd_resources_value_str = "value";
    public static final int DEFAULT_PRECISION = 2;
    FMMDSession m_session;
    boolean m_bDisableAuthenticationFlag;
    static boolean m_bValidateOnly;
    FMMDSession m_sourceSession;
    boolean m_btempCube = false;

    public static XAdaptor create(FMMDSession session, boolean bValidateOnly, boolean bDisableAuth) {
        return new XAdaptor(session, bValidateOnly, bDisableAuth, false);
    }

    public static XAdaptor create(FMMDSession session, boolean bValidateOnly, boolean bDisableAuth, boolean tempCube) {
        return new XAdaptor(session, bValidateOnly, bDisableAuth, tempCube);
    }

    protected XAdaptor(FMMDSession session, boolean bValidateOnly, boolean bDisableAuth, boolean tempCube) {
        this.m_session = session;
        m_bValidateOnly = bValidateOnly;
        this.m_bDisableAuthenticationFlag = bDisableAuth;
        this.m_btempCube = tempCube;
    }

    public Element doQsApiRequest(Element domRequest, int iMaxRowRetrieval) {
        return this.doQsApiRequestImpl(domRequest, iMaxRowRetrieval);
    }

    public Element expressionQuery(int bAutoSummary, String expression, int maxNumRows, int nagLevel) {
        XExecuteCommandHelper hlprExecuteCmd = new XExecuteCommandHelper(this.m_session);
        hlprExecuteCmd.addRequestHint(XExecuteCommandHelper.ERequestHint.designMode, "false");
        XQueryHelper pHlprQuery = hlprExecuteCmd.addQuery("fmQuery");
        pHlprQuery.setAutoSummary(bAutoSummary != 0);
        pHlprQuery.addDataItem("expr", expression);
        Element domRequest = hlprExecuteCmd.make();
        return this.doQsApiRequest(domRequest, maxNumRows);
    }

    public Element planModelSet(String setName, FmBaseObject leftEnd, FmBaseObject rightEnd, QuerySetOperation.ESetOperation queryOperation, QuerySetOperation.EDuplicates duplicates) {
        ArrayList<String> vLeftItemExprs = new ArrayList<String>();
        ArrayList<String> vLeftItemAliases = new ArrayList<String>();
        this.constructDataItems(leftEnd, vLeftItemExprs, vLeftItemAliases);
        ArrayList<String> vRightItemExprs = new ArrayList<String>();
        ArrayList<String> vRightItemAliases = new ArrayList<String>();
        this.constructDataItems(rightEnd, vRightItemExprs, vRightItemAliases);
        XExecuteCommandHelper hlprExecuteCmd = new XExecuteCommandHelper(this.m_session);
        boolean bDesignMode = false;
        hlprExecuteCmd.addRequestHint(XExecuteCommandHelper.ERequestHint.designMode, bDesignMode ? "true" : "false");
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.nativeCommandText);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.CognosCommandText);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.columnList);
        XQueryHelper pHlprModelSetQuery = hlprExecuteCmd.addModelSetQuery("querySet", vLeftItemAliases, queryOperation.toString(), duplicates.toString());
        pHlprModelSetQuery.setAutoSummary(false);
        int i = 0;
        while (i < vLeftItemAliases.size()) {
            String sExpr = "[set].[" + (String)vLeftItemAliases.get(i) + "]";
            pHlprModelSetQuery.addDataItem((String)vLeftItemAliases.get(i), sExpr);
            ++i;
        }
        XQueryHelper pHlprLeftQuery = hlprExecuteCmd.addQuery("leftQuery");
        pHlprLeftQuery.setAutoSummary(false);
        int j = 0;
        while (j < vLeftItemAliases.size()) {
            pHlprLeftQuery.addDataItem((String)vLeftItemAliases.get(j), (String)vLeftItemExprs.get(j));
            ++j;
        }
        XQueryHelper pHlprRightQuery = hlprExecuteCmd.addQuery("rightQuery");
        pHlprRightQuery.setAutoSummary(false);
        int k = 0;
        while (k < vRightItemAliases.size()) {
            pHlprRightQuery.addDataItem((String)vRightItemAliases.get(k), (String)vRightItemExprs.get(k));
            ++k;
        }
        Element domRequest = hlprExecuteCmd.make();
        XValidateCommandHelper hlprValidateCmd = new XValidateCommandHelper(domRequest);
        domRequest = hlprValidateCmd.make();
        Element responseElement = this.doQsApiRequest(domRequest, 0);
        XValidateCommandHelper.checkReponse(responseElement);
        return responseElement;
    }

    public void cancelQuery() {
        XCancelQueryHelper cancelQueryHelper = new XCancelQueryHelper();
        Element domRequest = cancelQueryHelper.make();
        this.doQsApiRequest(domRequest, 0);
    }

    private Element doQsApiRequestImpl(Element domRequest, int iMaxRowRetrieval) {
        XConnectionManager QEConnectMgr = XConnectionManager.getInstance();
        QEConnectMgr.addConnectionFor(this.getSession(EGatewayUse.kCacheLookup), domRequest);
        this.addDataSourceConnections(domRequest);
        this.addPromptValues(domRequest);
        Element elmResponse = this.executeRequest(domRequest, iMaxRowRetrieval);
        return elmResponse;
    }

    private void addPromptValues(Element domRequest) {
    }

    private Element executeRequest(Element elmRequest, int maxRowRetrieval) {
        Element response = null;
        response = this.m_btempCube ? XConnectionManager.getInstance().doRequestFor(this.getSession(EGatewayUse.kCacheLookup), elmRequest, maxRowRetrieval, m_bValidateOnly, this.m_btempCube) : XConnectionManager.getInstance().doRequestFor(this.getSession(EGatewayUse.kCacheLookup), elmRequest, maxRowRetrieval, m_bValidateOnly);
        return response;
    }

    private FMMDSession getSession(EGatewayUse eGatewayUse) {
        if (eGatewayUse == EGatewayUse.kCacheLookup && this.m_sourceSession != null) {
            return this.m_sourceSession;
        }
        return this.m_session;
    }

    /*
     * WARNING - void declaration
     */
    private void addDataSourceConnections(Element domRequest) {
        Element testConn = (Element)domRequest.selectSingleNode(".//*[local-name()='testConnection']");
        if (testConn != null) {
            Element elmConnString = (Element)domRequest.selectSingleNode(".//*[local-name()='connectionString']");
            Element elmConnection = elmConnString.getParent();
            Element elmDataSource = (Element)elmConnection.selectSingleNode(".//dataSource");
            if (elmDataSource != null) {
                String sSAPTicket;
                String dataSourceName = elmDataSource.attributeValue(fmmd_resources_value_str);
                String string = "";
                String password = "";
                DataSourceConnection conn = XConnectionManager.getInstance().getSelection(this.m_session, dataSourceName);
                if (conn != null) {
                    String string2 = conn.s_logonUID;
                    password = conn.s_logonPWD;
                }
                if ((sSAPTicket = null) == null) {
                    void var7_13;
                    if (!"".equals(var7_13)) {
                        "".equals(password);
                    }
                    this.updateOrCreate(elmConnection, "username", fmmd_resources_value_str, (String)var7_13);
                    this.updateOrCreate(elmConnection, "password", fmmd_resources_value_str, password);
                } else {
                    String sSAPServer = null;
                    String sSAPClientNo = null;
                    String sSAPCodePage = null;
                    String sSAPServerType = null;
                    String sSAPSystemNo = null;
                    this.updateOrCreate(elmConnection, "dataSourceType", fmmd_resources_value_str, "SAPBWODP");
                    this.updateOrCreate(elmConnection, "server", fmmd_resources_value_str, sSAPServer);
                    this.updateOrCreate(elmConnection, "SAPClientNumber", fmmd_resources_value_str, sSAPClientNo);
                    this.updateOrCreate(elmConnection, "SAPCodePage", fmmd_resources_value_str, sSAPCodePage);
                    this.updateOrCreate(elmConnection, "SAPServerType", fmmd_resources_value_str, sSAPServerType);
                    this.updateOrCreate(elmConnection, "SAPSystemNumber", fmmd_resources_value_str, sSAPSystemNo);
                    this.updateOrCreate(elmConnection, "SSOTicket", fmmd_resources_value_str, sSAPTicket);
                }
            }
        } else {
            FmMDException.ASSERT("command".equals(domRequest.getName()), null);
            List<Object> dsConnections = new ArrayList();
            dsConnections = XConnectionManager.getInstance().getDataSourceConnectionsFor(this.getSession(EGatewayUse.kCacheLookup));
            if (dsConnections.isEmpty()) {
                return;
            }
            Element elmConn = (Element)domRequest.selectSingleNode(".//*[local-name()='connection']");
            if (elmConn == null) {
                elmConn = domRequest.addElement("connection");
            }
            Element elmSubConn = elmConn.addElement("connection");
            Element elmDSType = elmSubConn.addElement("dataSourceType");
            elmDSType.setText("QueryEngine");
            for (DataSourceConnection dataSourceConnection : dsConnections) {
                Element elmDsConnection = elmSubConn.addElement("connection");
                Element ds = elmDsConnection.addElement("dataSource");
                ds.addAttribute(fmmd_resources_value_str, dataSourceConnection.s_dataSourceName);
                Element dsType = elmDsConnection.addElement("dataSourceType");
                dsType.addAttribute(fmmd_resources_value_str, "Database");
                Element name = elmDsConnection.addElement("name");
                name.addAttribute(fmmd_resources_value_str, dataSourceConnection.s_connectionName);
                if (!"".equals(dataSourceConnection.s_logonUID)) {
                    Element userName = elmDsConnection.addElement("username");
                    userName.addAttribute(fmmd_resources_value_str, dataSourceConnection.s_logonUID);
                }
                if (!"".equals(dataSourceConnection.s_logonPWD)) {
                    Element password = elmDsConnection.addElement("password");
                    password.addAttribute(fmmd_resources_value_str, dataSourceConnection.s_logonPWD);
                }
                if ("".equals(dataSourceConnection.s_signonName)) continue;
                Element elmSignon = elmDsConnection.addElement("signon");
                Element signonName = elmSignon.addElement("name");
                signonName.addAttribute(fmmd_resources_value_str, dataSourceConnection.s_signonName);
            }
        }
    }

    private void constructDataItems(FmBaseObject querySubject, List<String> vDataItemExprs, List<String> vDataItemAliases) {
        boolean bIsShortcut = false;
        if (querySubject instanceof FmShortcut) {
            FmShortcut objShortcut = (FmShortcut)querySubject;
            querySubject = (FmQuerySubject)objShortcut.getRefobj();
            bIsShortcut = true;
        }
        List<QueryItem> vQueryItemIDs = ((FmQuerySubject)querySubject).getAllQueryItems();
        int idx = 0;
        while (idx < vQueryItemIDs.size()) {
            String queryItemID = ((FmQueryItem)vQueryItemIDs.get(idx)).getID();
            if (bIsShortcut) {
                vDataItemExprs.add(ObjectReferenceHelper.makeShortcutReference(querySubject.getID(), queryItemID));
            } else {
                vDataItemExprs.add(queryItemID);
            }
            String sName = ((FmQueryItem)vQueryItemIDs.get(idx)).getName();
            vDataItemAliases.add(sName);
            ++idx;
        }
        FmMDException.ASSERT(vDataItemAliases.size() == vDataItemExprs.size(), null);
    }

    private Element updateOrCreate(Element parent, String elemName, String attribute, String value) {
        Element elm = (Element)parent.selectSingleNode(".//*[local-name()='" + elemName + "']");
        if (elm == null) {
            elm = parent.addElement(elemName);
        }
        elm.addAttribute(attribute, value);
        return elm;
    }

    public void planRelationship(FmRelationship rel) {
        String leftCard = rel.getLeftMincard() == Cardinality.ECardinality.one ? "1:" : "0:";
        leftCard = String.valueOf(leftCard) + (rel.getLeftMaxcard() == Cardinality.ECardinality.one ? "1" : "N");
        String rightCard = rel.getRightMincard() == Cardinality.ECardinality.one ? "1:" : "0:";
        rightCard = String.valueOf(rightCard) + (rel.getRightMaxcard() == Cardinality.ECardinality.one ? "1" : "N");
        int autoSummary = 1;
        int maxRowNo = 0;
        this.planAssociation(rel.getName(), ((FmBaseObject)((Object)rel.getLeftEnd())).getID(), leftCard, ((FmBaseObject)((Object)rel.getRightEnd())).getID(), rightCard, BuilderFactory.createExpressionBuilder(rel.getExpression()), autoSummary, maxRowNo);
    }

    public Element planAssociation(String relName, String leftEnd, String leftCard, String rightEnd, String rightCard, ExpressionBuilder joinExprBuilder, int autoSummary, int maxRowNo) {
        RelationshipEnd hLeftEnd = (RelationshipEnd)FmModelFactory.getInstance().getById(this.m_session, leftEnd);
        FmMDException.ASSERT(hLeftEnd != null, null);
        RelationshipEnd hRightEnd = (RelationshipEnd)FmModelFactory.getInstance().getById(this.m_session, rightEnd);
        FmMDException.ASSERT(hRightEnd != null, null);
        if (hLeftEnd.determineSourceType() == EObjectSourceType.kMultidimensional || hRightEnd.determineSourceType() == EObjectSourceType.kMultidimensional) {
            ArrayList<FmBaseObject> vhObjects = new ArrayList<FmBaseObject>();
            vhObjects.add((FmBaseObject)((Object)hLeftEnd));
            vhObjects.add((FmBaseObject)((Object)hRightEnd));
            Object[] msgParams = new Object[]{ObjectHelper.renderObjects(this.m_session, vhObjects, 0, false), "multidimension"};
            throw new FmMDException(0, "BMT_MD_UNSUPPORTED_OPERATION_TYPE", msgParams);
        }
        String joinExpr = ((FmExpressionBuilder)joinExprBuilder).toV5ExpressionString(this.m_session);
        ArrayList<String> vLeftItemExprs = new ArrayList<String>();
        ArrayList<String> vLeftItemAliases = new ArrayList<String>();
        this.constructDataItems((FmBaseObject)((Object)hLeftEnd), vLeftItemExprs, vLeftItemAliases);
        ArrayList<String> vRightItemExprs = new ArrayList<String>();
        ArrayList<String> vRightItemAliases = new ArrayList<String>();
        this.constructDataItems((FmBaseObject)((Object)hRightEnd), vRightItemExprs, vRightItemAliases);
        XExecuteCommandHelper hlprExecuteCmd = new XExecuteCommandHelper(this.m_session);
        boolean bDesignMode = false;
        hlprExecuteCmd.addRequestHint(XExecuteCommandHelper.ERequestHint.designMode, bDesignMode ? "true" : "false");
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.nativeCommandText);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.CognosCommandText);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.columnList);
        XQueryHelper pHlprJoinedQuery = hlprExecuteCmd.addJoinQuery(relName, leftEnd, leftCard, rightEnd, rightCard, joinExpr);
        pHlprJoinedQuery.setAutoSummary(autoSummary > 0);
        int j = 0;
        while (j < vLeftItemExprs.size()) {
            pHlprJoinedQuery.addDataItem((String)vLeftItemAliases.get(j), (String)vLeftItemExprs.get(j));
            ++j;
        }
        int k = 0;
        while (k < vRightItemExprs.size()) {
            pHlprJoinedQuery.addDataItem((String)vRightItemAliases.get(k), (String)vRightItemExprs.get(k));
            ++k;
        }
        Element domRequest = hlprExecuteCmd.make();
        if (m_bValidateOnly) {
            XValidateCommandHelper hlprValidateCmd = new XValidateCommandHelper(domRequest);
            domRequest = hlprValidateCmd.make();
        }
        Element responseElement = this.doQsApiRequest(domRequest, maxRowNo);
        if (m_bValidateOnly) {
            XValidateCommandHelper.checkReponse(responseElement);
        }
        return responseElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EGatewayUse {
        kObjectLookup,
        kCacheLookup;

    }
}

