/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task.planner;

import com.ibm.cognos.fmeng.fmmd.helpers.XCommandHelper;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.CacheEntry;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.DataSourceConnection;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XConnectiontHelper;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.v5Server.V5DataserverConnectionManager;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.util.FmCredentials;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XConnectionManager {
    private static XConnectionManager connectionManagerSingleton = new V5DataserverConnectionManager();
    private Map<String, CacheEntry> m_cachedEntries = new HashMap<String, CacheEntry>();

    public static XConnectionManager getInstance() {
        return connectionManagerSingleton;
    }

    protected XConnectionManager() {
    }

    public abstract Element doRequestFor(FMMDSession var1, Element var2, int var3, boolean var4);

    public abstract Element doRequestFor(FMMDSession var1, Element var2, int var3, boolean var4, boolean var5);

    public abstract String getModelPath(FMMDSession var1);

    public abstract FmDatatype convertTypeToFMType(String var1, long var2);

    public DataSourceConnection getSelection(FMMDSession session, String cmDataSourceName) {
        List<DataSourceConnection> dataSourceConnections = this.getDataSourceConnectionsFor(session);
        if (dataSourceConnections != null) {
            for (DataSourceConnection ds : dataSourceConnections) {
                if (!ds.s_dataSourceName.equals(cmDataSourceName)) continue;
                return ds;
            }
        }
        return null;
    }

    public void clearDataSourceCache(FMMDSession session) {
        String sessionID = session.getSessionId();
        CacheEntry entry = this.m_cachedEntries.get(sessionID);
        if (entry != null) {
            entry.clearDataSourceCache();
        }
    }

    public void setDataSourceConnectionFor(FMMDSession session, String dataSourceName, String connectionName, String signonName, ENamesOrSearchPaths eNameOrSearchPath) {
        String sessionID = session.getSessionId();
        CacheEntry pCacheEntry = this.m_cachedEntries.get(sessionID);
        if (pCacheEntry == null) {
            this.addEntry(session);
        }
        boolean bSearchPath = eNameOrSearchPath == ENamesOrSearchPaths.eSearchPaths;
        this.m_cachedEntries.get(sessionID).setDataSourceConnection(dataSourceName, connectionName, signonName, bSearchPath);
    }

    List<DataSourceConnection> getDataSourceConnectionsFor(FMMDSession session) {
        List<DataSourceConnection> dataSourceConnections = null;
        String sessionID = session.getSessionId();
        CacheEntry mapItr = this.m_cachedEntries.get(sessionID);
        if (mapItr != null) {
            dataSourceConnections = mapItr.getDataSourceConnections();
        }
        return dataSourceConnections;
    }

    void setPromptValueFor(FMMDSession session, String promptName, String promptValue) {
    }

    void setPromptValueFor(FMMDSession session, String promptName, Node promptValue) {
    }

    void resetPromptValuesFor(FMMDSession session) {
    }

    void setUsePromptValuesFlagFor(FMMDSession session, int notUseCachedValues) {
    }

    void getPromptValuesFor(FMMDSession session, List<String> promptNames, List<String> promptValues) {
    }

    void getPromptValuesFor(FMMDSession session, Node domParameters, boolean bIncludeAllElements) {
    }

    boolean getUsePromptValuesFlagFor(FMMDSession session) {
        return false;
    }

    boolean getAllRuntimeParamaters(FMMDSession gw, int allOrOverride) {
        return false;
    }

    void setDisableAuthenticationFor(FMMDSession gw, boolean bDisableAuthentication) {
    }

    void registerPAC(FMMDSession gw) {
    }

    void addConnectionFor(FMMDSession session, Element domRequest) {
        CacheEntry pCacheEntry = null;
        String sessionID = session.getSessionId();
        CacheEntry mapItr = this.m_cachedEntries.get(sessionID);
        if (mapItr == null) {
            pCacheEntry = this.addEntry(session);
            pCacheEntry.s_domConnection = this.makeConnection(session, false);
        } else {
            pCacheEntry = mapItr;
            if (pCacheEntry.s_domConnection == null) {
                pCacheEntry.s_domConnection = this.makeConnection(session, false);
            } else if (!pCacheEntry.isGoodFor(session)) {
                pCacheEntry.renewConnectionSpecFor(session);
            }
        }
        Element elmServiceID_MFWA4J = null;
        Element elmConnection = (Element)domRequest.selectSingleNode(".//connection");
        if (elmConnection != null) {
            elmServiceID_MFWA4J = (Element)elmConnection.selectSingleNode(".//serviceID[@value='MFWA4J']");
        }
        if (elmServiceID_MFWA4J == null) {
            XCommandHelper.addConnection(domRequest, pCacheEntry.s_domConnection);
        }
    }

    void closeConnectionFor(FMMDSession session) {
        String sessionID = session.getSessionId();
        CacheEntry pCacheEntry = this.m_cachedEntries.get(sessionID);
        if (pCacheEntry != null) {
            pCacheEntry.closeQSConnection();
        }
    }

    void setDataSourceConnectionFor(FMMDSession session, String dataSourceName, String connectionName, String logonUID, String logonPWD, String cubePassword, String namespaceName, ENamesOrSearchPaths eNameOrSearchPath) {
        String sessionID = session.getSessionId();
        CacheEntry pCacheEntry = this.m_cachedEntries.get(sessionID);
        if (pCacheEntry == null) {
            this.addEntry(session);
        }
        boolean bSearchPath = eNameOrSearchPath == ENamesOrSearchPaths.eSearchPaths;
        this.m_cachedEntries.get(sessionID).setDataSourceConnection(dataSourceName, connectionName, logonUID, logonPWD, cubePassword, namespaceName, bSearchPath);
    }

    CacheEntry addEntry(FMMDSession session) {
        String sessionID = session.getSessionId();
        CacheEntry pNewEntry = new CacheEntry(this, session);
        this.m_cachedEntries.put(sessionID, pNewEntry);
        return pNewEntry;
    }

    Element makeConnection(FMMDSession session, boolean bDisableAuthentication) {
        Element domConnect = null;
        XConnectiontHelper xConnectHelper = new XConnectiontHelper(session);
        this.initConnectionHelper(xConnectHelper, session, bDisableAuthentication);
        Document document = DocumentHelper.createDocument();
        domConnect = xConnectHelper.doMake(document);
        return domConnect;
    }

    protected void initConnectionHelper(XConnectiontHelper xConnectHelper, FMMDSession session, boolean bDisableAuthentication) {
        FmCredentials credentials = new FmCredentials(session);
        boolean bUseCM = true;
        String ASTicket = null;
        if ("".equals(ASTicket)) {
            xConnectHelper.addProperty("ASTicket", ASTicket);
        }
        if (bDisableAuthentication) {
            xConnectHelper.setDisableAuthentication(bDisableAuthentication);
        } else if (!bUseCM) {
            xConnectHelper.setNamespace(credentials.getNamespace());
            xConnectHelper.setUserName(credentials.getUserId());
            xConnectHelper.setPassword(credentials.getUserId());
        } else {
            xConnectHelper.setPassport(credentials.getPassportID());
        }
        xConnectHelper.setProductLocale(FmModelFactory.getInstance().getProject(session).getDefaultLocale1());
        xConnectHelper.setRunLocale(session.getActiveLocale());
        xConnectHelper.addConnectionItem("sessionId", session.getSessionId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ENamesOrSearchPaths {
        eNames,
        eSearchPaths;

    }
}

