/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task.planner;

import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class XConnectiontHelper {
    protected static final String fmmd_actionhelper_resources_connection_str = "connection";
    protected static final String fmmd_actionhelper_resources_value_str = "value";
    private List<Pair<String>> m_connectionItems = new ArrayList<Pair<String>>();
    private List<Pair<String>> m_models = new ArrayList<Pair<String>>();
    protected Map<String, String> m_definedProperties = new HashMap<String, String>();
    private Map<String, String> m_genericProperties = new HashMap<String, String>();
    private String m_dataSourceType = "QueryFrameworkService";
    private FMMDSession m_session;
    private String m_modelType = "";
    private String m_providerType;

    static String getFMServiceID() {
        return "FM";
    }

    static String makeSessionID(int bmtSessionId) {
        return Integer.valueOf(bmtSessionId).toString();
    }

    public XConnectiontHelper(FMMDSession session) {
        this.m_session = session;
        this.m_definedProperties.put("serviceID", XConnectiontHelper.getFMServiceID());
    }

    public void setProviderType(String providerType) {
        this.m_dataSourceType = providerType;
    }

    public void addProperty(String propName, String propValue) {
        this.m_definedProperties.put(propName, propValue);
    }

    public void setNamespace(String nsName) {
        this.m_definedProperties.put("namespace", nsName);
    }

    public void setUserName(String userName) {
        this.m_definedProperties.put("username", userName);
    }

    public void setPassword(String pwd) {
        this.m_definedProperties.put("password", pwd);
    }

    public void setPassport(String passport) {
        this.m_definedProperties.put("CAMPassport", passport);
    }

    public void setContentManagerURI(String contentManagerURI) {
        this.m_definedProperties.put("contentManagerURI", contentManagerURI);
    }

    public void setRetainConnection(boolean retainConnectionFlag) {
        this.m_genericProperties.put("RETAINCONNECTION", retainConnectionFlag ? "TRUE" : "FALSE");
    }

    public void setDisableAuthentication(boolean disableAuthenticationFlag) {
        this.m_genericProperties.put("disableAuthentication", disableAuthenticationFlag ? "TRUE" : "FALSE");
    }

    public void setProductLocale(Locale productLocale) {
        this.m_definedProperties.put("productLocale", productLocale.getLanguage());
    }

    public void setRunLocale(Locale runLocale) {
        this.m_definedProperties.put("runLocale", runLocale.getLanguage());
    }

    public void setSessionID(int bmtSessionId) {
        this.m_definedProperties.put("sessionID", XConnectiontHelper.makeSessionID(bmtSessionId));
    }

    void setModelPath(String modelPath) {
        this.m_definedProperties.put("dataSource", modelPath);
    }

    void setModelType(String modelType) {
        this.m_modelType = modelType;
    }

    public void addConnectionItem(String name, String value) {
        this.m_connectionItems.add(new Pair<String>(name, value));
    }

    public void setQFProviderType(String providerType) {
        this.m_providerType = providerType;
    }

    public Element doMake(Document domDoc) {
        Element anElement;
        Element domRequest = domDoc.addElement(fmmd_actionhelper_resources_connection_str);
        if (this.m_providerType != null) {
            anElement = domRequest.addElement("QFProviderType");
            anElement.addAttribute(fmmd_actionhelper_resources_value_str, this.m_providerType);
        }
        anElement = domRequest.addElement("dataSourceType");
        anElement.addAttribute(fmmd_actionhelper_resources_value_str, this.m_dataSourceType);
        for (Map.Entry<String, String> e : this.m_definedProperties.entrySet()) {
            if ("".equals(e.getValue())) continue;
            anElement = domRequest.addElement(e.getKey());
            anElement.addAttribute(fmmd_actionhelper_resources_value_str, e.getValue());
        }
        Element elmConnection = domRequest.addElement(fmmd_actionhelper_resources_connection_str);
        Element elmModelConnection = elmConnection.addElement("connectionProperties");
        if (this.m_modelType.length() != 0) {
            Element element = elmModelConnection.addElement("modelType");
            element.addAttribute(fmmd_actionhelper_resources_value_str, this.m_modelType);
        }
        for (Pair<String> pair : this.m_connectionItems) {
            Element property = elmModelConnection.addElement("property");
            property.addAttribute("name", (String)pair.first);
            property.addAttribute(fmmd_actionhelper_resources_value_str, (String)pair.second);
        }
        for (Map.Entry entry : this.m_genericProperties.entrySet()) {
            anElement = domRequest.addElement("property");
            anElement.addAttribute("name", (String)entry.getKey());
            anElement.addAttribute(fmmd_actionhelper_resources_value_str, (String)entry.getValue());
        }
        return domRequest;
    }

    static void refreshRequest(Element elmRequest, String passportID, Locale pProductLocale, Locale pRunLocale) {
        Element elmTemp;
        if (passportID != "") {
            elmTemp = (Element)elmRequest.selectSingleNode("//*[local-name()='CAMPassport']");
            if (elmTemp == null) {
                elmTemp = elmRequest.addElement("CAMPassport");
            }
            elmTemp.addAttribute(fmmd_actionhelper_resources_value_str, passportID);
        }
        if (pProductLocale != null) {
            elmTemp = (Element)elmRequest.selectSingleNode("//*[local-name()='productLocale']");
            elmTemp.addAttribute(fmmd_actionhelper_resources_value_str, pProductLocale.getLanguage());
        }
        if (pRunLocale != null) {
            elmTemp = (Element)elmRequest.selectSingleNode("//*[local-name()='runLocale']");
            elmTemp.addAttribute(fmmd_actionhelper_resources_value_str, pRunLocale.getLanguage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Pair<String> {
        String first;
        String second;

        Pair(String s1, String s2) {
            this.first = s1;
            this.second = s2;
        }
    }
}

