/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task.planner.v5Server;

import com.ibm.cognos.fmeng.fmmd.impl.task.ModelPublisher;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XConnectionManager;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XConnectiontHelper;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.soap.ContentManagerServiceRequest;
import com.ibm.cognos.fmeng.utility.soap.MetadataServiceRequest;
import java.util.Locale;
import org.dom4j.Element;

public class V5DataserverConnectionManager
extends XConnectionManager {
    public Element doRequestFor(FMMDSession session, Element elmRequest, int maxRowRetrieval, boolean validateOnly) {
        Element modelPath = (Element)elmRequest.selectSingleNode(".//modelPath");
        if (modelPath == null) {
            modelPath = (Element)elmRequest.selectSingleNode(".//model");
        }
        boolean deletePackage = false;
        if (modelPath != null) {
            String pth = modelPath.getText();
            int idx = pth.lastIndexOf("@name=\"");
            String modelName = pth.substring(idx + 7);
            int quotIdx = modelName.lastIndexOf("\"");
            modelName = modelName.substring(0, quotIdx);
            String modelCMPath = this.uploadModelToDataServer(session, modelName);
            modelPath.setText(modelCMPath);
            deletePackage = true;
        }
        Element res = this.executeRequestToDataServer(session, elmRequest, maxRowRetrieval, false);
        if (deletePackage) {
            String pkgPath = modelPath.getText().substring(0, modelPath.getText().lastIndexOf("/model"));
            ContentManagerServiceRequest cmRequest = new ContentManagerServiceRequest(session.getActiveLocale(), session.getPassport());
            cmRequest.deletePackage(pkgPath);
        }
        return res;
    }

    public Element doRequestFor(FMMDSession session, Element elmRequest, int maxRowRetrieval, boolean validateOnly, boolean btempCube) {
        return this.executeRequestToDataServer(session, elmRequest, maxRowRetrieval, false);
    }

    public FmDatatype convertTypeToFMType(String type, long length) {
        return V5DataserverConnectionManager.FromQECLDatatype(type, length);
    }

    public String getModelPath(FMMDSession session) {
        String packageName = Long.toString(System.nanoTime());
        return "~~/package[@name=\"" + packageName + "\"]/model";
    }

    private Element executeRequestToDataServer(FMMDSession session, Element elmRequest, int maxRowRetrieval, boolean validateOnly) {
        Locale locale = session.getActiveLocale();
        String dispatcherGuid = CmHelper.get(session, session.getPassport()).getDispatcherGuid();
        MetadataServiceRequest request = new MetadataServiceRequest(session.getPassport(), locale.toString(), dispatcherGuid);
        return request.sendQueryServicesRequest(elmRequest.asXML(), new MetadataServiceRequest.RequestOptions(maxRowRetrieval, validateOnly){
            {
                this.mMaxRows = n;
                this.mValidateOnly = bl;
                this.mUseBmeGateway = false;
            }
        }, session);
    }

    private String uploadModelToDataServer(FMMDSession session, String packageName) {
        ModelPublisher publisher = new ModelPublisher(session);
        return publisher.publishModelToCM("~~", packageName, "model", null);
    }

    private String uploadModelToDataServer(FMMDSession session, String[] path) {
        ModelPublisher publisher = new ModelPublisher(session);
        return publisher.publishModelToCM(path[0], path[1], path[2], null);
    }

    protected void initConnectionHelper(XConnectiontHelper xConnectHelper, FMMDSession session, boolean bDisableAuthentication) {
        xConnectHelper.setQFProviderType("CoordinationPlanner");
        xConnectHelper.addProperty("serviceID", "MFWA4J");
        super.initConnectionHelper(xConnectHelper, session, bDisableAuthentication);
    }

    private static FmDatatype FromQECLDatatype(String name, long length) {
        FmDatatype type = null;
        if ("sqlChar".equals(name)) {
            type = FmDatatype.CHARACTER;
        } else if ("sqlVarChar".equals(name)) {
            type = FmDatatype.CHARACTERLENGTH16;
        } else if ("sqlLongVarChar".equals(name)) {
            type = FmDatatype.CHARACTERLENGTH32;
        } else if ("sqlSmallInt".equals(name)) {
            type = FmDatatype.INT16;
        } else if ("sqlInteger".equals(name)) {
            long tmpSize = Math.abs(length);
            type = length == 0L ? FmDatatype.INT16 : (tmpSize <= 127L ? FmDatatype.INT16 : (tmpSize <= 32767L ? FmDatatype.INT16 : (tmpSize <= Integer.MAX_VALUE ? FmDatatype.INT32 : FmDatatype.INT64)));
        } else if ("sqlQuad".equals(name)) {
            type = FmDatatype.INT64;
        } else if ("sqlDecimal".equals(name)) {
            type = FmDatatype.DECIMAL;
        } else if ("sqlFloat".equals(name)) {
            type = FmDatatype.FLOAT32;
        } else if ("sqlDouble".equals(name)) {
            type = FmDatatype.FLOAT64;
        } else if ("sqlDate".equals(name)) {
            type = FmDatatype.DATE;
        } else if ("sqlTime".equals(name)) {
            type = FmDatatype.TIME;
        } else if ("sqlDateTime".equals(name)) {
            type = FmDatatype.DATETIME;
        } else if ("sqlInterval".equals(name)) {
            type = FmDatatype.TIMEINTERVAL;
        } else if ("sqlDbKey".equals(name)) {
            type = FmDatatype.DATABASEKEY;
        } else if ("sqlBlob".equals(name)) {
            type = FmDatatype.BLOB;
        } else if ("sqlText".equals(name)) {
            type = FmDatatype.TEXTBLOB;
        } else if ("sqlBinary".equals(name)) {
            type = FmDatatype.BINARY;
        } else if ("sqlVarBinary".equals(name)) {
            type = FmDatatype.BINARYLENGTH16;
        } else if ("sqlBoolean".equals(name)) {
            type = FmDatatype.BOOLEAN;
        } else if ("sqlTimeTZ".equals(name)) {
            type = FmDatatype.TIMETZ;
        } else if ("sqlTimestampTZ".equals(name)) {
            type = FmDatatype.TIMESTAMPTZ;
        } else if ("sqlIntervalYM".equals(name)) {
            type = FmDatatype.INTERVALYM;
        } else if ("sqlNChar".equals(name)) {
            type = FmDatatype.NCHAR;
        } else if ("sqlNVarChar".equals(name)) {
            type = FmDatatype.NVARCHAR;
        } else if ("sqlNumeric".equals(name)) {
            type = FmDatatype.NUMERIC;
        } else if ("sqlTimestamp2".equals(name)) {
            type = FmDatatype.DATETIME;
        } else if ("sqlDate2".equals(name)) {
            type = FmDatatype.DATE;
        } else if ("sqlTime2".equals(name)) {
            type = FmDatatype.TIME;
        } else if ("sqlInterval2".equals(name)) {
            type = FmDatatype.TIMEINTERVAL;
        } else if ("sqlUnknownType".equals(name)) {
            type = FmDatatype.UNKNOWN;
        }
        return type;
    }
}

