/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task.refine;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.task.refine.PathTraversal;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.QueryChild;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.fmmd.util.SearchFilter;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelRefiner {
    private FMMDSession m_session;
    private Set<BaseObject> m_refinedModel;
    private Set<FmRelationshipBase> m_allRelationships;

    public ModelRefiner(FMMDSession session) {
        this.m_session = session;
        this.m_refinedModel = new HashSet<BaseObject>();
        this.m_allRelationships = this.getAllRelationships();
    }

    public Set<BaseObject> refine(FmQuerySubjectBase querySubject) {
        this.refineImpl(querySubject);
        return this.m_refinedModel;
    }

    public Set<BaseObject> refine(FmQueryItemBase queryItem) {
        this.refineImpl(queryItem);
        return this.m_refinedModel;
    }

    public Set<BaseObject> refine(FmHierarchy hierarchy) {
        this.refineImpl(hierarchy);
        return this.m_refinedModel;
    }

    public Set<BaseObject> refine(FmLevel level) {
        this.refineImpl(level);
        return this.m_refinedModel;
    }

    private void refineImpl(FmReportObject object) {
        HashSet<ReportObject> suppliers = new HashSet<ReportObject>();
        this.gatherSuppliersFromReferences(object, suppliers);
        PathTraversal traversal = new PathTraversal(suppliers, this.m_allRelationships);
        Set<FmRelationshipBase> rels = traversal.getAllRelationshipsLeadingToGoal();
        this.m_refinedModel.add(object);
        this.m_refinedModel.addAll(suppliers);
        this.m_refinedModel.addAll(rels);
        suppliers.clear();
        for (FmRelationshipBase rel : rels) {
            Set<BaseObject> objectsRefdByRel = rel.getReferencedObjects();
            Iterator<BaseObject> iterator = objectsRefdByRel.iterator();
            while (iterator.hasNext()) {
                BaseObject refdByRel;
                BaseObject bo = refdByRel = iterator.next();
                if (refdByRel instanceof QueryChild) {
                    QueryChild qc = (QueryChild)refdByRel;
                    bo = qc.getQueryParent();
                }
                if (this.m_refinedModel.contains(bo)) continue;
                this.refineImpl((FmReportObject)bo);
            }
        }
    }

    private void gatherSuppliers(ReportObject object, Set<ReportObject> suppliers) {
        if (suppliers.contains(object)) {
            return;
        }
        suppliers.add(object);
        this.gatherSuppliersFromReferences(object, suppliers);
    }

    private void gatherSuppliersFromReferences(ReportObject object, Set<ReportObject> suppliers) {
        Set<BaseObject> refdObjects = object.getReferencedObjects();
        for (BaseObject refdObj : refdObjects) {
            if (!(refdObj instanceof FmReportObject)) continue;
            if (refdObj instanceof QueryChild) {
                refdObj = ((QueryChild)refdObj).getQueryParent();
            }
            this.gatherSuppliers((FmReportObject)refdObj, suppliers);
        }
        List<BaseObject> children = object.getChildObjects();
        for (BaseObject child : children) {
            if (!(child instanceof FmReportObject)) continue;
            this.gatherSuppliersFromReferences((FmReportObject)child, suppliers);
        }
    }

    private Set<FmRelationshipBase> getAllRelationships() {
        HashSet<Integer> recurseInto = new HashSet<Integer>(2);
        recurseInto.add(88);
        recurseInto.add(148);
        HashSet<Integer> lookingFor = new HashSet<Integer>(2);
        lookingFor.add(134);
        lookingFor.add(135);
        lookingFor.add(146);
        final HashSet<FmRelationshipBase> allRelationships = new HashSet<FmRelationshipBase>();
        SearchFilter filter = new SearchFilter(){

            public boolean foundElement(Object obj) {
                allRelationships.add((FmRelationshipBase)FmModelFactory.getInstance().get(ModelRefiner.this.m_session, obj));
                return false;
            }
        };
        EmfHelper.traverse(this.m_session.getProject().getInternal(), recurseInto, lookingFor, filter, false);
        return allRelationships;
    }
}

