/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.task.refine;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathTraversal {
    private Map<RelationshipEnd, Set<FmRelationshipBase>> m_objectRelationshipMap;
    private Set<FmRelationshipBase> m_allRelations;
    private Set<ReportObject> m_goal;
    private Context m_context;

    public PathTraversal(Set<ReportObject> goal, Set<FmRelationshipBase> allRelationships) {
        this.m_allRelations = allRelationships;
        this.m_goal = goal;
        this.m_context = new Context();
        this.m_objectRelationshipMap = new HashMap<RelationshipEnd, Set<FmRelationshipBase>>();
        this.buildRelMap();
        this.pullInObjectOnRelationshipPaths();
    }

    public Set<FmRelationshipBase> getAllRelationshipsLeadingToGoal() {
        return this.m_context.getRelationshipsLeadingToGoal();
    }

    private void buildRelMap() {
        for (FmRelationshipBase rel : this.m_allRelations) {
            RelationshipEnd le = rel.getLeftEnd();
            RelationshipEnd re = rel.getRightEnd();
            this.addToRelMap(le, rel);
            this.addToRelMap(re, rel);
        }
    }

    private void addToRelMap(RelationshipEnd relEnd, FmRelationshipBase rel) {
        Set<FmRelationshipBase> rels = this.m_objectRelationshipMap.get(relEnd);
        if (rels == null) {
            rels = new HashSet<FmRelationshipBase>();
            this.m_objectRelationshipMap.put(relEnd, rels);
        }
        rels.add(rel);
    }

    private void pullInObjectOnRelationshipPaths() {
        for (FmRelationshipBase rel : this.m_allRelations) {
            RelationshipEnd le = rel.getLeftEnd();
            RelationshipEnd re = rel.getRightEnd();
            boolean leInGoal = this.m_goal.contains(le);
            boolean reInGoal = this.m_goal.contains(re);
            if (leInGoal && reInGoal) {
                this.m_context.addRelationshipLeadingToGoal(rel);
                continue;
            }
            if (leInGoal) {
                this.m_goal.remove(le);
                if (this.findAllNodesOnPathToGoal(re, this.m_context)) {
                    this.m_context.addRelationshipLeadingToGoal(rel);
                }
                this.m_goal.add((FmReportObject)((Object)le));
                continue;
            }
            if (!reInGoal) continue;
            this.m_goal.remove(re);
            if (this.findAllNodesOnPathToGoal(le, this.m_context)) {
                this.m_context.addRelationshipLeadingToGoal(rel);
            }
            this.m_goal.add((FmReportObject)((Object)re));
        }
    }

    boolean findAllNodesOnPathToGoal(RelationshipEnd end, Context context) {
        if (this.m_goal.contains(end)) {
            context.markLeadsToGoal(end, true);
            return true;
        }
        Boolean leadsToGoal = context.isLeadsToGoal(end);
        if (leadsToGoal == Boolean.TRUE) {
            context.markLeadsToGoal(end, true);
            return true;
        }
        if (leadsToGoal == null) {
            Set<FmRelationshipBase> rels = this.getRelationships(end);
            boolean relationshipLeadToGoal = false;
            for (FmRelationshipBase rel : rels) {
                if (context.hasVisited(rel)) continue;
                context.startTraversal(rel);
                RelationshipEnd opposite = rel.getLeftEnd().equals(end) ? rel.getRightEnd() : rel.getLeftEnd();
                boolean res = this.findAllNodesOnPathToGoal(opposite, context);
                if (res) {
                    context.addRelationshipLeadingToGoal(rel);
                    relationshipLeadToGoal = true;
                }
                context.endTraversal(rel);
            }
            context.markLeadsToGoal(end, relationshipLeadToGoal);
            return relationshipLeadToGoal;
        }
        return false;
    }

    private Set<FmRelationshipBase> getRelationships(RelationshipEnd end) {
        return this.m_objectRelationshipMap.get(end);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context {
        private HashMap<RelationshipEnd, Boolean> m_leadsToGoal = new HashMap();
        private Set<FmRelationshipBase> m_traversing = new HashSet<FmRelationshipBase>();
        private HashSet<FmRelationshipBase> m_relsLeadingToGoal = new HashSet();

        Context() {
        }

        public void addRelationshipLeadingToGoal(FmRelationshipBase rel) {
            this.m_relsLeadingToGoal.add(rel);
        }

        Set<FmRelationshipBase> getRelationshipsLeadingToGoal() {
            return this.m_relsLeadingToGoal;
        }

        public Boolean isLeadsToGoal(RelationshipEnd end) {
            return this.m_leadsToGoal.get(end);
        }

        public void markLeadsToGoal(RelationshipEnd end, boolean relationshipLeadToGoal) {
            this.m_leadsToGoal.put(end, relationshipLeadToGoal ? Boolean.TRUE : Boolean.FALSE);
        }

        public void endTraversal(FmRelationshipBase rel) {
            this.m_traversing.remove(rel);
        }

        public void startTraversal(FmRelationshipBase rel) {
            this.m_traversing.add(rel);
        }

        public boolean hasVisited(FmRelationshipBase rel) {
            return this.m_traversing.contains(rel);
        }
    }
}

