/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.model;

import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FmDatatype {
    UNKNOWN("unknown"),
    UNSUPPORTED("unsupported"),
    INT16("int16"),
    INT32("int32"),
    INT64("int64"),
    DECIMAL("decimal"),
    NUMERIC("numeric"),
    FLOAT("float"),
    FLOAT32("float32"),
    FLOAT64("float64"),
    BINARY("binary"),
    BINARYLENGTH16("binaryLength16"),
    DATE("date"),
    TIME("time"),
    DATETIME("dateTime"),
    TIMEINTERVAL("timeInterval"),
    CHARACTER("character"),
    CHARACTERLENGTH16("characterLength16"),
    CHARACTERLENGTH32("characterLength32"),
    BLOB("blob"),
    TEXTBLOB("textBlob"),
    BLOBARRAY("blobArray"),
    DATABASEKEY("databaseKey"),
    VARBIT("varBit"),
    BIT("bit"),
    BOOLEAN("boolean"),
    TIMETZ("timeTZ"),
    TIMESTAMPTZ("timeStampTZ"),
    INTERVALYM("intervalYM"),
    NCHAR("nChar"),
    NVARCHAR("nVarChar");

    private String mLiteral;

    private FmDatatype(String literal) {
        this.mLiteral = literal;
    }

    public static FmDatatype getValueOf(String literal) {
        try {
            return FmDatatype.valueOf(literal.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }

    public static Boolean isNumeric(FmDatatype aType) {
        switch (aType) {
            case INT16: 
            case INT32: 
            case INT64: 
            case DECIMAL: 
            case NUMERIC: 
            case FLOAT: 
            case FLOAT32: 
            case FLOAT64: {
                return true;
            }
        }
        return false;
    }

    public static Boolean isDecimal(FmDatatype aType) {
        switch (aType) {
            case DECIMAL: 
            case FLOAT: 
            case FLOAT32: 
            case FLOAT64: {
                return true;
            }
        }
        return false;
    }

    public static Boolean isFloat(FmDatatype aType) {
        switch (aType) {
            case FLOAT: 
            case FLOAT32: 
            case FLOAT64: {
                return true;
            }
        }
        return false;
    }

    public static Boolean isInteger(FmDatatype aType) {
        switch (aType) {
            case INT16: 
            case INT32: 
            case INT64: {
                return true;
            }
        }
        return false;
    }

    public static Boolean isString(FmDatatype aType) {
        switch (aType) {
            case CHARACTER: 
            case CHARACTERLENGTH16: 
            case CHARACTERLENGTH32: 
            case TEXTBLOB: 
            case NCHAR: 
            case NVARCHAR: {
                return true;
            }
        }
        return false;
    }

    public static Boolean isTime(FmDatatype type) {
        switch (type) {
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMEINTERVAL: 
            case TIMETZ: 
            case TIMESTAMPTZ: 
            case INTERVALYM: {
                return true;
            }
        }
        return false;
    }

    public static Boolean isUnsupportedByROLAP(FmDatatype type) {
        switch (type) {
            case UNKNOWN: 
            case UNSUPPORTED: 
            case BINARY: 
            case BINARYLENGTH16: 
            case BLOB: 
            case TEXTBLOB: 
            case BLOBARRAY: 
            case DATABASEKEY: 
            case VARBIT: 
            case BIT: {
                return true;
            }
        }
        return false;
    }

    public static Boolean isBlobType(FmDatatype type) {
        switch (type) {
            case BINARY: 
            case BINARYLENGTH16: 
            case BLOB: 
            case TEXTBLOB: 
            case BLOBARRAY: 
            case DATABASEKEY: 
            case VARBIT: 
            case BIT: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.mLiteral;
    }

    public String internalValue() {
        return this.name();
    }
}

