/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.cognos.developer.schemas.bibus._3.AccessEnum;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AnyTypeMIMEProp;
import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMessages;
import com.cognos.developer.schemas.bibus._3.AsynchDetailROLAPDataSourceState;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchSecondaryRequest;
import com.cognos.developer.schemas.bibus._3.AutomaticAggregateOptimizationEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseROLAPCubeConfiguration;
import com.cognos.developer.schemas.bibus._3.BaseROLAPCubeConfigurationArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.DataSourceConnection;
import com.cognos.developer.schemas.bibus._3.DataSourceSignon;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.Dispatcher_Type;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.FaultDetail;
import com.cognos.developer.schemas.bibus._3.IntProp;
import com.cognos.developer.schemas.bibus._3.Model;
import com.cognos.developer.schemas.bibus._3.ModelView;
import com.cognos.developer.schemas.bibus._3.MultilingualString;
import com.cognos.developer.schemas.bibus._3.MultilingualStringProp;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.PackageConfiguration;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.Permission;
import com.cognos.developer.schemas.bibus._3.Policy;
import com.cognos.developer.schemas.bibus._3.PolicyArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.QueryService_PortType;
import com.cognos.developer.schemas.bibus._3.QueryService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.QueryService_Type;
import com.cognos.developer.schemas.bibus._3.RetentionRule;
import com.cognos.developer.schemas.bibus._3.RetentionRuleArrayProp;
import com.cognos.developer.schemas.bibus._3.RolapCubeConfiguration;
import com.cognos.developer.schemas.bibus._3.RolapDataSource;
import com.cognos.developer.schemas.bibus._3.RolapVirtualCubeConfiguration;
import com.cognos.developer.schemas.bibus._3.RolapVirtualDataSource;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UiComponentEnum;
import com.cognos.developer.schemas.bibus._3.UiComponentEnumArrayProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.mfw4j.utilities.QFException;
import com.ibm.cognos.fmeng.fmmd.helpers.DomHelper;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityObject;
import com.ibm.cognos.fmeng.fmmd.model.AccessView;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.LocalizedValue;
import com.ibm.cognos.fmeng.fmmd.model.VirtualCube;
import com.ibm.cognos.fmeng.fmmd.util.CmPolicyHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import com.ibm.cognos.fmeng.utility.StringDecryptionHelper;
import com.ibm.cognos.fmeng.utility.soap.ContentManagerServiceRequest;
import com.ibm.cognos.fmeng.utility.soap.FmEngSoapRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.rpc.ServiceException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.OctetStream;
import org.apache.axis.attachments.OctetStreamDataSource;
import org.apache.axis.client.Stub;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmHelper {
    private static final short KOBJ_TYPE_SECURITY = 0;
    private static final short KOBJ_TYPE_NORMAL = 1;
    private static String KSTR_UNKNOWN = "unknown";
    private static String KSTR_STARTING = "starting";
    private FMMDSession m_session;
    private ContentManagerService_ServiceLocator m_cmServiceLocator = null;
    private ContentManagerService_PortType m_cmService = null;
    private String m_passport = "";
    private String m_dispatcherEndPoint = "";
    private String m_dispatcherGUID = null;

    public static CmHelper get(FMMDSession session, String passport) {
        CmHelper cmHelper = new CmHelper(session);
        cmHelper.initialize(passport);
        return cmHelper;
    }

    private CmHelper(FMMDSession session) {
        this.m_session = session;
    }

    private void initialize(String passport) {
        this.m_passport = passport;
        this.connect(FmPreferences.getInstance().getDispatcherEndPoint());
    }

    private void connect(String dispatchURL) {
        try {
            this.m_cmServiceLocator = new ContentManagerService_ServiceLocator();
            this.m_cmServiceLocator.getEngine().setOption("sendMultiRefs", (Object)Boolean.FALSE);
            this.m_dispatcherEndPoint = dispatchURL;
            this.m_cmService = this.m_cmServiceLocator.getcontentManagerService(new URL(this.m_dispatcherEndPoint));
            BiBusHeader header = new BiBusHeader();
            CAM cam = new CAM();
            CAMPassport campassport = new CAMPassport();
            campassport.setId(this.m_passport);
            cam.setCAMPassport(campassport);
            header.setCAM(cam);
            ((Stub)this.m_cmService).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue.getMessage(), mue);
        }
    }

    public BaseClass findPackage(String cmPath, List<String> packageNames, List<String> actualNames) {
        ContentManagerServiceRequest cmRequest = new ContentManagerServiceRequest(this.m_cmService);
        return cmRequest.findPackage(cmPath, packageNames, actualNames, null, null);
    }

    public BaseClass findRolapDataSource(String cmParentPath, List<String> cubeNames) {
        ContentManagerServiceRequest cmRequest = new ContentManagerServiceRequest(this.m_cmService);
        return cmRequest.findRolapDataSource(cmParentPath, cubeNames);
    }

    private void addPackageLocaleProperties(FmPackage packageToPublish, _package cmPackage) {
        List<String> locales = packageToPublish.getPackageLocales();
        ArrayList<MultilingualToken> nameList = new ArrayList<MultilingualToken>();
        int i = 0;
        while (i < locales.size()) {
            String localeVal = locales.get(i);
            String value = packageToPublish.getName(localeVal);
            if (value != null && value.length() > 0) {
                MultilingualToken t = new MultilingualToken();
                t.setLocale(localeVal);
                t.setValue(packageToPublish.getName(localeVal));
                nameList.add(t);
            }
            ++i;
        }
        if (nameList.size() > 0) {
            MultilingualToken[] nameTokens = nameList.toArray(new MultilingualToken[nameList.size()]);
            MultilingualTokenProp nameProp = new MultilingualTokenProp();
            cmPackage.setName(nameProp);
            nameProp.setValue(nameTokens);
        }
        ArrayList<MultilingualString> screentipList = new ArrayList<MultilingualString>();
        int i2 = 0;
        while (i2 < locales.size()) {
            String localeVal = locales.get(i2);
            String value = packageToPublish.getScreenTip(localeVal);
            if (value != null && value.length() > 0) {
                MultilingualString ms = new MultilingualString();
                ms.setLocale(localeVal);
                ms.setValue(value);
                screentipList.add(ms);
            }
            ++i2;
        }
        if (screentipList.size() > 0) {
            MultilingualString[] screenTipStrings = screentipList.toArray(new MultilingualString[screentipList.size()]);
            MultilingualStringProp screenTipProp = new MultilingualStringProp();
            screenTipProp.setValue(screenTipStrings);
            cmPackage.setScreenTip(screenTipProp);
        }
        ArrayList<MultilingualString> descriptionList = new ArrayList<MultilingualString>();
        int i3 = 0;
        while (i3 < locales.size()) {
            String localeVal = locales.get(i3);
            String value = packageToPublish.getDescription(localeVal);
            if (value != null && value.length() > 0) {
                MultilingualString ms = new MultilingualString();
                ms.setLocale(localeVal);
                ms.setValue(value);
                descriptionList.add(ms);
            }
            ++i3;
        }
        if (descriptionList.size() > 0) {
            MultilingualString[] descriptionStrings = descriptionList.toArray(new MultilingualString[descriptionList.size()]);
            MultilingualStringProp descriptionProp = new MultilingualStringProp();
            descriptionProp.setValue(descriptionStrings);
            cmPackage.setDescription(descriptionProp);
        }
    }

    private void setUIInterfaces(_package cmPackage, FmPackage packageToPublish) {
        HashSet<UiComponentEnum> uicomps = new HashSet<UiComponentEnum>();
        if (FmPreferences.getInstance().getFMPreferenceAsBool("ModelImportOptions", "Allow_SAPR3")) {
            uicomps.add(UiComponentEnum.applicationStudio);
        } else {
            if (packageToPublish.referencesSAPR3()) {
                FmMDException e = new FmMDException("BMT_MD_PUBLISH_R3");
                throw e;
            }
            uicomps.add(UiComponentEnum.eventStudio);
            uicomps.add(UiComponentEnum.queryStudio);
            uicomps.add(UiComponentEnum.reportStudio);
        }
        if (packageToPublish.containsDimensions()) {
            uicomps.add(UiComponentEnum.analysisStudio);
        }
        if (packageToPublish.isPP8Compatible()) {
            uicomps.add(UiComponentEnum.powerPlayStudio);
        }
        UiComponentEnum[] enumArray = uicomps.toArray(new UiComponentEnum[uicomps.size()]);
        UiComponentEnumArrayProp uiComponentEnumProp = new UiComponentEnumArrayProp();
        uiComponentEnumProp.setValue(enumArray);
        cmPackage.setUserInterfaces(uiComponentEnumProp);
    }

    private void setPackagePolicies(String cmPath, FmPackage packageToPublish) throws RemoteException {
        List<FmSecurityObject> fmAdminSecurityObjects;
        ArrayList<String> adminObjSearchPaths = new ArrayList<String>();
        ArrayList<String> userObjSearchPaths = new ArrayList<String>();
        this.getPoliciesForCMObject(cmPath, adminObjSearchPaths, userObjSearchPaths);
        List<FmSecurityObject> fmViewSecurityObjects = packageToPublish.getSecurityView().getSecurityObjects();
        if (fmViewSecurityObjects.isEmpty()) {
            fmViewSecurityObjects = this.buildObjects(userObjSearchPaths);
        }
        if ((fmAdminSecurityObjects = packageToPublish.getAdminSecurityObjects()).isEmpty()) {
            fmAdminSecurityObjects = this.buildObjects(adminObjSearchPaths);
        }
        _package updatePolicyPackage = new _package();
        StringProp cmPathProp = new StringProp();
        cmPathProp.setValue(cmPath);
        updatePolicyPackage.setSearchPath(cmPathProp);
        if (FmPreferences.getInstance().getFMPreferenceAsBool("PublishOptions", "SetPolicyPackage")) {
            CmPolicyHelper policyHelper = new CmPolicyHelper(fmViewSecurityObjects, fmAdminSecurityObjects, "package");
            PolicyArrayProp policyArrayProp = policyHelper.buildPolicyArrayProp();
            updatePolicyPackage.setPolicies(policyArrayProp);
        }
        BaseClass[] policyBaseClass = new BaseClass[]{updatePolicyPackage};
        this.m_cmService.update(policyBaseClass, new UpdateOptions());
        if (!fmAdminSecurityObjects.isEmpty()) {
            packageToPublish.setSecurity(fmAdminSecurityObjects);
        }
    }

    private void setModelRetention(_package cmPackage, int modelRetention) {
        RetentionRule[] retentionRule = new RetentionRule[]{new RetentionRule()};
        retentionRule[0].setMaxObjects(BigInteger.valueOf(modelRetention));
        retentionRule[0].setObjectClass(ClassEnum.fromString((String)"model"));
        retentionRule[0].setProp(PropEnum.creationTime);
        RetentionRuleArrayProp retentionRuleProp = new RetentionRuleArrayProp();
        retentionRuleProp.setValue(retentionRule);
        cmPackage.setRetentions(retentionRuleProp);
    }

    public String createUpdatePackage(String cmPath, FmPackage packageToPublish, boolean bPackageExists, int modelRetention) {
        _package cmPackage = new _package();
        this.addPackageLocaleProperties(packageToPublish, cmPackage);
        this.setModelRetention(cmPackage, modelRetention);
        this.setUIInterfaces(cmPackage, packageToPublish);
        BaseClass[] objs = new BaseClass[]{cmPackage};
        try {
            if (bPackageExists) {
                StringProp cmPathProp = new StringProp();
                cmPathProp.setValue(cmPath);
                cmPackage.setSearchPath(cmPathProp);
                this.m_cmService.update(objs, new UpdateOptions());
            } else {
                SearchPathSingleObject searchObj = new SearchPathSingleObject();
                searchObj.set_value(cmPath);
                AddOptions packageAddOptions = new AddOptions();
                packageAddOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
                BaseClass[] retClasses = this.m_cmService.add(searchObj, objs, packageAddOptions);
                if (retClasses != null && retClasses.length > 0) {
                    cmPath = retClasses[0].getSearchPath().getValue();
                }
                this.setPackagePolicies(cmPath, packageToPublish);
                this.createPackageConfiguration(packageToPublish, cmPath);
            }
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        return cmPath;
    }

    public String createUpdateRolapDataSource(String cmPath, CubeBase cube, boolean bRolapCubeExits, ByteArrayOutputStream modelStream) {
        String outRolapDSPath = null;
        Object rolapDataSource = null;
        rolapDataSource = cube instanceof VirtualCube ? new RolapVirtualDataSource() : new RolapDataSource();
        List<LocalizedValue> names = cube.getNames();
        ArrayList<MultilingualToken> nameList = new ArrayList<MultilingualToken>();
        for (LocalizedValue cubeName : names) {
            MultilingualToken t = new MultilingualToken();
            t.setLocale(cubeName.getLocale());
            t.setValue(cubeName.getValue());
            nameList.add(t);
        }
        if (nameList.size() > 0) {
            MultilingualToken[] nameTokens = nameList.toArray(new MultilingualToken[nameList.size()]);
            MultilingualTokenProp nameProp = new MultilingualTokenProp();
            rolapDataSource.setName(nameProp);
            nameProp.setValue(nameTokens);
        }
        BaseClass[] objs = new BaseClass[]{rolapDataSource};
        try {
            if (bRolapCubeExits) {
                StringProp cmPathProp = new StringProp();
                cmPathProp.setValue(cmPath);
                rolapDataSource.setSearchPath(cmPathProp);
                BaseClass[] retClasses = this.m_cmService.update(objs, new UpdateOptions());
                if (retClasses != null && retClasses.length > 0) {
                    outRolapDSPath = retClasses[0].getSearchPath().getValue();
                }
            } else {
                SearchPathSingleObject searchObj = new SearchPathSingleObject();
                searchObj.set_value(cmPath);
                AddOptions packageAddOptions = new AddOptions();
                packageAddOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
                BaseClass[] retClasses = this.m_cmService.add(searchObj, objs, packageAddOptions);
                if (retClasses != null && retClasses.length > 0) {
                    outRolapDSPath = retClasses[0].getSearchPath().getValue();
                }
            }
            String rolapModelPath = this.createUpdateRolapDataSourceModel(outRolapDSPath, bRolapCubeExits, modelStream);
            Map<String, String> existingViews = this.getModelViews(rolapModelPath);
            if (cube instanceof Cube) {
                for (AccessView view : ((Cube)cube).getAccessViews()) {
                    String viewName = view.getName();
                    if (existingViews.containsKey(viewName)) {
                        existingViews.remove(viewName);
                        continue;
                    }
                    this.addModelView(rolapModelPath, viewName);
                }
            }
            for (String existingView : existingViews.keySet()) {
                this.deleteModelView(rolapModelPath, existingView);
            }
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        return outRolapDSPath;
    }

    public void associateAccountWithRolapDataSource(String searchPath, boolean isVirtual) {
        RolapVirtualDataSource bc = null;
        ContentManagerServiceRequest csr = new ContentManagerServiceRequest(this.m_cmService);
        BaseClass[] acct = csr.queryForAccount();
        BaseClassArrayProp dataSourceAccessAccount = new BaseClassArrayProp();
        dataSourceAccessAccount.setValue(acct);
        if (isVirtual) {
            RolapVirtualDataSource rvds = new RolapVirtualDataSource();
            rvds.setDataSourceAccessAccount(dataSourceAccessAccount);
            bc = rvds;
        } else {
            RolapDataSource rds = new RolapDataSource();
            rds.setDataSourceAccessAccount(dataSourceAccessAccount);
            bc = rds;
        }
        StringProp searchPathProp = new StringProp();
        searchPathProp.setValue(searchPath);
        bc.setSearchPath(searchPathProp);
        BaseClass[] objs = new BaseClass[]{bc};
        try {
            this.m_cmService.update(objs, new UpdateOptions());
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public void deleteModelView(String rolapModelPath, String viewToDelete) throws RemoteException {
        ModelView toDelete = new ModelView();
        String searchPath = String.valueOf(rolapModelPath) + "/modelView[@name=\"" + viewToDelete + "\"]";
        StringProp searchProp = new StringProp();
        searchProp.setValue(searchPath);
        toDelete.setSearchPath(searchProp);
        BaseClass[] objs = new BaseClass[]{toDelete};
        this.m_cmService.delete(objs, new DeleteOptions());
    }

    private String createUpdateRolapDataSourceModel(String rolapDataSourcePath, boolean bRolapCubeExits, ByteArrayOutputStream modelStream) {
        String modelPath = "";
        try {
            OctetStream aStream = new OctetStream(modelStream.toByteArray());
            OctetStreamDataSource ds = new OctetStreamDataSource("somename", aStream);
            DataHandler dh = new DataHandler((DataSource)ds);
            AttachmentPart attachment = new AttachmentPart(dh);
            attachment.setMimeHeader("Content-Encoding", "gzip");
            AnyTypeMIMEProp mimeProp = new AnyTypeMIMEProp();
            mimeProp.setValue("[attribute]" + attachment.getContentIdRef());
            Model model = new Model();
            model.setModel(mimeProp);
            TokenProp nameProp = new TokenProp();
            nameProp.setValue("model");
            model.setDefaultName(nameProp);
            ((Stub)this.m_cmService).addAttachment((Object)attachment);
            BaseClass[] baseClassObjects = new BaseClass[]{model};
            if (bRolapCubeExits) {
                StringProp searchPath = new StringProp();
                modelPath = String.valueOf(rolapDataSourcePath) + "/model[@name='model']";
                searchPath.setValue(modelPath);
                model.setSearchPath(searchPath);
                this.m_cmService.update(baseClassObjects, new UpdateOptions());
            } else {
                AddOptions modelAddOptions = new AddOptions();
                modelAddOptions.setDataEncoding(EncodingEnum.MIME);
                modelAddOptions.setUpdateAction(UpdateActionEnum.replace);
                modelAddOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
                BaseClass[] addedItems = null;
                addedItems = this.m_cmService.add(new SearchPathSingleObject(rolapDataSourcePath), baseClassObjects, modelAddOptions);
                FmMDException.ASSERT(addedItems.length < 2, "Published more objects than expected.");
                if (addedItems.length > 0) {
                    modelPath = addedItems[0].getSearchPath().getValue();
                }
            }
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        return modelPath;
    }

    private void createPackageConfiguration(FmPackage packageToPublish, String cmPath) throws RemoteException {
        List<FmSecurityObject> fmAdminSecurityObjects = packageToPublish.getAdminSecurityObjects();
        ArrayList<FmSecurityObject> fmViewSecurityObjects = new ArrayList<FmSecurityObject>();
        fmViewSecurityObjects.add(FmSecurityObject.createTransient(this.m_session, "CAMID(\"::Everyone\")", (short)2, ""));
        CmPolicyHelper policyHelper = new CmPolicyHelper(fmViewSecurityObjects, fmAdminSecurityObjects, "package");
        PackageConfiguration pkgConfig = new PackageConfiguration();
        PolicyArrayProp props = policyHelper.buildPolicyArrayProp();
        pkgConfig.setPolicies(props);
        AddOptions addOptions = new AddOptions();
        addOptions.setUpdateAction(UpdateActionEnum.update);
        TokenProp nameToken = new TokenProp();
        nameToken.setValue(packageToPublish.getDefaultName());
        pkgConfig.setDefaultName(nameToken);
        IntProp dcProp = new IntProp();
        dcProp.setValue(5);
        pkgConfig.setCrosstabItemDisplayCountDefault(dcProp);
        IntProp dclProp = new IntProp();
        dclProp.setValue(20);
        pkgConfig.setCrosstabItemDisplayCountLimit(dclProp);
        IntProp mdcdProp = new IntProp();
        mdcdProp.setValue(20);
        pkgConfig.setMemberDisplayCountDefault(mdcdProp);
        IntProp mdclProp = new IntProp();
        mdclProp.setValue(50);
        pkgConfig.setMemberDisplayCountLimit(mdclProp);
        SearchPathSingleObject searchObj = new SearchPathSingleObject();
        searchObj.set_value(cmPath);
        BaseClass[] addObjs = new BaseClass[]{pkgConfig};
        this.m_cmService.add(searchObj, addObjs, addOptions);
    }

    private void getPoliciesForCMObject(String cmPath, List<String> adminObjSearchPaths, List<String> userObjSearchPaths) throws RemoteException {
        PropEnum[] propArray = new PropEnum[]{PropEnum.policies};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        BaseClass[] objs = this.m_cmService.query(new SearchPathMultipleObject(cmPath), propArray, null, queryOpts);
        if (objs != null) {
            int i = 0;
            while (i < objs.length) {
                PolicyArrayProp policyArrayProp = objs[i].getPolicies();
                if (policyArrayProp != null) {
                    Policy[] policyArray = policyArrayProp.getValue();
                    int p = 0;
                    while (p < policyArray.length) {
                        Policy policy = policyArray[p];
                        if (this.hasPermission(policy, "setPolicy")) {
                            adminObjSearchPaths.add(policy.getSecurityObject().getSearchPath().getValue());
                        } else {
                            userObjSearchPaths.add(policy.getSecurityObject().getSearchPath().getValue());
                        }
                        ++p;
                    }
                }
                ++i;
            }
        }
    }

    private boolean hasPermission(Policy policy, String permission) {
        boolean hasPermission = false;
        Permission[] permissions = policy.getPermissions();
        if (permissions != null) {
            int i = 0;
            while (i < permissions.length) {
                if (permissions[i].getAccess() == AccessEnum.grant && permission.equals(permissions[i].getName())) {
                    hasPermission = true;
                    break;
                }
                ++i;
            }
        }
        return hasPermission;
    }

    public String getDispatcherGuid() {
        if (this.m_dispatcherGUID == null) {
            URL dispURL = null;
            InetAddress dispatcherInetAddress = null;
            try {
                dispURL = new URL(this.m_dispatcherEndPoint);
                dispatcherInetAddress = this.m_dispatcherEndPoint.contains("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(dispURL.getHost());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            String dispatcherHostNamePort = String.valueOf(dispatcherInetAddress.getHostName().toLowerCase()) + ":" + dispURL.getPort();
            String dispatcherCanonicalHostNamePort = String.valueOf(dispatcherInetAddress.getCanonicalHostName().toLowerCase()) + ":" + dispURL.getPort();
            String dispatcherHostAddressPort = String.valueOf(dispatcherInetAddress.getHostAddress()) + ":" + dispURL.getPort();
            try {
                BaseClass[] result;
                BaseClass[] baseClassArray = result = this.m_cmService.query(new SearchPathMultipleObject("/configuration/descendant::dispatcher"), new PropEnum[]{PropEnum.dispatcherPath, PropEnum.dispatcherID}, new Sort[0], new QueryOptions());
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Dispatcher_Type disp;
                    AnyURIProp path;
                    String currentDispatcherHostPortContext;
                    BaseClass cls = baseClassArray[n2];
                    if (cls instanceof Dispatcher_Type && (currentDispatcherHostPortContext = (path = (disp = (Dispatcher_Type)cls).getDispatcherPath()).getValue()) != null && ((currentDispatcherHostPortContext = currentDispatcherHostPortContext.toLowerCase()).contains(dispatcherHostNamePort) || currentDispatcherHostPortContext.contains(dispatcherCanonicalHostNamePort) || currentDispatcherHostPortContext.contains(dispatcherHostAddressPort))) {
                        this.m_dispatcherGUID = disp.getDispatcherID().getValue().get_value();
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (this.m_dispatcherGUID == null) {
                throw new RuntimeException("Dispatcher GUID not found.");
            }
        }
        return this.m_dispatcherGUID;
    }

    public String simplePublishModel(String cmContainerPath, String pkgName, String modelName, boolean bQueryMode, ByteArrayOutputStream stream) {
        boolean bPkgExists;
        ArrayList<String> pkgNames = new ArrayList<String>(1);
        pkgNames.add(pkgName);
        BaseClass foundPkg = this.findPackage(cmContainerPath, pkgNames, null);
        String cmPackagePath = null;
        if (foundPkg != null) {
            cmPackagePath = foundPkg.getSearchPath().getValue();
        }
        boolean bl = bPkgExists = cmPackagePath != null && cmPackagePath.length() != 0;
        if (!bPkgExists) {
            _package cmPackage = new _package();
            MultilingualToken t = new MultilingualToken();
            t.setLocale(this.m_session.getProject().getDefaultLocale());
            t.setValue(pkgName);
            MultilingualToken[] nameTokens = new MultilingualToken[]{t};
            MultilingualTokenProp nameProp = new MultilingualTokenProp();
            nameProp.setValue(nameTokens);
            cmPackage.setName(nameProp);
            BaseClass[] objs = new BaseClass[]{cmPackage};
            try {
                SearchPathSingleObject searchObj = new SearchPathSingleObject();
                searchObj.set_value(cmContainerPath);
                AddOptions packageAddOptions = new AddOptions();
                packageAddOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
                BaseClass[] retClasses = this.m_cmService.add(searchObj, objs, packageAddOptions);
                if (retClasses != null && retClasses.length > 0) {
                    cmPackagePath = retClasses[0].getSearchPath().getValue();
                }
            }
            catch (RemoteException re) {
                throw FmEngSoapRequest.handleRemoteException(re);
            }
        }
        ContentManagerServiceRequest cmRequest = new ContentManagerServiceRequest(this.m_cmService);
        return cmRequest.createModel(cmPackagePath, true, modelName, bQueryMode, stream);
    }

    public String createModel(String cmPackagePath, boolean disableModelVersioning, boolean bQueryMode, ByteArrayOutputStream stream) {
        ContentManagerServiceRequest cmRequest = new ContentManagerServiceRequest(this.m_cmService);
        return cmRequest.createModel(cmPackagePath, disableModelVersioning, null, bQueryMode, stream);
    }

    public List<DSConnectionRecord> queryDataSourceConnections(String cmDatasourceName) {
        StringBuilder cmDatasourcePath = new StringBuilder();
        if (cmDatasourceName.startsWith("CAMID(\":\")/dataSource[@name")) {
            cmDatasourcePath.append(cmDatasourceName);
            cmDatasourcePath.append("/dataSourceConnection");
        } else {
            cmDatasourcePath.append("CAMID(\":\")/dataSource[@name=\"");
            cmDatasourcePath.append(cmDatasourceName);
            cmDatasourcePath.append("\"]/dataSourceConnection");
        }
        ContentManagerServiceRequest cmRequest = new ContentManagerServiceRequest(this.m_cmService);
        return cmRequest.queryForConnections(cmDatasourcePath.toString());
    }

    public List<DSSignonRecord> queryConnectionSignons(String cmConnectionPath) {
        StringBuffer strBuf = new StringBuffer(cmConnectionPath);
        strBuf.append("/dataSourceSignon");
        String signonQuery = strBuf.toString();
        ContentManagerServiceRequest cmRequest = new ContentManagerServiceRequest(this.m_cmService);
        return cmRequest.queryForSignons(signonQuery.toString());
    }

    private List<FmSecurityObject> buildObjects(List<String> cmSecurityObjPaths) throws RemoteException {
        ArrayList<FmSecurityObject> securityObjects = new ArrayList<FmSecurityObject>();
        if (!cmSecurityObjPaths.isEmpty()) {
            PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.ancestors};
            QueryRequest[] queryRequests = new QueryRequest[cmSecurityObjPaths.size()];
            int i = 0;
            while (i < queryRequests.length) {
                queryRequests[i] = new QueryRequest();
                queryRequests[i].setSearch(cmSecurityObjPaths.get(i));
                queryRequests[i].setProperties(props);
                ++i;
            }
            QueryReply[] queryReplys = this.m_cmService.queryMultiple(queryRequests);
            int qi = 0;
            while (qi < queryReplys.length) {
                BaseClass[] results = queryReplys[qi].getQueryResult();
                if (results != null && results.length > 0) {
                    String searchPath = results[0].getSearchPath().getValue();
                    short type = 0;
                    String displayPath = this.buildDisplayPathForObject(results[0], (short)0);
                    FmSecurityObject securityObject = FmSecurityObject.createPersistent(this.m_session, searchPath, type, displayPath);
                    securityObjects.add(securityObject);
                }
                ++qi;
            }
        }
        return securityObjects;
    }

    private String buildDisplayPathForObject(BaseClass securityObj, short objType) {
        boolean bObject;
        String returnPath = "";
        String objectName = "";
        String parentPath = "";
        if (securityObj.getDefaultName() != null) {
            objectName = securityObj.getDefaultName().getValue();
        }
        boolean bl = bObject = objectName.length() != 0;
        if (securityObj.getAncestors() != null) {
            parentPath = this.getFolderDisplayPath(securityObj.getAncestors().getValue());
        }
        boolean bParent = parentPath.length() != 0;
        switch (objType) {
            case 1: {
                returnPath = parentPath;
                if (bObject && bParent) {
                    returnPath = String.valueOf(returnPath) + " > ";
                }
                returnPath = String.valueOf(returnPath) + objectName;
                break;
            }
            case 0: {
                returnPath = objectName;
                if (bObject && bParent) {
                    returnPath = String.valueOf(returnPath) + " [";
                }
                returnPath = String.valueOf(returnPath) + parentPath;
                if (!bObject || !bParent) break;
                returnPath = String.valueOf(returnPath) + "]";
            }
        }
        return returnPath;
    }

    private String getFolderDisplayPath(AncestorInfo[] value) {
        StringBuilder returnPath = new StringBuilder();
        int i = 0;
        while (i < value.length) {
            if (returnPath.length() != 0) {
                returnPath.append(" > ");
            }
            returnPath.append(value[i].getTitle());
            ++i;
        }
        return returnPath.toString();
    }

    public void setModelRetention(String cmPackagePath, int maxModelVersions) throws RemoteException {
        _package cmPackage = new _package();
        StringProp cmPathProp = new StringProp();
        cmPathProp.setValue(cmPackagePath);
        cmPackage.setSearchPath(cmPathProp);
        RetentionRule[] retentionRule = new RetentionRule[]{new RetentionRule()};
        retentionRule[0].setMaxObjects(BigInteger.valueOf(maxModelVersions));
        retentionRule[0].setObjectClass(ClassEnum.fromString((String)"model"));
        retentionRule[0].setProp(PropEnum.creationTime);
        RetentionRuleArrayProp retentionRuleProp = new RetentionRuleArrayProp();
        retentionRuleProp.setValue(retentionRule);
        cmPackage.setRetentions(retentionRuleProp);
        BaseClass[] baseClass = new BaseClass[]{cmPackage};
        this.m_cmService.update(baseClass, new UpdateOptions());
    }

    public void addModelView(String cmModelPath, String viewId) {
        ModelView modelView = new ModelView();
        TokenProp defaultNameProp = new TokenProp();
        defaultNameProp.setValue(viewId);
        modelView.setDefaultName(defaultNameProp);
        BaseClass[] baseClass = new BaseClass[]{modelView};
        SearchPathSingleObject searchObj = new SearchPathSingleObject();
        searchObj.set_value(cmModelPath);
        AddOptions opt = new AddOptions();
        opt.setUpdateAction(UpdateActionEnum.replace);
        try {
            this.m_cmService.add(searchObj, baseClass, opt);
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public Map<String, String> getModelViews(String cmModelPath) throws RemoteException {
        HashMap<String, String> viewMap = new HashMap<String, String>();
        PropEnum[] propArray = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        String searchPath = String.valueOf(cmModelPath) + "/modelView";
        BaseClass[] connArray = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
        int i = 0;
        while (i < connArray.length) {
            ModelView view = (ModelView)connArray[i];
            String name = view.getDefaultName().getValue();
            String path = view.getSearchPath().getValue();
            viewMap.put(name, path);
            ++i;
        }
        return viewMap;
    }

    public Map<String, String> getCmDataSources() throws IOException {
        HashMap<String, String> dataSrcMap = new HashMap<String, String>();
        PropEnum[] propArray = new PropEnum[]{PropEnum.ancestors, PropEnum.defaultName, PropEnum.connectionString};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        String searchPath = "CAMID(\":\")/dataSource/dataSourceConnection[permission('read')]";
        BaseClass[] dataSrcArray = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
        int i = 0;
        while (i < dataSrcArray.length) {
            String dataSrcName = "";
            DataSourceConnection dataSrc = (DataSourceConnection)dataSrcArray[i];
            AncestorInfo[] ansInfo = dataSrc.getAncestors().getValue();
            int ai = 0;
            while (ai < ansInfo.length) {
                if (ansInfo[ai].getObjectClass().getValue().equals("dataSource")) {
                    dataSrcName = ansInfo[ai].getTitle();
                    break;
                }
                ++ai;
            }
            String connectionString = dataSrc.getConnectionString().getValue();
            String type = this.getDSConnectionStringType(connectionString);
            if (dataSrcName.length() > 0 && type.length() > 0) {
                dataSrcMap.put(dataSrcName, type);
            }
            ++i;
        }
        return dataSrcMap;
    }

    public Map<String, String> getCmDataSourceConnectionFor(String dsName) throws IOException {
        HashMap<String, String> connMap = new HashMap<String, String>();
        PropEnum[] propArray = new PropEnum[]{PropEnum.defaultName, PropEnum.connectionString, PropEnum.searchPath};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        String searchPath = "CAMID(\":\")/dataSource[@name=\"";
        searchPath = String.valueOf(searchPath) + dsName;
        searchPath = String.valueOf(searchPath) + "\"]/*";
        BaseClass[] connArray = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
        int i = 0;
        while (i < connArray.length) {
            DataSourceConnection conn = (DataSourceConnection)connArray[i];
            String connName = conn.getDefaultName().getValue();
            String connSearchPath = conn.getSearchPath().getValue();
            connMap.put(connName, connSearchPath);
            ++i;
        }
        return connMap;
    }

    public Map<String, String> getCmDataSourceSignonFor(String dsName, String connName) throws IOException {
        HashMap<String, String> signonMap = new HashMap<String, String>();
        PropEnum[] propArray = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        String searchPath = "CAMID(\":\")/dataSource[@name=\"";
        searchPath = String.valueOf(searchPath) + dsName;
        searchPath = String.valueOf(searchPath) + "\"]/dataSourceConnection[@name=\"";
        searchPath = String.valueOf(searchPath) + connName;
        searchPath = String.valueOf(searchPath) + "\"]/*";
        BaseClass[] signonArray = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
        int i = 0;
        while (i < signonArray.length) {
            DataSourceSignon signon = (DataSourceSignon)signonArray[i];
            String signonName = signon.getDefaultName().getValue();
            String signonSearchPath = signon.getSearchPath().getValue();
            signonMap.put(signonName, signonSearchPath);
            ++i;
        }
        return signonMap;
    }

    public void verifyAmbiguity(FMMDSession session, String dsName, String dsType) throws IOException {
        Map<String, String> cmConnections = this.getCmDataSourceConnectionFor(dsName);
        if (cmConnections.size() > 1) {
            this.throwFault801(dsName, dsType, cmConnections);
        } else {
            for (Map.Entry<String, String> entry : cmConnections.entrySet()) {
                String connName = entry.getKey();
                Map<String, String> cmSignons = this.getCmDataSourceSignonFor(dsName, connName);
                if (cmSignons.size() <= 1) continue;
                String connSearchPath = entry.getValue();
                this.throwFault802(dsName, dsType, connName, connSearchPath, cmSignons);
            }
        }
    }

    private void throwFault801(String dsName, String dsType, Map<String, String> cmConnections) {
        StringBuilder domStr = new StringBuilder("<Fault><faultcode>CQE-801</faultcode><dataSource><name value=\"");
        domStr.append(dsName);
        domStr.append("\"/><type value=\"");
        domStr.append("\"/>");
        for (Map.Entry<String, String> entry : cmConnections.entrySet()) {
            domStr.append("<connection><name value=\"");
            domStr.append(entry.getKey());
            domStr.append("\"/></connection>");
        }
        domStr.append("</dataSource></Fault>");
        Element faultElem = DomHelper.stringToDom4j(domStr.toString());
        QFException qfException = new QFException(801);
        qfException.setDOM(faultElem);
        throw qfException;
    }

    private void throwFault802(String dsName, String dsType, String connName, String connSearchPath, Map<String, String> cmSignons) {
        StringBuilder domStr = new StringBuilder("<Fault><faultcode>CQE-802</faultcode><dataSource><name value=\"");
        domStr.append(dsName);
        domStr.append("\"/><type value=\"");
        domStr.append("\"/><faultConnection><name value=\"");
        domStr.append(connName);
        domStr.append("\"/><connection><name value=\"");
        domStr.append(connName);
        domStr.append("\"/>");
        for (Map.Entry<String, String> entry : cmSignons.entrySet()) {
            domStr.append("<signon><name value=\"");
            domStr.append(entry.getKey());
            domStr.append("\"/></signon>");
        }
        domStr.append("</connection></faultConnection></dataSource></Fault>");
        Element faultElem = DomHelper.stringToDom4j(domStr.toString());
        QFException qfException = new QFException(802);
        qfException.setDOM(faultElem);
        throw qfException;
    }

    private String getDSConnectionStringType(String connection) {
        String type = "";
        String[] parts = connection.split(";");
        if (parts.length >= 3) {
            type = parts[2];
        }
        return type;
    }

    public void validatePassport() {
        try {
            PropEnum[] propArray = new PropEnum[]{PropEnum.defaultName};
            QueryOptions queryOpts = new QueryOptions();
            queryOpts.setPermission("read");
            queryOpts.setSchemaInfo(false);
            queryOpts.setMaxObjects(BigInteger.valueOf(0L));
            queryOpts.setSkipObjects(BigInteger.valueOf(0L));
            queryOpts.setDataEncoding(EncodingEnum.base64);
            queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
            queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
            this.m_cmService.query(new SearchPathMultipleObject("~"), propArray, null, queryOpts);
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public boolean addCubeToQueryService(String cubeName, boolean isVirtualCube) {
        BaseClass[] queryServices = this.getQueryServices();
        BaseClass sdkQueryService = null;
        if (queryServices.length == 0) {
            throw new FmMDException("BMT_MD_NO_QUERY_SERVICES");
        }
        URI uri = null;
        try {
            uri = new URI(this.m_dispatcherEndPoint);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new FmMDException("BMT_MD_INVALID_DISPATCHER_URI", this.m_dispatcherEndPoint);
        }
        String dispatcherOfInterest = uri.getHost();
        if (dispatcherOfInterest.contains("localhost")) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                dispatcherOfInterest = dispatcherOfInterest.replace("localhost", addr.getHostName()).toLowerCase();
            }
            catch (UnknownHostException unknownHostException) {}
        }
        boolean alreadyRegistered = false;
        BaseROLAPCubeConfiguration[] existingCubeConfigs = null;
        BaseClass[] baseClassArray = queryServices;
        int n = queryServices.length;
        int n2 = 0;
        while (n2 < n) {
            BaseClass queryService = baseClassArray[n2];
            if (((QueryService_Type)queryService).getQsROLAPCubeConfigurations() != null && queryService.getSearchPath().getValue().contains(dispatcherOfInterest)) {
                sdkQueryService = queryService;
                break;
            }
            ++n2;
        }
        if (sdkQueryService == null) {
            throw new FmMDException("BMT_MD_CAN_NOT_FIND_DISPATCHER_URI", dispatcherOfInterest);
        }
        existingCubeConfigs = ((QueryService_Type)sdkQueryService).getQsROLAPCubeConfigurations().getValue();
        if (existingCubeConfigs != null) {
            int i = 0;
            while (i < existingCubeConfigs.length) {
                if (existingCubeConfigs[i].getDataSourceName().equals(cubeName)) {
                    alreadyRegistered = true;
                    break;
                }
                ++i;
            }
        }
        if (!alreadyRegistered) {
            QueryService_Type qs = new QueryService_Type();
            qs.setStoreID(sdkQueryService.getStoreID());
            qs.setSearchPath(sdkQueryService.getSearchPath());
            BaseROLAPCubeConfigurationArrayProp propArray = new BaseROLAPCubeConfigurationArrayProp();
            qs.setQsROLAPCubeConfigurations(propArray);
            int len = existingCubeConfigs != null ? existingCubeConfigs.length + 1 : 1;
            BaseROLAPCubeConfiguration[] configs = new BaseROLAPCubeConfiguration[len];
            RolapVirtualCubeConfiguration rConf = null;
            if (isVirtualCube) {
                rConf = new RolapVirtualCubeConfiguration();
            } else {
                rConf = new RolapCubeConfiguration();
                ((RolapCubeConfiguration)rConf).setDisableExternalAggregates(false);
                ((RolapCubeConfiguration)rConf).setEnableDynamicMemberCaching(true);
                ((RolapCubeConfiguration)rConf).setMemberCacheLimit(100000);
                ((RolapCubeConfiguration)rConf).setPredicateMemberReferenceThreshold(90);
                ((RolapCubeConfiguration)rConf).setPostInMemoryTriggerName("");
                ((RolapCubeConfiguration)rConf).setAutomaticAggregateOptimizationEnabled(AutomaticAggregateOptimizationEnum.automaticAggregateOptimizationOff);
                ((RolapCubeConfiguration)rConf).setMaxAggregateLoadThreads(0);
                ((RolapCubeConfiguration)rConf).setMaxHierarchyLoadThreads(0);
                ((RolapCubeConfiguration)rConf).setMeasuresThreshold(30);
            }
            rConf.setDataSourceName(cubeName);
            rConf.setDataCacheSizeLimit(1024);
            rConf.setDisabled(false);
            rConf.setDisableResultSetCache(false);
            rConf.setResultSetCacheSizeLimit(1024);
            rConf.setStartupTriggerName("");
            int i = 0;
            if (existingCubeConfigs != null) {
                i = 0;
                while (i < existingCubeConfigs.length) {
                    configs[i] = existingCubeConfigs[i];
                    if (configs[i] instanceof RolapCubeConfiguration && ((RolapCubeConfiguration)configs[i]).getAutomaticAggregateOptimizationEnabled() == null) {
                        ((RolapCubeConfiguration)configs[i]).setAutomaticAggregateOptimizationEnabled(AutomaticAggregateOptimizationEnum.automaticAggregateOptimizationOff);
                    }
                    ++i;
                }
            }
            configs[i] = rConf;
            qs.getQsROLAPCubeConfigurations().setValue(configs);
            BaseClass[] qsObjs = new BaseClass[]{qs};
            try {
                this.m_cmService.update(qsObjs, null);
            }
            catch (RemoteException e) {
                throw FmEngSoapRequest.handleRemoteException(e);
            }
        }
        return alreadyRegistered;
    }

    private BaseClass[] getQueryServices() {
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.qsROLAPCubeConfigurations, PropEnum.storeID};
        QueryRequest query = new QueryRequest();
        query.setSearch("//queryService");
        query.setProperties(props);
        try {
            QueryRequest[] requests = new QueryRequest[]{query};
            QueryReply[] replies = this.m_cmService.queryMultiple(requests);
            if (replies != null && replies.length > 0) {
                return replies[0].getQueryResult();
            }
        }
        catch (RemoteException e) {
            throw FmEngSoapRequest.handleRemoteException(e);
        }
        return null;
    }

    public String startCube(String cubeName) {
        StringBuilder requestResult = new StringBuilder();
        String[] cubeNames = new String[]{cubeName};
        FmMessage progMess = new FmMessage("BMT_UIP_GETTING_CUBE_STATUS");
        this.m_session.getProgressCallbackHandler().setProgressStatus(-1, progMess.render(this.m_session.getActiveLocale()));
        String runStatus = KSTR_UNKNOWN;
        int retryCount = 0;
        while ((runStatus = this.getCubeRunStatus(cubeName)).equals(KSTR_UNKNOWN) || runStatus.equals(KSTR_STARTING)) {
            this.sleep(1000);
            if (++retryCount > 20) {
                FmMDException e = new FmMDException("BMT_MD_TIMEOUT_WAITING_FOR_CUBECONFIG");
                throw e;
            }
            if (!this.m_session.getProgressCallbackHandler().isCancelRequested()) continue;
            throw new FmMDException("BMT_MD_CANCELED");
        }
        try {
            QueryService_ServiceLocator serviceLocator = new QueryService_ServiceLocator();
            QueryService_PortType port = null;
            String dispatcherURL = FmPreferences.getInstance().getDispatcherEndPoint();
            port = serviceLocator.getqueryService(new URL(dispatcherURL));
            BiBusHeader header = FmEngSoapRequest.initializeStub((Stub)port, this.m_passport, this.m_session.getActiveLocale().toString());
            this.setCapabilities(header);
            FmMessage progMess1 = new FmMessage("BMT_UIP_STARTING_CUBE");
            this.m_session.getProgressCallbackHandler().setProgressStatus(-1, progMess1.render(this.m_session.getActiveLocale()));
            ParameterValue[] parameters = new ParameterValue[]{};
            Option[] options = new Option[]{};
            AsynchReply result = null;
            if (runStatus.equals("stopped")) {
                result = port.startCubes(cubeNames, parameters, options);
                retryCount = 0;
            } else if (runStatus.equals("started") || runStatus.equals("running")) {
                result = port.restartCubes(cubeNames, parameters, options);
                retryCount = 0;
            }
            Stub stub = (Stub)port;
            while (!result.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
                if (result.getStatus().equals((Object)AsynchReplyStatusEnum.working) || result.getStatus().equals((Object)AsynchReplyStatusEnum.stillWorking)) {
                    header = MFWBiBusHelper.getBiBusHeader((Stub)stub);
                    stub.clearHeaders();
                    stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
                    result = port.wait(result.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                } else if (retryCount > 120 && (result == null || result.getDetails() == null)) {
                    FmMDException e = new FmMDException("BMT_MD_TIMEOUT_WAITING_FOR_CUBECONFIG");
                    throw e;
                }
                FmMessage progMess2 = new FmMessage("BMT_UIP_WAITING_ON_CUBE_START");
                this.m_session.getProgressCallbackHandler().setProgressStatus(-1, progMess2.render(this.m_session.getActiveLocale()));
                this.sleep(1000);
                ++retryCount;
                if (!this.m_session.getProgressCallbackHandler().isCancelRequested()) continue;
                port.cancel(result.getPrimaryRequest());
                throw new FmMDException("BMT_MD_CANCELED");
            }
            if (result != null && result.getDetails() != null) {
                int i = 0;
                while (i < result.getDetails().length) {
                    if (result.getDetails()[i] instanceof AsynchDetailMessages) {
                        FaultDetail[] faultMessages = ((AsynchDetailMessages)result.getDetails()[i]).getMessages();
                        int j = 0;
                        while (j < faultMessages.length) {
                            requestResult.append("\n\n");
                            requestResult.append(faultMessages[j].getMessage()[0].getMessage());
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return requestResult.toString();
    }

    private void sleep(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getCubeRunStatus(String cubeName) {
        String runState = KSTR_UNKNOWN;
        try {
            QueryService_ServiceLocator serviceLocator = new QueryService_ServiceLocator();
            QueryService_PortType port = null;
            String dispatcherURL = FmPreferences.getInstance().getDispatcherEndPoint();
            port = serviceLocator.getqueryService(new URL(dispatcherURL));
            BiBusHeader header = FmEngSoapRequest.initializeStub((Stub)port, this.m_passport, this.m_session.getActiveLocale().toString());
            this.setCapabilities(header);
            ParameterValue[] parameters = new ParameterValue[]{};
            Option[] options = new Option[]{};
            String[] emptyCubeNames = new String[]{};
            AsynchReply result = port.getCubeState(emptyCubeNames, parameters, options);
            if (!result.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
                Stub stub = (Stub)port;
                while (!result.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
                    if (!this.hasSecondaryRequest(result, "wait")) break;
                    header = MFWBiBusHelper.getBiBusHeader((Stub)stub);
                    stub.clearHeaders();
                    stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
                    result = port.wait(result.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                    FmMessage progMess = new FmMessage("BMT_UIP_WAITING_ON_CUBE_STATUS");
                    this.m_session.getProgressCallbackHandler().setProgressStatus(-1, progMess.render(this.m_session.getActiveLocale()));
                    this.sleep(1000);
                    if (!this.m_session.getProgressCallbackHandler().isCancelRequested()) continue;
                    port.cancel(result.getPrimaryRequest());
                    throw new FmMDException("BMT_MD_CANCELED");
                }
            }
            if (result != null && result.getDetails() != null) {
                int i = 0;
                while (i < result.getDetails().length) {
                    AsynchDetailROLAPDataSourceState state = (AsynchDetailROLAPDataSourceState)result.getDetails()[i];
                    if (state.getDataSourceName().equals(cubeName)) {
                        runState = state.getState();
                    }
                    ++i;
                }
            }
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return runState;
    }

    private void setCapabilities(BiBusHeader header) {
        ContentManagerServiceRequest cmRequest = new ContentManagerServiceRequest(this.m_cmService);
        UserCapabilityEnum[] userCapabilities = cmRequest.queryForUserCapabilities();
        UserCapabilityCache capabilityCache = new UserCapabilityCache();
        capabilityCache.setUserCapabilities(userCapabilities);
        header.setUserCapabilityCache(capabilityCache);
    }

    private boolean hasSecondaryRequest(AsynchReply response, String secondaryRequest) {
        AsynchSecondaryRequest[] secondaryRequests = response.getSecondaryRequests();
        if (secondaryRequests != null) {
            int i = 0;
            while (i < secondaryRequests.length) {
                if (secondaryRequests[i].getName().compareTo(secondaryRequest) == 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean checkIfCMObjectHasMultiLocaleRenameIssues(BaseClass foundDs, List<LocalizedValue> nameList) {
        MultilingualToken[] foundDataSourceNames = foundDs.getName().getValue();
        boolean foundSameNameInAtLeastOneLocale = false;
        boolean foundDifferentNameInAtLeastOneLocale = false;
        HashMap<String, String> foundDSNameValuePair = new HashMap<String, String>();
        int i = 0;
        while (i < foundDataSourceNames.length) {
            foundDSNameValuePair.put(foundDataSourceNames[i].getLocale(), foundDataSourceNames[i].getValue());
            ++i;
        }
        for (LocalizedValue name : nameList) {
            String localeName = (String)foundDSNameValuePair.get(name.getLocale());
            if (localeName == null) continue;
            if (localeName.equals(name.getValue())) {
                foundSameNameInAtLeastOneLocale = true;
                continue;
            }
            foundDifferentNameInAtLeastOneLocale = true;
        }
        return foundSameNameInAtLeastOneLocale && foundDifferentNameInAtLeastOneLocale;
    }

    public void deleteRolapDataSource(String rolapDSPath) {
        RolapDataSource toDelete = new RolapDataSource();
        StringProp searchProp = new StringProp();
        searchProp.setValue(rolapDSPath);
        toDelete.setSearchPath(searchProp);
        BaseClass[] objs = new BaseClass[]{toDelete};
        DeleteOptions ops = new DeleteOptions();
        ops.setRecursive(true);
        ops.setForce(true);
        try {
            this.m_cmService.delete(objs, ops);
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public static final class DSConnectionRecord {
        private String mName = null;
        private String mSearchPath = null;
        private String mConnectonStr = null;
        private String mCredentialNamespace = null;

        public DSConnectionRecord(String aName, String path, String connStr, String credentialNS) {
            this.mName = aName;
            this.mSearchPath = path;
            this.mConnectonStr = connStr;
            this.mCredentialNamespace = credentialNS;
        }

        public String getName() {
            return this.mName;
        }

        public String getSearchPath() {
            return this.mSearchPath;
        }

        public String getConnectionString() {
            return this.mConnectonStr;
        }

        public String getCredentialNamespace() {
            return this.mCredentialNamespace;
        }
    }

    public static final class DSSignonRecord {
        private String mName = null;
        private String mSearchPath = null;
        private StringDecryptionHelper mDecryptHelper = null;

        public DSSignonRecord(String aName, String path, String credentials) {
            this.mName = aName;
            this.mSearchPath = path;
            this.mDecryptHelper = new StringDecryptionHelper(credentials);
        }

        public String getName() {
            return this.mName;
        }

        public String getSearchPath() {
            return this.mSearchPath;
        }

        public String getUserName() {
            return this.getCredentialItem("username");
        }

        public String getPassword() {
            return this.getCredentialItem("password");
        }

        public String getTicket() {
            return this.getCredentialItem("SAPLogonTicket");
        }

        public String getNamespace() {
            return this.getCredentialItem("namespace");
        }

        public String getCubePassword() {
            return this.getCredentialItem("cubePassword");
        }

        private String getCredentialItem(String parameterItemName) {
            String parameterItemValue = "";
            if (this.mDecryptHelper != null) {
                parameterItemValue = this.mDecryptHelper.extractCredentialsFromXMLString(parameterItemName);
            }
            return parameterItemValue;
        }
    }
}

