/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.cognos.developer.schemas.bibus._3.AccessEnum;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Group;
import com.cognos.developer.schemas.bibus._3.Permission;
import com.cognos.developer.schemas.bibus._3.Policy;
import com.cognos.developer.schemas.bibus._3.PolicyArrayProp;
import com.cognos.developer.schemas.bibus._3.Role;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmPolicyHelper {
    private static final short KBOTH = 0;
    private static final short KCONSUMER = 1;
    private static final short KADMIN = 2;
    private List<FmSecurityObject> m_adminObjSearchPaths = null;
    private List<FmSecurityObject> m_userObjSearchPaths = null;
    private String m_cmObjectType = "";

    static boolean hasPermission(Policy policy, String permission) {
        boolean hasPermission = false;
        Permission[] permissions = policy.getPermissions();
        if (permissions != null) {
            int i = 0;
            while (i < permissions.length) {
                if (permissions[i].getAccess() == AccessEnum.grant && permission.equals(permissions[i].getName())) {
                    hasPermission = true;
                    break;
                }
                ++i;
            }
        }
        return hasPermission;
    }

    public CmPolicyHelper(List<FmSecurityObject> userObjSearchPaths, List<FmSecurityObject> adminObjSearchPaths, String cmObjectType) {
        this.m_adminObjSearchPaths = adminObjSearchPaths;
        this.m_userObjSearchPaths = userObjSearchPaths;
        this.m_cmObjectType = cmObjectType;
    }

    PolicyArrayProp buildPolicyArrayProp() {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        int i = 0;
        i = 0;
        while (i < this.m_userObjSearchPaths.size()) {
            boolean bAddAdmin;
            policies.add(this.buildPolicy(this.m_userObjSearchPaths.get(i), (bAddAdmin = this.m_adminObjSearchPaths.remove(this.m_userObjSearchPaths.get(i))) ? (short)0 : 1));
            ++i;
        }
        i = 0;
        while (i < this.m_adminObjSearchPaths.size()) {
            policies.add(this.buildPolicy(this.m_adminObjSearchPaths.get(i), (short)2));
            ++i;
        }
        PolicyArrayProp policyArrayProp = new PolicyArrayProp();
        policyArrayProp.setValue(policies.toArray(new Policy[policies.size()]));
        return policyArrayProp;
    }

    Policy buildPolicy(FmSecurityObject securityObject, short policyType) {
        Policy policy = new Policy();
        policy.setSecurityObject(this.buildCMSecurityObject(securityObject));
        if (this.m_cmObjectType.equals("modelView")) {
            switch (policyType) {
                case 1: {
                    Permission[] permissions = new Permission[1];
                    policy.setPermissions(permissions);
                    this.addPermission(policy.getPermissions(), "execute", 0);
                    break;
                }
                case 2: {
                    Permission[] permissions = new Permission[2];
                    policy.setPermissions(permissions);
                    this.addPermission(policy.getPermissions(), "read", 0);
                    this.addPermission(policy.getPermissions(), "write", 1);
                    break;
                }
                case 0: {
                    Permission[] permissions = new Permission[3];
                    policy.setPermissions(permissions);
                    this.addPermission(policy.getPermissions(), "read", 0);
                    this.addPermission(policy.getPermissions(), "write", 1);
                    this.addPermission(policy.getPermissions(), "execute", 2);
                }
            }
        } else if (this.m_cmObjectType.equals("model") || this.m_cmObjectType.equals("package")) {
            switch (policyType) {
                case 1: {
                    Permission[] permissions = new Permission[4];
                    policy.setPermissions(permissions);
                    this.addPermission(policy.getPermissions(), "read", 0);
                    this.addPermission(policy.getPermissions(), "write", 1);
                    this.addPermission(policy.getPermissions(), "execute", 2);
                    this.addPermission(policy.getPermissions(), "traverse", 3);
                    break;
                }
                case 2: {
                    Permission[] permissions = new Permission[4];
                    policy.setPermissions(permissions);
                    this.addPermission(policy.getPermissions(), "read", 0);
                    this.addPermission(policy.getPermissions(), "write", 1);
                    this.addPermission(policy.getPermissions(), "traverse", 2);
                    this.addPermission(policy.getPermissions(), "setPolict", 3);
                    break;
                }
                case 0: {
                    Permission[] permissions = new Permission[5];
                    policy.setPermissions(permissions);
                    this.addPermission(policy.getPermissions(), "read", 0);
                    this.addPermission(policy.getPermissions(), "write", 1);
                    this.addPermission(policy.getPermissions(), "traverse", 2);
                    this.addPermission(policy.getPermissions(), "setPolict", 3);
                    this.addPermission(policy.getPermissions(), "execute", 4);
                }
            }
        }
        return policy;
    }

    private void addPermission(Permission[] permissions, String permissionName, int nIndex) {
        Permission permission = new Permission();
        permission.setName(permissionName);
        permission.setAccess(AccessEnum.grant);
        permissions[nIndex] = permission;
    }

    private BaseClass buildCMSecurityObject(FmSecurityObject securityObject) {
        Account obj = null;
        switch (securityObject.getType()) {
            case 0: {
                obj = new Account();
                break;
            }
            case 2: {
                obj = new Group();
                break;
            }
            case 1: {
                obj = new Role();
            }
        }
        if (obj != null) {
            StringProp strProp = new StringProp();
            strProp.setValue(securityObject.getCMSearchPath());
            obj.setSearchPath(strProp);
        }
        return obj;
    }
}

