/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmCopyManager;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipShortcut;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.Status;
import com.ibm.cognos.fmeng.fmmd.util.ObjectReferenceHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyRelationshipsHelper {
    private FMMDSession m_session;
    private QuerySubject m_qs;
    private List<QuerySubjectBase> m_qsdims;
    private List<ReportObject> m_items;
    private List<Shortcut> m_shortcuts;
    private boolean m_forMerge = false;

    public CopyRelationshipsHelper(QuerySubject qs, List<QuerySubjectBase> qsdims, List<ReportObject> items, List<Shortcut> shortcuts) {
        this.m_session = qs.getSession();
        this.m_qs = qs;
        this.m_qsdims = qsdims;
        this.m_items = items;
        this.m_shortcuts = shortcuts != null ? shortcuts : new ArrayList(1);
    }

    public void findAllRelationships(List<RelationshipBase> hCopyRelationships) {
        List<Object> objects;
        ArrayList<RelationshipBase> hReferencedRelations;
        for (QuerySubjectBase qs : this.m_qsdims) {
            hReferencedRelations = new ArrayList<RelationshipBase>();
            objects = ObjectReferenceHelper.getRelationshipsFor(this.m_session.getProject(), qs, true);
            if (objects == null) continue;
            for (Object obj : objects) {
                hReferencedRelations.add((RelationshipBase)FmModelFactory.getInstance().get(this.m_session, obj));
            }
            this.filterRelationships(qs, hReferencedRelations, this.m_items, hCopyRelationships);
        }
        for (Shortcut sc : this.m_shortcuts) {
            hReferencedRelations = new ArrayList();
            objects = ObjectReferenceHelper.getRelationshipsFor(this.m_session.getProject(), sc, true);
            if (objects == null) continue;
            for (Object obj : objects) {
                hReferencedRelations.add((RelationshipBase)FmModelFactory.getInstance().get(this.m_session, obj));
            }
            this.filterRelationships(sc, hReferencedRelations, this.m_items, hCopyRelationships);
        }
    }

    public void copyRelationshipsForMerge() {
        this.m_forMerge = true;
        this.copyRelationships();
    }

    public void copyRelationships() {
        ArrayList<RelationshipBase> hRelationships = new ArrayList<RelationshipBase>();
        this.findAllRelationships(hRelationships);
        this.copyRelationshipsAndFixupReferences(hRelationships);
    }

    private void copyRelationshipsAndFixupReferences(List<RelationshipBase> hCopyRelationships) {
        FMMDSession session = this.m_qs.getSession();
        FmBaseObject parentObj = (FmBaseObject)((Object)this.m_qs.getParentNamespace());
        List<BaseObject> copies = FmCopyManager.copy(session, (BaseObject)parentObj, hCopyRelationships);
        for (BaseObject copy : copies) {
            if (!(copy instanceof RelationshipBase)) continue;
            RelationshipBase rel = (RelationshipBase)copy;
            RelationshipEnd leftEnd = rel.getLeftEnd();
            RelationshipEnd rightEnd = rel.getRightEnd();
            if (this.m_qsdims.contains(leftEnd)) {
                rel.setLeftEnd(this.m_qs);
                CopyRelationshipsHelper.fixupExpression(rel, this.m_qs, leftEnd);
            } else if (this.m_qsdims.contains(rightEnd)) {
                rel.setRightEnd(this.m_qs);
                CopyRelationshipsHelper.fixupExpression(rel, this.m_qs, rightEnd);
            }
            CopyRelationshipsHelper.fixupName(rel);
        }
    }

    private void filterRelationships(BaseObject object, List<RelationshipBase> hCandidateRels, List<ReportObject> selectedQItems, List<RelationshipBase> hCopyRelations) {
        QuerySubject querySubject = null;
        if (object instanceof QuerySubject) {
            querySubject = (QuerySubject)object;
        } else if (object instanceof Shortcut) {
            querySubject = (QuerySubject)((Shortcut)object).getRefobj();
        }
        ArrayList<Object> queryItems = new ArrayList<Object>();
        if (!this.m_forMerge) {
            List<QueryItem> hQueryItems = querySubject.getAllQueryItems();
            for (QueryItem item : hQueryItems) {
                queryItems.add(item.getInternal());
            }
        }
        for (RelationshipBase rel : hCandidateRels) {
            if (hCopyRelations.contains(rel)) continue;
            RelationshipShortcut relsc = null;
            if (rel instanceof RelationshipShortcut) {
                relsc = (RelationshipShortcut)rel;
                rel = (Relationship)((Object)((FmRelationshipShortcut)rel).getTarget());
            }
            if (((Relationship)rel).getStatus() == Status.EStatus.invalid || this.isRelationshipInternal(rel, true)) continue;
            Expression hExpression = ((Relationship)rel).getExpression();
            ArrayList<QueryItem> exprReferences = new ArrayList<QueryItem>();
            List<ReportObject> refobjs = hExpression.getRefObjs(true);
            for (ReportObject rItr : refobjs) {
                QueryItem item;
                QuerySubjectBase parent;
                if (!(rItr instanceof QueryItem) || !(parent = (item = (QueryItem)rItr).getQueryParent()).equals(querySubject) || !this.m_forMerge && !queryItems.contains(item.getInternal())) continue;
                exprReferences.add(item);
            }
            if (exprReferences.isEmpty() || !selectedQItems.containsAll(exprReferences)) continue;
            if (relsc != null) {
                hCopyRelations.add(relsc);
                continue;
            }
            hCopyRelations.add((Relationship)rel);
        }
    }

    private boolean isRelationshipInternal(RelationshipBase rel, boolean isMerge) {
        RelationshipEnd left = rel.getLeftEnd();
        RelationshipEnd right = rel.getRightEnd();
        boolean result = false;
        result = this.m_forMerge ? !(!this.m_qsdims.contains(left) && !this.m_shortcuts.contains(left) || !this.m_qsdims.contains(right) && !this.m_shortcuts.contains(right)) : left == this.m_qs || right == this.m_qs;
        return result;
    }

    private static boolean fixupName(RelationshipBase copiedRel) {
        RelationshipEnd rightEnd;
        RelationshipEnd leftEnd = copiedRel.getLeftEnd();
        if (leftEnd.equals(rightEnd = copiedRel.getRightEnd())) {
            return false;
        }
        String leftName = leftEnd.getName();
        String rightName = rightEnd.getName();
        String joinName = leftName;
        joinName = String.valueOf(joinName) + " <--> ";
        joinName = String.valueOf(joinName) + rightName;
        String uniqueName = copiedRel.makeUniqueName(joinName);
        copiedRel.setName(uniqueName);
        return true;
    }

    private static void fixupExpression(RelationshipBase pRel, QuerySubject modelQuery, RelationshipEnd replacedEnd) {
        FmExpression expr;
        if (pRel instanceof RelationshipShortcut) {
            pRel = ((FmRelationshipShortcut)pRel).getTarget();
        }
        if ((expr = (FmExpression)((Relationship)pRel).getExpression()) != null) {
            expr.retargetQueryItem((QuerySubject)replacedEnd, modelQuery);
        }
    }

    public static void handleDuplicateRelationships(Relationship plannedRelationship, RelationshipEnd theEnd, RelationshipEnd hOtherEnd, Expression joinExpr) {
        List<ReportObject> refObjects1 = joinExpr.getRefObjs(true);
        FMMDSession session = theEnd.getSession();
        List<Object> newRelationships = ObjectReferenceHelper.getRelationshipsFor(session.getProject(), theEnd, true);
        int i = 0;
        while (i < newRelationships.size()) {
            RelationshipBase pRel = (RelationshipBase)FmModelFactory.getInstance().get(session, newRelationships.get(i));
            if (!pRel.equals(plannedRelationship)) {
                RelationshipEnd hLeft = pRel.getLeftEnd();
                RelationshipEnd hRight = pRel.getRightEnd();
                if (hOtherEnd.equals(hLeft) || hOtherEnd.equals(hRight)) {
                    Expression hExpr = ((Relationship)pRel).getExpression();
                    List<ReportObject> refObjects2 = hExpr.getRefObjs(true);
                    if (refObjects1 == refObjects2) {
                        ((EMFSession)session).getGateway().delete(pRel.getInternal());
                        break;
                    }
                    String sUniqueName = pRel.makeUniqueName(pRel.getName());
                    pRel.setName(sUniqueName);
                }
            }
            ++i;
        }
    }
}

