/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrnIDHelper {
    public static final String LEFT_BRACKET = "[";
    public static final String RIGHT_BRACKET = "]";
    public static final String RIGHT_BRACKET_ESCAPED = "]]";
    public static final String DOT = ".";

    public static String cleanIDEntry(String idEntry) {
        boolean lastCharWasASpace = false;
        String temp = idEntry.trim();
        StringBuffer cleanedEntry = new StringBuffer();
        int i = 0;
        while (i < temp.length()) {
            char c = temp.charAt(i);
            boolean bSpace = Character.isWhitespace(c);
            if (!(Character.isISOControl(c) || bSpace && lastCharWasASpace)) {
                cleanedEntry.append(c);
                lastCharWasASpace = bSpace;
            }
            ++i;
        }
        return cleanedEntry.toString();
    }

    public static String addEntryToID(String anID, String idEntry) {
        if (idEntry == null) {
            return null;
        }
        String sTemp = idEntry.replaceAll(RIGHT_BRACKET, RIGHT_BRACKET_ESCAPED);
        StringBuffer newID = null;
        if (anID == null) {
            newID = new StringBuffer(LEFT_BRACKET);
        } else {
            newID = new StringBuffer(anID);
            newID.append(DOT);
            newID.append(LEFT_BRACKET);
        }
        newID.append(sTemp);
        newID.append(RIGHT_BRACKET);
        return newID.toString();
    }

    public static List<String> parseID(String idXML, boolean includeBracketsInNameParts) {
        ArrayList<String> results = new ArrayList<String>();
        int idXMLLen = idXML.length();
        int beginPos = -1;
        int endPos = -1;
        boolean endFound = true;
        int i = 0;
        while (i < idXMLLen) {
            if (idXML.charAt(i) == '[' && endFound) {
                beginPos = i + 1;
                endFound = false;
            }
            if (idXML.charAt(i) == ']') {
                if (i < idXMLLen - 1 && idXML.charAt(i + 1) == ']') {
                    ++i;
                } else {
                    endPos = i;
                    endFound = true;
                    if (includeBracketsInNameParts) {
                        String newID = idXML.substring(beginPos - 1, endPos + 1);
                        results.add(newID);
                    } else {
                        String newIDEntry = idXML.substring(beginPos, endPos);
                        newIDEntry.replaceAll(RIGHT_BRACKET_ESCAPED, RIGHT_BRACKET);
                        results.add(newIDEntry);
                    }
                }
            }
            ++i;
        }
        return results;
    }
}

