/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRefobjViaShortcut;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.CrnIDHelper;
import com.ibm.cognos.fmeng.fmmd.util.FmMemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.genmodel.MunType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmBuilderBase {
    protected List<Object> m_parts = new ArrayList<Object>();

    protected void addPartImpl(Object part, Object before) {
        if (before == null) {
            this.m_parts.add(part);
        } else {
            int idx = this.m_parts.indexOf(before);
            this.m_parts.add(idx, part);
        }
    }

    protected void clear() {
        this.m_parts = new ArrayList<Object>();
    }

    public List<Object> getParts() {
        return this.m_parts;
    }

    public String toV5ExpressionString(FMMDSession session) {
        List<Object> parts = this.getParts();
        StringBuilder res = new StringBuilder();
        for (Object part : parts) {
            if (part instanceof String) {
                res.append(part.toString());
                continue;
            }
            if (part instanceof TopLevelObject) {
                TopLevelObject tlo = (TopLevelObject)part;
                res.append(tlo.getID());
                continue;
            }
            if (part instanceof ReferenceThroughShortcut) {
                ReferenceThroughShortcut rts = (ReferenceThroughShortcut)part;
                String v5ShortcutId = rts.m_shortcut.getID();
                List<String> idParts = CrnIDHelper.parseID(rts.m_qi.getID(), false);
                int i = 2;
                while (i < idParts.size()) {
                    v5ShortcutId = CrnIDHelper.addEntryToID(v5ShortcutId, idParts.get(i));
                    ++i;
                }
                res.append(v5ShortcutId);
                continue;
            }
            if (!(part instanceof MemberUniqueNameBuilder)) continue;
            MemberUniqueNameBuilder munBuilder = (MemberUniqueNameBuilder)part;
            MunType mt = ((FmMemberUniqueNameBuilder)munBuilder).buildMemberUniqueName(session);
            FmMemberUniqueName mun = FmMemberUniqueName.get(session, mt);
            res.append(mun.getV5MemberUniqueName(null, true));
        }
        return res.toString();
    }

    public void populateFrom(List<Object> comps) {
        for (Object part : comps) {
            if (part instanceof String) {
                this.m_parts.add(part);
                continue;
            }
            if (part instanceof TopLevelObject) {
                this.m_parts.add(part);
                continue;
            }
            if (!(part instanceof FmRefobjViaShortcut)) continue;
            FmRefobjViaShortcut rvs = (FmRefobjViaShortcut)part;
            this.m_parts.add(new ReferenceThroughShortcut(rvs.getShortcut(), rvs.getRefobj()));
        }
    }

    public boolean isEmpty() {
        return this.m_parts.size() == 0;
    }

    public boolean equals(List<Object> components) {
        if (components.size() != this.m_parts.size()) {
            return false;
        }
        int i = 0;
        while (i < components.size()) {
            if (!components.get(i).equals(this.m_parts.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public class ReferenceThroughShortcut {
        public Shortcut m_shortcut;
        public QueryItemBase m_qi;

        ReferenceThroughShortcut(Shortcut shortcut, QueryItemBase qi) {
            this.m_shortcut = shortcut;
            this.m_qi = qi;
        }
    }
}

