/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmDeterminant;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.MeasureParentInternal;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Determinant;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureFolder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MeasureType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.impl.gateway.EMFModelGateway;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmConversionHelper {
    public static QueryItem convertMeasureToQueryItem(FMMDSession session, FmQuerySubjectBase parent, Measure measure) {
        QueryItemType qiEmfObj = GenmodelFactory.eINSTANCE.createQueryItemType();
        EMFModelGateway.copyChidrenFrom(measure.getInternal(), qiEmfObj);
        EMFModelGateway.replaceReferencesTo((EMFSession)session, measure.getInternal(), qiEmfObj, null);
        FmQueryItem qi = FmQueryItem.get(session, qiEmfObj);
        if (parent instanceof QuerySubject) {
            ReportObject oldParent = (ReportObject)measure.getParent();
            if (oldParent instanceof MeasureFolder) {
                FmQueryItemFolder qif = (FmQueryItemFolder)((FmQuerySubject)parent).findOrCreateQueryItemFolderFrom((MeasureFolder)oldParent);
                qif.addQueryItem(qi);
            } else {
                parent.addQueryItem(qi);
                parent.reorderBefore(qi, (BaseObject)measure);
            }
        } else {
            List<QueryItem> items = ((FmDimension)parent).getQueryItems();
            if (items.isEmpty()) {
                parent.addQueryItem(qi);
            } else {
                QueryItem lastItem = items.get(items.size() - 1);
                List<BaseObject> children = parent.getChildObjects();
                int idx = children.indexOf(lastItem);
                BaseObject itemAfterLast = lastItem;
                if (idx < children.size() - 1) {
                    itemAfterLast = children.get(idx + 1);
                }
                parent.addQueryItem(qi);
                parent.reorderBefore(qi, itemAfterLast);
            }
        }
        EMFModelGateway gw = new EMFModelGateway(session);
        gw.delete(measure.getInternal());
        return qi;
    }

    public static Measure convertQueryItemToMeasure(FMMDSession session, QuerySubjectBase parent, QueryItemBase qi) {
        MeasureType emfObj = GenmodelFactory.eINSTANCE.createMeasureType();
        EMFModelGateway.copyChidrenFrom(qi.getInternal(), emfObj);
        EMFModelGateway.replaceReferencesTo((EMFSession)session, qi.getInternal(), emfObj, null);
        FmMeasure measure = FmMeasure.get(session, emfObj);
        List<QueryItem> items = ((FmDimension)parent).getQueryItems();
        if (items.isEmpty()) {
            ((MeasureParentInternal)((Object)parent)).addMeasure(measure);
        } else {
            QueryItem firstItem = items.get(0);
            ((MeasureParentInternal)((Object)parent)).addMeasure(measure);
            parent.reorderBefore(measure, firstItem);
        }
        EMFModelGateway gw = new EMFModelGateway(session);
        gw.delete(qi.getInternal());
        return measure;
    }

    public static Level addLevelBaseOnDeterminant(FmHierarchy hier, Determinant det) {
        List<QueryItem> keys = det.getKeys();
        List<QueryItem> attributes = det.getAttributes();
        boolean levelIsUnique = FmConversionHelper.traverseKeysForDeterminant(det, keys, attributes);
        if (keys.isEmpty()) {
            return null;
        }
        FmLevel level = (FmLevel)hier.createLevel(det.getName());
        if (levelIsUnique) {
            level.setIsUnique(true);
        }
        boolean businessKeySet = false;
        int i = 0;
        while (i < keys.size()) {
            QueryItem keyItem = keys.get(i);
            level.addQueryItem(keyItem);
            if (!businessKeySet) {
                ((FmQueryItemBase)((Object)keyItem)).setRole("_businessKey");
                businessKeySet = true;
            }
            ++i;
        }
        boolean memberCaptionSet = false;
        int j = 0;
        while (j < attributes.size()) {
            QueryItem item = attributes.get(j);
            if (!memberCaptionSet && ((FmQueryItemBase)((Object)item)).canSetCaptionRole()) {
                ((FmQueryItemBase)((Object)item)).setRole("_memberCaption");
                memberCaptionSet = true;
            }
            level.addQueryItem(item);
            ++j;
        }
        return level;
    }

    public static void addQueryItemsBasedOnLevel(FmQuerySubject qs, FmLevel level, List<QueryItem> keyQueryItems, List<QueryItem> hCopiedQueryItems) {
        QueryItemBase levelKey = level.getItemWithRole("_businessKey");
        if (level.getIsUnique()) {
            keyQueryItems.clear();
        }
        List<QueryItem> hLevelChildObjects = level.getAllQueryItems();
        for (QueryItem item : hLevelChildObjects) {
            qs.addQueryItem(item);
            ((FmQueryItem)item).copyNames(item, BaseObject.PrefixName.kStandard, qs);
            hCopiedQueryItems.add(item);
            ((FmQueryItemBase)((Object)item)).removeAllRoles();
            if (!item.equals(levelKey)) continue;
            keyQueryItems.add(item);
        }
        Determinant det = qs.addDeterminant(level.getName());
        FmHierarchy hierarchy = level.getParentHierarchy();
        boolean isLeafLevel = hierarchy.getLeafLevel().equals(level);
        det.setIdentifiesRow(isLeafLevel);
        for (QueryItem item : hCopiedQueryItems) {
            if (keyQueryItems.contains(item)) continue;
            det.addAttribute(item);
        }
        det.setKeys(keyQueryItems);
    }

    private static boolean traverseKeysForDeterminant(Determinant det, List<QueryItem> keys, List<QueryItem> attributes) {
        FmQuerySubject qs = ((FmDeterminant)det).getQueryParent();
        List<Determinant> odets = qs.getDeterminants();
        boolean levelIsUnique = !det.equals(odets.get(0));
        for (Determinant odet : odets) {
            if (odet.equals(det)) break;
            List<QueryItem> okeys = odet.getKeys();
            List<QueryItem> oattributes = odet.getAttributes();
            for (QueryItem okey : okeys) {
                if (keys.contains(okey)) {
                    keys.remove(okey);
                    levelIsUnique = false;
                }
                if (!attributes.contains(okey)) continue;
                attributes.remove(okey);
            }
            for (QueryItem oattr : oattributes) {
                if (keys.contains(oattr)) {
                    keys.remove(oattr);
                }
                if (!attributes.contains(oattr)) continue;
                attributes.remove(oattr);
            }
        }
        return levelIsUnique;
    }
}

