/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemLike;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRefobjViaShortcut;
import com.ibm.cognos.fmeng.fmmd.model.Calculation;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Filter;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.FmBuilderBase;
import com.ibm.cognos.fmeng.genmodel.ColumnReferenceType;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.RefobjViaShortcutType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.gateway.EMFModelGateway;
import java.util.List;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmExpressionBuilder
extends FmBuilderBase
implements ExpressionBuilder {
    @Override
    public void addExpressionPart(String expressionPart, Object before) {
        this.addPartImpl(expressionPart, before);
    }

    @Override
    public void addExpressionPart(Calculation calc, Object before) {
        this.addPartImpl(calc, before);
    }

    @Override
    public void addExpressionPart(Filter filter, Object before) {
        this.addPartImpl(filter, before);
    }

    public void addExpressionPart(FmQueryItemLike likeObject, Object before) {
        this.addPartImpl(likeObject, before);
    }

    @Override
    public void addExpressionPart(QueryItemBase qi, Shortcut sc, Object before) {
        if (sc != null) {
            FmBuilderBase.ReferenceThroughShortcut rs = new FmBuilderBase.ReferenceThroughShortcut(sc, qi);
            this.addPartImpl(rs, before);
        } else {
            this.addPartImpl(qi, before);
        }
    }

    @Override
    public void addExpressionPart(DataSource ds, String columnName, String tableName, RelationalObject tlo, Object before) {
        this.addPartImpl(new ColumnReference(ds, columnName, tableName, tlo), before);
    }

    @Override
    public void addExpressionPart(MdColumn column, RelationalObject tlo, Object before) {
        String columnName = column.getName();
        MdTable table = column.getTable();
        String tableName = table.getName();
        DataSource ds = tlo.getSession().getProject().findOrCreateDataSource(table);
        this.addPartImpl(new ColumnReference(ds, columnName, tableName, tlo), before);
    }

    public void addExpressionPart(DataSource ds, String columnName, String tableName, RelationalObject tlo) {
        this.addPartImpl(new ColumnReference(ds, columnName, tableName, tlo), null);
    }

    @Override
    public void addExpressionPart(MemberUniqueNameBuilder mun, Object before) {
        this.addPartImpl(mun, before);
    }

    public List<Object> getExpressionParts() {
        return this.getParts();
    }

    public ExpressionType buildExpression(FMMDSession session) {
        ExpressionType expressionType = GenmodelFactory.eINSTANCE.createExpressionType();
        this.buildInto(session, expressionType);
        return expressionType;
    }

    private void buildInto(FMMDSession session, ExpressionType expressionType) {
        List<Object> parts = this.getParts();
        for (Object part : parts) {
            if (part instanceof String) {
                EMFModelGateway.addTextValueToExpression(expressionType, (String)part);
                continue;
            }
            if (part instanceof TopLevelObject) {
                TopLevelObject tlo = (TopLevelObject)part;
                EMFModelGateway.addFeatureToExpression(expressionType, 3, tlo.getInternal());
                continue;
            }
            if (part instanceof FmBuilderBase.ReferenceThroughShortcut) {
                FmBuilderBase.ReferenceThroughShortcut rts = (FmBuilderBase.ReferenceThroughShortcut)part;
                RefobjViaShortcutType refobjViaShortcutType = GenmodelFactory.eINSTANCE.createRefobjViaShortcutType();
                FmRefobjViaShortcut fmRefObjViaShortcut = FmRefobjViaShortcut.get(session, refobjViaShortcutType);
                fmRefObjViaShortcut.setShortcut(rts.m_shortcut);
                fmRefObjViaShortcut.setRefobj(rts.m_qi);
                EMFModelGateway.addFeatureToExpression(expressionType, 4, refobjViaShortcutType);
                continue;
            }
            if (part instanceof MemberUniqueNameBuilder) {
                MemberUniqueNameBuilder munBuilder = (MemberUniqueNameBuilder)part;
                FmMemberUniqueName name = FmMemberUniqueName.create(session, munBuilder);
                EMFModelGateway.addFeatureToExpression(expressionType, 5, name.getMemberUniqueNameType());
                continue;
            }
            if (!(part instanceof ColumnReference)) continue;
            ColumnReference columnRef = (ColumnReference)part;
            ColumnReferenceType cRef = GenmodelFactory.eINSTANCE.createColumnReferenceType();
            cRef.setColumnName(columnRef.m_columnName);
            cRef.setTableName(columnRef.m_tableName);
            cRef.setRefobj((EObject)columnRef.m_relationalObject.getInternal());
            cRef.setDataSourceRef((EObject)columnRef.m_dataSource.getInternal());
            EMFModelGateway.addFeatureToExpression(expressionType, 6, cRef);
        }
    }

    public void populateFrom(Expression et) {
        this.populateFrom(et.getComponents());
    }

    public boolean equals(Expression et) {
        return this.equals(et.getComponents());
    }

    public void parse(FMMDSession session, String expression) {
        if (!expression.startsWith("<expression>")) {
            expression = "<dummy>" + expression + "</dummy>";
        }
        Element elmExpression = null;
        try {
            elmExpression = DocumentHelper.parseText((String)expression).getRootElement();
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        for (Object child : elmExpression.content()) {
            Node node = (Node)child;
            if (node.getNodeType() == 1) {
                List refobjNodes;
                Element elmCurrent = (Element)node;
                String elmName = elmCurrent.getName();
                if (!elmCurrent.hasContent()) continue;
                if ("refobj".equals(elmName)) {
                    String value = elmCurrent.getText();
                    FmBaseObject hRefObj = (FmBaseObject)((Object)FmModelFactory.getInstance().getById(session, value));
                    if (hRefObj == null) continue;
                    this.m_parts.add(hRefObj);
                    continue;
                }
                if (!"refobjViaShortcut".equals(elmName) || (refobjNodes = elmCurrent.elements("refobj")).size() <= 0) continue;
                String refobjStr = ((Element)refobjNodes.get(0)).getText();
                String refobj1Str = ((Element)refobjNodes.get(1)).getText();
                FmBuilderBase.ReferenceThroughShortcut rs = new FmBuilderBase.ReferenceThroughShortcut((Shortcut)FmModelFactory.getInstance().getById(session, refobjStr), (QueryItemBase)FmModelFactory.getInstance().getById(session, refobj1Str));
                this.m_parts.add(rs);
                continue;
            }
            if (node.getNodeType() != 3) continue;
            this.m_parts.add(node.getText());
        }
    }

    class ColumnReference {
        public String m_columnName;
        public String m_tableName;
        DataSource m_dataSource;
        RelationalObject m_relationalObject;

        public ColumnReference(DataSource ds, String columnName, String tableName, RelationalObject relObject) {
            this.m_dataSource = ds;
            this.m_columnName = columnName;
            this.m_tableName = tableName;
            this.m_relationalObject = relObject;
        }
    }
}

