/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.V5Format.DocumentRoot;
import com.ibm.cognos.fmeng.V5Format.FormatGroupType;
import com.ibm.cognos.fmeng.V5Format.V5FormatFactory;
import com.ibm.cognos.fmeng.V5Format.util.V5FormatResourceFactoryImpl;
import com.ibm.cognos.fmeng.fmmd.model.Format;
import com.ibm.cognos.fmeng.fmmd.model.FormatCurrency;
import com.ibm.cognos.fmeng.fmmd.model.FormatNumber;
import com.ibm.cognos.fmeng.fmmd.model.FormatPercent;
import com.ibm.cognos.fmeng.fmmd.util.FmFormatCurrency;
import com.ibm.cognos.fmeng.fmmd.util.FmFormatNumber;
import com.ibm.cognos.fmeng.fmmd.util.FmFormatPercent;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class FmFormatGroup {
    private DocumentRoot m_doc;
    private FormatGroupType m_formatGroup;

    public static FmFormatGroup get(String format) {
        if (format == null || "".equals(format)) {
            return new FmFormatGroup();
        }
        byte[] bytes = format.getBytes();
        if (bytes == null) {
            return new FmFormatGroup();
        }
        ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
        V5FormatResourceFactoryImpl factory = new V5FormatResourceFactoryImpl();
        XMLResource eResource = (XMLResource)factory.createResource(null);
        try {
            eResource.load((InputStream)buffer, null);
        }
        catch (IOException iOException) {}
        TreeIterator tree = eResource.getAllContents();
        FmFormatGroup group = new FmFormatGroup();
        while (tree.hasNext()) {
            EObject obj = (EObject)tree.next();
            if (obj instanceof DocumentRoot) {
                group.m_doc = (DocumentRoot)obj;
                continue;
            }
            if (!(obj instanceof FormatGroupType)) continue;
            group.m_formatGroup = (FormatGroupType)obj;
        }
        return group;
    }

    public static FmFormatGroup create() {
        FmFormatGroup group = new FmFormatGroup();
        group.m_doc = V5FormatFactory.eINSTANCE.createDocumentRoot();
        group.m_formatGroup = V5FormatFactory.eINSTANCE.createFormatGroupType();
        group.m_doc.setFormatGroup(group.m_formatGroup);
        return group;
    }

    private FmFormatGroup() {
    }

    private FormatGroupType getFormatGroupType() {
        return this.m_formatGroup;
    }

    public Format getFormat() {
        FormatGroupType group = this.getFormatGroupType();
        if (group == null) {
            return null;
        }
        if (group.getNumberFormat() != null) {
            return FmFormatNumber.get(this, group.getNumberFormat());
        }
        if (group.getPercentFormat() != null) {
            return FmFormatPercent.get(this, group.getPercentFormat());
        }
        if (group.getCurrencyFormat() != null) {
            return FmFormatCurrency.get(this, group.getCurrencyFormat());
        }
        return null;
    }

    public String persist() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        V5FormatResourceFactoryImpl factory = new V5FormatResourceFactoryImpl();
        XMLResource eResource = (XMLResource)factory.createResource(null);
        eResource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.FALSE);
        eResource.getDefaultSaveOptions().put("FORMATTED", Boolean.FALSE);
        eResource.getContents().add((Object)this.m_doc);
        try {
            eResource.save((OutputStream)buffer, null);
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        String output = buffer.toString();
        String[] stringArray = output.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String foo = stringArray[n2];
            if (foo.startsWith("<formatGroup>")) {
                return foo;
            }
            ++n2;
        }
        FmMDException.ASSERT(false, "Failed to persist the format string.");
        return output;
    }

    public FormatNumber createNumberFormat() {
        FmFormatNumber format = FmFormatNumber.create(this);
        this.getFormatGroupType().setNumberFormat(format.getNumberFormatType());
        return format;
    }

    public FormatCurrency createCurrencyFormat() {
        FmFormatCurrency format = FmFormatCurrency.create(this);
        this.getFormatGroupType().setCurrencyFormat(format.getCurrencyFormatType());
        return format;
    }

    public FormatPercent createPercentFormat() {
        FmFormatPercent format = FmFormatPercent.create(this);
        this.getFormatGroupType().setPercentFormat(format.getPercentFormatType());
        return format;
    }
}

