/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.VirtualLevel;
import com.ibm.cognos.fmeng.fmmd.util.FmBuilderBase;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MunType;
import com.ibm.cognos.fmeng.genmodel.PathType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.gateway.EMFModelGateway;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;

public class FmMemberUniqueNameBuilder
extends FmBuilderBase
implements MemberUniqueNameBuilder {
    private String m_path;
    private String m_memberCaption;

    public void addPart(String part, Object before) {
        this.addPartImpl(part, before);
    }

    public void addPart(RelationalHierarchy hier, Object before) {
        this.addPartImpl(hier, before);
    }

    public void addPart(LevelReference lvl, Object before) {
        this.addPartImpl(lvl, before);
    }

    public void addPart(Level lvl, Object before) {
        this.addPartImpl(lvl, before);
    }

    public void addPart(VirtualLevel lvl, Object before) {
        this.addPartImpl(lvl, before);
    }

    public void addPart(VirtualHierarchy hier, Object before) {
        this.addPartImpl(hier, before);
    }

    public void populateFrom(MemberUniqueName mun) {
        this.populateFrom(mun.getComponents());
    }

    public MunType buildMemberUniqueName(FMMDSession session) {
        MunType munType = GenmodelFactory.eINSTANCE.createMunType();
        List<Object> parts = this.getParts();
        for (Object part : parts) {
            if (part instanceof String) {
                EMFModelGateway.addTextValueToMemberUniqueName(munType, (String)part);
                continue;
            }
            if (!(part instanceof TopLevelObject)) continue;
            TopLevelObject tlo = (TopLevelObject)part;
            EMFModelGateway.addFeatureToMemberUniqueName(munType, 1, tlo.getInternal());
        }
        if (this.m_path != null) {
            PathType path = GenmodelFactory.eINSTANCE.createPathType();
            path.setValue(this.m_path);
            munType.setPath(path);
        }
        if (this.m_memberCaption != null) {
            munType.setMemberCaption(this.m_memberCaption);
        }
        return munType;
    }

    public FmMemberUniqueName copyMemberUniqueName(FmMemberUniqueName defaultMemUniqName, FMMDSession session) {
        this.clear();
        this.populateFrom(defaultMemUniqName.getComponents());
        this.setPath(defaultMemUniqName.getPath());
        this.setCaption(defaultMemUniqName.getMemberCaption());
        return FmMemberUniqueName.get(session, this.buildMemberUniqueName(session));
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public void setCaption(String caption) {
        this.m_memberCaption = caption;
    }

    public void setMember(LevelReference lvl, RelationalHierarchy hier, String path, String caption) {
        this.setMember(lvl, path, caption);
    }

    public void setMember(LevelReference lvl, String path, String caption) {
        this.clear();
        this.addPartImpl(lvl, null);
        this.addPartImpl(lvl.getHierarchy(), null);
        this.m_path = path;
        this.m_memberCaption = caption;
    }

    public void setMember(Level lvl, String path, String caption) {
        BaseObject parent = lvl.getParent();
        if (!(parent instanceof RelationalHierarchy)) {
            throw new FmMDException("BMT_MD_INVALID_LEVEL_FOR_UNIQUE_NAME");
        }
        this.clear();
        this.addPartImpl(lvl, null);
        this.addPartImpl((RelationalHierarchy)parent, null);
        this.m_path = path;
        this.m_memberCaption = caption;
    }

    public void setMember(RelationalHierarchy hier, String path, String caption) {
        this.clear();
        this.addPartImpl(hier, null);
        this.addPartImpl(hier, null);
        this.m_path = path;
        this.m_memberCaption = caption;
    }

    public void setMember(String memberUniqueName, String caption) {
        this.clear();
        this.addPartImpl(memberUniqueName, null);
        this.m_path = null;
        this.m_memberCaption = caption;
    }

    public boolean equals(MemberUniqueName mun) {
        ArrayList<String> newparts = new ArrayList<String>();
        newparts.addAll(this.m_parts);
        newparts.add(this.m_path);
        newparts.add(this.m_memberCaption);
        List<Object> oldparts = mun.getComponents();
        int i = 0;
        while (i < newparts.size()) {
            if (i < oldparts.size() && !newparts.get(i).equals(oldparts.get(i))) {
                return false;
            }
            ++i;
        }
        return newparts.size() == oldparts.size();
    }

    public void setMember(VirtualLevel level, String path, String caption) {
        this.clear();
        this.addPartImpl(level, null);
        this.addPartImpl(level.getParent(), null);
        this.m_path = path;
        this.m_memberCaption = caption;
    }

    public void setMember(VirtualHierarchy hier, String path, String caption) {
        this.clear();
        this.addPartImpl(hier, null);
        this.addPartImpl(hier, null);
        this.m_path = path;
        this.m_memberCaption = caption;
    }
}

