/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.util.ObjectReferenceHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRelationshipHelper {
    private FMMDSession m_session;
    private RelationshipEnd m_end1;
    private RelationshipEnd m_end2;
    private int m_searchType;

    public static Set<FmRelationshipBase> getCandidateRelationships(FMMDSession session, RelationshipEnd first, RelationshipEnd second, int searchType) {
        FmRelationshipHelper helper = new FmRelationshipHelper(session, first, second, searchType);
        return helper.findRelationships();
    }

    public static Set<FmRelationshipBase> getCandidateRelationships(FMMDSession session, RelationshipEnd first, RelationshipEnd second, FmExpressionBuilder newExpression) {
        HashSet<FmRelationshipBase> filteredCandidates = new HashSet<FmRelationshipBase>();
        Set<FmRelationshipBase> candidates = FmRelationshipHelper.getCandidateRelationships(session, first, second, 453265);
        for (FmRelationshipBase candidate : candidates) {
            if (!(candidate instanceof FmRelationship) || !newExpression.equals(((FmRelationship)candidate).getExpression())) continue;
            filteredCandidates.add(candidate);
        }
        return filteredCandidates;
    }

    private FmRelationshipHelper(FMMDSession session, RelationshipEnd first, RelationshipEnd second, int searchType) {
        this.m_session = session;
        this.m_end1 = first;
        this.m_end2 = second;
        this.m_searchType = searchType;
    }

    private Set<FmRelationshipBase> findRelationships() {
        RelationshipEnd end1 = this.m_end1 instanceof FmShortcut ? (RelationshipEnd)((Object)((FmShortcut)this.m_end1).getRefobj()) : this.m_end1;
        RelationshipEnd end2 = this.m_end2 instanceof FmShortcut ? (RelationshipEnd)((Object)((FmShortcut)this.m_end2).getRefobj()) : this.m_end2;
        ArrayList<RelationshipEnd> inputEnds = new ArrayList<RelationshipEnd>();
        inputEnds.add(end1);
        inputEnds.add(end2);
        Map<RelationshipEnd, List<Object>> shortcutMap = ObjectReferenceHelper.getShortcutsMapFor(this.m_session, inputEnds);
        ArrayList<RelationshipEnd> allEnds = new ArrayList<RelationshipEnd>();
        allEnds.addAll(inputEnds);
        for (List<Object> shortcuts : shortcutMap.values()) {
            for (Object sc : shortcuts) {
                RelationshipEnd anEnd = (RelationshipEnd)FmModelFactory.getInstance().get(this.m_session, sc);
                allEnds.add(anEnd);
            }
        }
        Map<RelationshipEnd, List<Object>> relMap = ObjectReferenceHelper.getRelationshipsMapFor(this.m_session.getProject(), allEnds, false);
        HashSet<FmRelationshipBase> foundRelationships = new HashSet<FmRelationshipBase>();
        ArrayList<Object> eEnds1 = new ArrayList<Object>();
        eEnds1.add(end1.getInternal());
        if (shortcutMap.get(end1) != null) {
            eEnds1.addAll((Collection<Object>)shortcutMap.get(end1));
        }
        List<FoundRelationshipForEnd> foundRelationshipsForEnd1 = this.findRelationshipsForEnd(eEnds1, relMap);
        foundRelationships.addAll(this.filterFoundRelationshipsByOtherEnd(foundRelationshipsForEnd1, this.m_end2));
        ArrayList<Object> eEnds2 = new ArrayList<Object>();
        eEnds2.add(end2.getInternal());
        if (shortcutMap.get(end2) != null) {
            eEnds2.addAll((Collection<Object>)shortcutMap.get(end2));
        }
        List<FoundRelationshipForEnd> foundRelationshipsForEnd2 = this.findRelationshipsForEnd(eEnds2, relMap);
        foundRelationships.addAll(this.filterFoundRelationshipsByOtherEnd(foundRelationshipsForEnd2, this.m_end1));
        return foundRelationships;
    }

    private List<FoundRelationshipForEnd> findRelationshipsForEnd(List<Object> eEnds, Map<RelationshipEnd, List<Object>> relMap) {
        ArrayList<FoundRelationshipForEnd> results = new ArrayList<FoundRelationshipForEnd>();
        for (Object eEnd : eEnds) {
            RelationshipEnd end = (RelationshipEnd)FmModelFactory.getInstance().get(this.m_session, eEnd);
            List<Object> eRelationships = relMap.get(end);
            if (eRelationships == null) continue;
            for (Object eRel : eRelationships) {
                FmRelationshipBase rel = (FmRelationshipBase)FmModelFactory.getInstance().get(this.m_session, eRel);
                if (rel.isSelfJoin()) continue;
                results.add(new FoundRelationshipForEnd(rel, end));
            }
        }
        return results;
    }

    private List<FmRelationshipBase> filterFoundRelationshipsByOtherEnd(List<FoundRelationshipForEnd> foundRelationshipList, RelationshipEnd otherEnd) {
        ArrayList<FmRelationshipBase> hResultingRelationships = new ArrayList<FmRelationshipBase>();
        for (FoundRelationshipForEnd foundRel : foundRelationshipList) {
            boolean bRelationshipContainsBothEnds;
            RelationshipEnd end = foundRel.m_end;
            FmRelationshipBase rel = foundRel.m_relationship;
            boolean bl = bRelationshipContainsBothEnds = this.m_searchType == 0 ? this.relationshipContainsOtherEnd(rel, end, otherEnd) : this.relationshipContainsOtherEndOrAnyShortcutToIt(rel, end, otherEnd);
            if (!bRelationshipContainsBothEnds) continue;
            hResultingRelationships.add(rel);
        }
        return hResultingRelationships;
    }

    private boolean relationshipContainsOtherEndOrAnyShortcutToIt(FmRelationshipBase rel, RelationshipEnd foundEnd, RelationshipEnd otherEnd) {
        boolean bOtherEndFound = rel.containsBothEnds(foundEnd, otherEnd);
        if (!bOtherEndFound) {
            BaseObject trueOtherEnd = otherEnd.getFmObjectType() == FmObjectType.shortcut ? ((FmShortcut)otherEnd).getRefobj() : (FmBaseObject)((Object)otherEnd);
            ArrayList<RelationshipEnd> ends = new ArrayList<RelationshipEnd>();
            ends.add((RelationshipEnd)trueOtherEnd);
            Map<RelationshipEnd, List<Object>> map = ObjectReferenceHelper.getShortcutsMapFor(this.m_session, ends);
            List<Object> otherEndAll = map.get(trueOtherEnd);
            if (otherEndAll != null) {
                int i = 0;
                while (!bOtherEndFound && i < otherEndAll.size()) {
                    RelationshipEnd currentEnd = (RelationshipEnd)FmModelFactory.getInstance().get(this.m_session, otherEndAll.get(i));
                    bOtherEndFound = rel.containsBothEnds(foundEnd, currentEnd);
                    ++i;
                }
            }
        }
        return bOtherEndFound;
    }

    private boolean relationshipContainsOtherEnd(FmRelationshipBase rel, RelationshipEnd foundEnd, RelationshipEnd otherEnd) {
        return rel.containsBothEnds(foundEnd, otherEnd) || otherEnd instanceof FmShortcut && rel.containsBothEnds(foundEnd, (RelationshipEnd)((Object)((FmShortcut)otherEnd).getRefobj()));
    }

    public class FoundRelationshipForEnd {
        FmRelationshipBase m_relationship;
        RelationshipEnd m_end;

        FoundRelationshipForEnd(FmRelationshipBase relationship, RelationshipEnd end) {
            this.m_relationship = relationship;
            this.m_end = end;
        }
    }
}

