/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.util.JoinBase;
import com.ibm.cognos.fmeng.fmmd.util.Joinable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRoute<T extends Joinable<T, J>, J extends JoinBase<T, J>> {
    private List<J> m_Joins = new ArrayList<J>();
    private T m_Start = null;

    public FmRoute(T joinable) {
        this.m_Start = joinable;
    }

    public FmRoute(T start, J join) {
        this.m_Joins.add(join);
        this.m_Start = start;
    }

    public FmRoute(FmRoute<T, J> route) {
        this.m_Start = route.getNode(0);
        this.m_Joins.addAll(route.getJoinList());
    }

    public FmRoute(FmRoute<T, J> route, J join) {
        this.m_Start = route.getNode(0);
        this.m_Joins.addAll(route.getJoinList());
        this.m_Joins.add(join);
    }

    public boolean equals(FmRoute<T, J> route) {
        if (this.m_Joins.size() != route.getJoinCount()) {
            return false;
        }
        int i = 0;
        while (i < this.m_Joins.size()) {
            if (!this.getJoin(i).equals(route.getJoin(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(FmRoute<T, J> route) {
        if (this.getJoinCount() < route.getJoinCount()) {
            return false;
        }
        int i = 0;
        int j = 0;
        i = 0;
        while (i < route.getJoinCount()) {
            if (this.getJoin(i).equals(route.getJoin(0))) break;
            ++i;
        }
        j = i;
        while (j < route.getJoinCount()) {
            if (!this.getJoin(j).equals(route.getJoin(j - i))) {
                return false;
            }
            ++j;
        }
        return i < this.getJoinCount();
    }

    public boolean contains(T someNode) {
        for (Joinable node : this.getNodeList()) {
            if (!node.equals(someNode)) continue;
            return true;
        }
        return false;
    }

    public J getStart() {
        return (J)((JoinBase)this.m_Joins.get(0));
    }

    public J getEnd() {
        return (J)((JoinBase)this.m_Joins.get(this.m_Joins.size() - 1));
    }

    public String toString() {
        StringBuilder route = new StringBuilder();
        for (Joinable node : this.getNodeList()) {
            if (route.length() > 0) {
                route.append("-->");
            }
            route.append(node.getName());
        }
        return route.toString();
    }

    public void merge(FmRoute<T, J> secondRoute) {
        if (((JoinBase)this.m_Joins.get(this.m_Joins.size() - 1)).equals(secondRoute.getStart())) {
            this.m_Joins.remove(this.m_Joins.size() - 1);
            this.m_Joins.addAll(secondRoute.getJoinList());
        }
    }

    public List<T> getNodeList() {
        ArrayList<T> nodeList = new ArrayList<T>();
        if (this.m_Joins.size() > 0) {
            nodeList.add(this.m_Start);
            T prevNode = this.m_Start;
            for (JoinBase someJoin : this.m_Joins) {
                T nextNode = this.getOtherNode(someJoin, prevNode);
                nodeList.add(nextNode);
                prevNode = nextNode;
            }
        }
        return nodeList;
    }

    public T getNode(int node) {
        if (node > this.m_Joins.size()) {
            return null;
        }
        if (node == 0) {
            return this.m_Start;
        }
        if (node == 1) {
            return this.getOtherNode((JoinBase)this.m_Joins.get(0), this.m_Start);
        }
        return this.getNonCommonNode((JoinBase)this.m_Joins.get(node - 1), (JoinBase)this.m_Joins.get(node - 2));
    }

    private T getNonCommonNode(J joinOfInterest, J otherJoin) {
        if (joinOfInterest.getLeft().equals(otherJoin.getLeft()) || joinOfInterest.getLeft().equals(otherJoin.getRight())) {
            return joinOfInterest.getRight();
        }
        return joinOfInterest.getLeft();
    }

    public T getOtherNode(J join, T node) {
        if (node.equals(join.getLeft())) {
            return join.getRight();
        }
        return join.getLeft();
    }

    public int getJoinCount() {
        return this.m_Joins.size();
    }

    public List<J> getJoinList() {
        return this.m_Joins;
    }

    public int getNodeCount() {
        if (this.m_Joins.size() > 0) {
            return this.m_Joins.size() + 1;
        }
        return 0;
    }

    public J getJoin(int index) {
        return (J)((JoinBase)this.m_Joins.get(index));
    }

    public int getNodeOccurrence(T nodeCurrent) {
        int i = 0;
        for (Joinable node : this.getNodeList()) {
            if (!node.equals(nodeCurrent)) continue;
            ++i;
        }
        return i;
    }

    public String getNodeName(int index) {
        return this.getNode(index).getName();
    }

    public int getJoinOccurence(J someJoin) {
        int i = 0;
        for (JoinBase join : this.m_Joins) {
            if (!join.equals(someJoin)) continue;
            ++i;
        }
        return i;
    }
}

