/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.util.FmRoute;
import com.ibm.cognos.fmeng.fmmd.util.JoinBase;
import com.ibm.cognos.fmeng.fmmd.util.Joinable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRoutes<T extends Joinable<T, J>, J extends JoinBase<T, J>> {
    private T m_Start;
    private T m_End;
    private List<FmRoute<T, J>> m_Routes = new ArrayList<FmRoute<T, J>>();
    private int m_JoinType = 0;
    private int m_Governor = -1;
    private HashSet<T> m_Visited;
    private boolean m_AllowSingleNodeRoutes;

    public FmRoutes(int governor) {
        this.m_Start = null;
        this.m_End = null;
        this.m_Visited = new HashSet();
        this.m_AllowSingleNodeRoutes = true;
        this.m_JoinType = 2;
        this.m_Governor = governor;
    }

    public FmRoutes(int governor, FmRoutes<T, J> oldRoutes, boolean copyRoutes) {
        this.m_Start = oldRoutes.getStart();
        this.m_End = oldRoutes.getEnd();
        this.m_Visited = new HashSet();
        this.m_AllowSingleNodeRoutes = oldRoutes.allowSingleNodeRoutes();
        this.m_JoinType = oldRoutes.m_JoinType;
        this.m_Governor = governor;
        if (copyRoutes) {
            this.m_Routes.addAll(oldRoutes.m_Routes);
        }
    }

    public FmRoutes(int governor, int joinType, boolean allowSingleNodeRoutes) {
        this.m_Start = null;
        this.m_End = null;
        this.m_Visited = new HashSet();
        this.m_AllowSingleNodeRoutes = allowSingleNodeRoutes;
        this.m_JoinType = joinType;
        this.m_Governor = governor;
    }

    public void compute(T start, T end) {
        this.m_Start = start;
        this.m_End = end;
        this.m_Visited.clear();
        this.m_Routes.clear();
        this.compute();
    }

    public void compute() {
        if (this.m_Start == null || this.m_End == null) {
            return;
        }
        FmRoute startRoute = new FmRoute(this.m_Start);
        this.crawlNodes(this.m_Start, this.m_Start, this.m_End, startRoute, 0);
        if (this.m_Start.equals(this.m_End) && this.m_AllowSingleNodeRoutes) {
            this.addRoute(new FmRoute(this.m_Start));
        }
    }

    private void crawlNodes(T nodeStart, T nodeCurrent, T nodeEnd, FmRoute<T, J> currentRoute, int depth) {
        if (this.m_Routes.size() >= this.m_Governor) {
            return;
        }
        if (nodeCurrent.equals(nodeEnd) && currentRoute.getJoinCount() > 0) {
            this.addRoute(currentRoute);
            return;
        }
        for (JoinBase nextJoin : this.getNextJoins(nodeCurrent)) {
            if (currentRoute.getJoinOccurence(nextJoin) != 0) continue;
            FmRoute<T, JoinBase> neighbourRoute = new FmRoute<T, JoinBase>(currentRoute, nextJoin);
            this.crawlNodes(nodeStart, neighbourRoute.getOtherNode(nextJoin, nodeCurrent), nodeEnd, neighbourRoute, depth + 1);
        }
    }

    private List<J> getNextJoins(T node) {
        ArrayList<JoinBase> nextJoins = new ArrayList<JoinBase>();
        for (JoinBase someJoin : node.getJoins()) {
            Cardinality.ECardinality otherMaxCard;
            Cardinality.ECardinality oneMaxCard;
            if (someJoin.getLeft().equals(someJoin.getRight())) continue;
            if (node.equals(someJoin.getLeft())) {
                oneMaxCard = someJoin.getLeftMaxcard();
                otherMaxCard = someJoin.getRightMaxcard();
            } else {
                oneMaxCard = someJoin.getRightMaxcard();
                otherMaxCard = someJoin.getLeftMaxcard();
            }
            if ((this.m_JoinType & 1) > 0 && oneMaxCard == Cardinality.ECardinality.one && otherMaxCard == Cardinality.ECardinality.many) {
                nextJoins.add(someJoin);
            }
            if ((this.m_JoinType & 4) > 0 && oneMaxCard == Cardinality.ECardinality.one && otherMaxCard == Cardinality.ECardinality.one) {
                nextJoins.add(someJoin);
            }
            if ((this.m_JoinType & 2) <= 0 || oneMaxCard != Cardinality.ECardinality.many || otherMaxCard != Cardinality.ECardinality.one) continue;
            nextJoins.add(someJoin);
        }
        return nextJoins;
    }

    public FmRoute<T, J> getShortest() {
        FmRoute<T, J> shortest = null;
        for (FmRoute<T, J> route : this.m_Routes) {
            if (shortest == null) {
                shortest = route;
                continue;
            }
            if (route.getJoinCount() >= shortest.getJoinCount()) continue;
            shortest = route;
        }
        return shortest;
    }

    public void addRoute(FmRoute<T, J> currentRoute) {
        this.m_Routes.add(new FmRoute<T, J>(currentRoute));
    }

    public void addRoute(FmRoute<T, J> firstRoute, FmRoutes<T, J> destinations) {
        for (FmRoute<T, J> route : destinations.m_Routes) {
            FmRoute<T, J> newRoute = new FmRoute<T, J>(firstRoute);
            newRoute.merge(route);
            this.m_Routes.add(newRoute);
        }
    }

    public boolean hasRoutes() {
        for (FmRoute<T, J> route : this.m_Routes) {
            if (route.getJoinCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public String getStartName() {
        return this.m_Start.getName();
    }

    public String getEndName() {
        return this.m_End.getName();
    }

    public T getEnd() {
        return this.m_End;
    }

    public T getStart() {
        return this.m_Start;
    }

    public boolean allowSingleNodeRoutes() {
        return this.m_AllowSingleNodeRoutes;
    }

    public void addIfShorter(FmRoutes<T, J> routes) {
        for (FmRoute<T, J> route : routes.m_Routes) {
            if (this.m_Routes.size() == 0) {
                this.m_Routes.add(route);
                continue;
            }
            if (route.getNodeCount() < this.m_Routes.get(0).getNodeCount()) {
                this.m_Routes.clear();
                this.m_Routes.add(route);
                continue;
            }
            if (route.getNodeCount() != this.m_Routes.get(0).getNodeCount()) continue;
            this.m_Routes.add(route);
        }
    }

    public List<FmRoute<T, J>> getAllRoutes() {
        return this.m_Routes;
    }

    public FmRoute<T, J> getRoute(int index) {
        return this.m_Routes.get(index);
    }

    public int size() {
        return this.m_Routes.size();
    }

    public void addAll(FmRoutes<T, J> routes) {
        this.m_Routes.addAll(routes.getAllRoutes());
    }

    public void remove(int i) {
        this.m_Routes.remove(i);
    }

    public void trimNonShortest() {
        int shortest = -1;
        for (FmRoute<T, J> route : this.m_Routes) {
            if (shortest == -1) {
                shortest = route.getJoinCount();
                continue;
            }
            if (shortest <= route.getJoinCount()) continue;
            shortest = route.getJoinCount();
        }
        Iterator<FmRoute<T, J>> it = this.m_Routes.iterator();
        while (it.hasNext()) {
            FmRoute<T, J> route = it.next();
            if (route.getJoinCount() <= shortest) continue;
            it.remove();
        }
    }

    public boolean contains(FmRoute<T, J> route) {
        int i = 0;
        while (i < this.m_Routes.size()) {
            FmRoute<T, J> listRoute = this.m_Routes.get(i);
            if (listRoute.equals(route)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.m_Routes.size());
    }
}

