/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.util.FmRoute;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutes;
import com.ibm.cognos.fmeng.fmmd.util.JoinBase;
import com.ibm.cognos.fmeng.fmmd.util.Joinable;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRoutesCache<T extends Joinable<T, J>, J extends JoinBase<T, J>> {
    private boolean m_CacheRoutes;
    private int m_routesComputed;
    private int m_routesFound;
    private int m_governor;
    private HashMap<T, HashMap<T, FmRoutes<T, J>>> m_Cache;

    public FmRoutesCache(int governor, boolean cacheRoutes) {
        this.m_CacheRoutes = cacheRoutes;
        this.m_routesComputed = 0;
        this.m_routesFound = 0;
        this.m_governor = governor;
        if (cacheRoutes) {
            this.m_Cache = new HashMap();
        }
    }

    public FmRoutes<T, J> compute(T start, T end, boolean allowSingleNodeRoutes) {
        return this.compute(start, end, 2, allowSingleNodeRoutes);
    }

    public FmRoutes<T, J> compute(T start, T end, int joinType, boolean allowSingleNodeRoutes) {
        FmRoutes<T, J> routes = null;
        routes = this.findRoutes(start, end);
        if (routes != null) {
            routes = this.trimRoutes(routes, allowSingleNodeRoutes);
            return routes;
        }
        routes = new FmRoutes(this.m_governor, joinType, true);
        routes.compute(start, end);
        this.storeRoutes(start, end, routes);
        routes = this.trimRoutes(routes, allowSingleNodeRoutes);
        ++this.m_routesComputed;
        return routes;
    }

    private FmRoutes<T, J> trimRoutes(FmRoutes<T, J> routes, boolean allowSingleNodeRoutes) {
        if (allowSingleNodeRoutes) {
            return routes;
        }
        FmRoutes<T, J> trimmed = new FmRoutes<T, J>(this.m_governor, routes, false);
        for (FmRoute<T, J> route : routes.getAllRoutes()) {
            if (route.getJoinCount() <= 0) continue;
            trimmed.addRoute(route);
        }
        return trimmed;
    }

    private void storeRoutes(T start, T end, FmRoutes<T, J> routes) {
        if (this.m_CacheRoutes) {
            HashMap<Object, FmRoutes<T, J>> ends = this.m_Cache.get(start);
            if (ends == null) {
                ends = new HashMap();
                this.m_Cache.put(start, ends);
            }
            ends.get(end);
            ends.put(end, routes);
        }
    }

    private FmRoutes<T, J> findRoutes(T start, T end) {
        if (this.m_CacheRoutes) {
            if (this.m_Cache == null) {
                return null;
            }
            HashMap<T, FmRoutes<T, J>> ends = this.m_Cache.get(start);
            if (ends == null) {
                return null;
            }
            FmRoutes<T, J> routes = ends.get(end);
            if (routes != null) {
                ++this.m_routesFound;
            }
            return routes;
        }
        return null;
    }
}

