/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.util.FmTreeNode;
import com.ibm.cognos.fmeng.fmmd.util.FmTreeNodeContainer;
import com.ibm.cognos.fmeng.fmmd.util.FmTreeWalker;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTree<T>
implements FmTreeNodeContainer<T> {
    private FmTreeNode<T> m_Root = null;

    @Override
    public FmTreeNode<T> addChild(T data) {
        this.m_Root = new FmTreeNode<T>(null, data);
        return this.m_Root;
    }

    public List<T> getLeafNodeData() {
        LeafDataGetter leafGetter = new LeafDataGetter();
        this.walkTree(leafGetter, this.m_Root);
        return leafGetter.m_Leafs;
    }

    public List<FmTreeNode<T>> getLeafNodes() {
        LeafNodeGetter leafGetter = new LeafNodeGetter();
        this.walkTree(leafGetter, this.m_Root);
        return leafGetter.m_Leafs;
    }

    public void walkTree(FmTreeWalker<T> walker) {
        this.walkTree(walker, this.m_Root);
    }

    public void walkTree(FmTreeWalker<T> walker, FmTreeNode<T> node) {
        walker.doSomething(node);
        for (FmTreeNode<T> child : node.getChildren()) {
            this.walkTree(walker, child);
        }
    }

    public FmTreeNode<T> getRootNode() {
        return this.m_Root;
    }

    public String toString() {
        TreeDump treeDump = new TreeDump();
        this.walkTree(treeDump, this.m_Root);
        return treeDump.m_DumpString.toString();
    }

    public boolean isStick() {
        return this.isStick(this.m_Root);
    }

    private boolean isStick(FmTreeNode<T> node) {
        List<FmTreeNode<T>> children = node.getChildren();
        if (children.size() > 1) {
            return false;
        }
        if (children.size() == 1) {
            return this.isStick(children.get(0));
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LeafDataGetter
    implements FmTreeWalker<T> {
        public List<T> m_Leafs = new ArrayList();

        LeafDataGetter() {
        }

        @Override
        public void doSomething(FmTreeNode<T> node) {
            if (!node.hasChildren()) {
                this.m_Leafs.add(node.getData());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LeafNodeGetter
    implements FmTreeWalker<T> {
        public List<FmTreeNode<T>> m_Leafs = new ArrayList();

        LeafNodeGetter() {
        }

        @Override
        public void doSomething(FmTreeNode<T> node) {
            if (!node.hasChildren()) {
                this.m_Leafs.add(node);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TreeDump
    implements FmTreeWalker<T> {
        public StringBuilder m_DumpString = new StringBuilder();

        TreeDump() {
        }

        @Override
        public void doSomething(FmTreeNode<T> node) {
            StringBuilder indent = new StringBuilder();
            FmTreeNode parent = node;
            while (parent != null) {
                indent.append("\t");
                parent = parent.getParent();
            }
            this.m_DumpString.append((CharSequence)indent);
            this.m_DumpString.append(node.getData().toString());
            this.m_DumpString.append("\n");
        }
    }
}

