/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.util.StringHelper;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.Map;

public class FmengConnectionStringParser {
    public static final String STR_FieldDelimiter = ";";
    public static final String STR_ValueDelimiter = "=";
    String m_rawString;
    boolean m_bIsParsed;
    Map<String, String> m_values;

    FmengConnectionStringParser(String connectionStr) {
        this.m_rawString = connectionStr;
        this.m_bIsParsed = false;
    }

    public void parse() {
        ArrayList<String> vFields = new ArrayList<String>();
        StringHelper.split(this.m_rawString, STR_FieldDelimiter, vFields);
        int vIdx = 0;
        while (vIdx < vFields.size()) {
            ArrayList<String> vNameValuePair = new ArrayList<String>();
            StringHelper.split((String)vFields.get(vIdx), STR_ValueDelimiter, vNameValuePair);
            if (vNameValuePair.size() == 2) {
                String upperKey = (String)vNameValuePair.get(0);
                upperKey.toUpperCase();
                this.m_values.put(upperKey, (String)vNameValuePair.get(1));
            }
            ++vIdx;
        }
        this.m_bIsParsed = true;
    }

    boolean getValue(String upperKey, String value, boolean isRequired) {
        if (!this.m_bIsParsed) {
            this.parse();
        }
        boolean bFound = false;
        for (Map.Entry<String, String> pairs : this.m_values.entrySet()) {
            String key = pairs.getKey();
            if (!key.equals(upperKey)) continue;
            bFound = true;
            value = pairs.getValue();
            return true;
        }
        if (isRequired && !bFound) {
            Object[] msgParams = new Object[]{upperKey};
            throw new FmMDException("BMT_MD_DB_CONNECTION_FAILED_MISSING_INFO", msgParams);
        }
        return false;
    }
}

