/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.impl.model.EObjectSourceType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.model.Collector;
import com.ibm.cognos.fmeng.fmmd.model.NamedObject;
import com.ibm.cognos.fmeng.fmmd.model.QueryChild;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.fmmd.util.LocaleBasedValue;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectHelper {
    public static String renderObject(FMMDSession session, String localeKey, FmReportObject object, int indentLevel, boolean includeType) {
        ArrayList<FmReportObject> objects = new ArrayList<FmReportObject>();
        objects.add(object);
        return ObjectHelper.renderObjects(session, objects, indentLevel, includeType);
    }

    public static String renderObjects(FMMDSession session, Collection<? extends FmBaseObject> objects, int indentLevel, boolean includeType) {
        StringBuilder renderedObjectNameList = new StringBuilder();
        for (FmBaseObject fmBaseObject : objects) {
            String objectName = null;
            if (fmBaseObject instanceof NamedObject) {
                objectName = ((NamedObject)((Object)fmBaseObject)).getName();
            } else if (fmBaseObject instanceof Collector) {
                objectName = fmBaseObject.getLocalizedType();
            }
            if (objectName == null) continue;
            int tabIdx = 0;
            while (tabIdx < indentLevel) {
                renderedObjectNameList.append("\t");
                tabIdx = (short)(tabIdx + 1);
            }
            if (includeType) {
                Object[] msgParams = new Object[]{fmBaseObject.getLocalizedType(), objectName};
                FmMessage currentObjectMsg = new FmMessage("BMT_MDS_OBJECT_NAME", msgParams);
                objectName = currentObjectMsg.render(session.getActiveLocale());
            }
            renderedObjectNameList.append(objectName);
            renderedObjectNameList.append("\n");
        }
        return renderedObjectNameList.toString();
    }

    public static EObjectSourceType determineSourceType(FmBaseObject obj, HashSet<FmBaseObject> visitedObjs) {
        EObjectSourceType eSourceType = EObjectSourceType.kUnknown;
        switch (obj.getFmObjectType()) {
            case hierarchy: 
            case level: 
            case queryItem: 
            case queryItemFolder: {
                visitedObjs.add(obj);
                eSourceType = FmQuerySubjectBase.getQueryParent((QueryChild)((Object)obj)).determineSourceType(visitedObjs);
                break;
            }
            case dimension: 
            case querySubject: {
                visitedObjs.add(obj);
                eSourceType = ((FmQuerySubjectBase)obj).determineSourceType(visitedObjs);
                break;
            }
            case shortcut: {
                visitedObjs.add(obj);
                FmBaseObject targetObj = (FmBaseObject)((Object)((FmShortcut)obj).getRefobj());
                eSourceType = ObjectHelper.determineSourceType(targetObj, visitedObjs);
            }
        }
        return eSourceType;
    }

    public static ArrayList<LocaleBasedValue> getBasedOnNames(FMMDSession session, FmBaseObject baseObject) {
        ArrayList<LocaleBasedValue> vLocalizedNames = new ArrayList<LocaleBasedValue>();
        FmMDException.ASSERT(baseObject != null, "Expects a non null argument");
        String sLocale = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        String sName = ((FmReportObject)baseObject).getName(sLocale);
        vLocalizedNames.add(new LocaleBasedValue(sLocale, sName));
        return vLocalizedNames;
    }

    public static List<QueryItem> getQueryItems(FMMDSession session, Object parent) {
        HashSet<Integer> recurseInto = new HashSet<Integer>();
        HashMap<Integer, List<Object>> collect = new HashMap<Integer, List<Object>>();
        ArrayList qItems = new ArrayList();
        collect.put(119, qItems);
        EmfHelper.collect(parent, recurseInto, collect);
        ArrayList<QueryItem> res = new ArrayList<QueryItem>();
        for (Object qItem : qItems) {
            res.add((FmQueryItem)FmModelFactory.getInstance().get(session, qItem));
        }
        return res;
    }
}

