/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.model.AttributeReference;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.NamedSet;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimension;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasureFolder;
import com.ibm.cognos.fmeng.fmmd.model.VirtualObject;
import com.ibm.cognos.fmeng.utility.FmMDException;

public class ROLAPIDBuilder {
    public static String build(CubeBase cube, RelationalObject obj) {
        String name = "";
        if (cube != null) {
            name = "[" + cube.getName() + "].";
        }
        name = String.valueOf(name) + "[" + obj.getName() + "]";
        return name;
    }

    public static String build(CubeBase cube, RelationalHierarchy obj) {
        return String.valueOf(ROLAPIDBuilder.build(cube, obj.getDimension())) + ".[" + obj.getName() + "]";
    }

    public static String build(CubeBase cube, LevelReference lvl) {
        return String.valueOf(ROLAPIDBuilder.build(cube, lvl.getHierarchy())) + ".[" + lvl.getLevel().getName() + "]";
    }

    public static String build(CubeBase cube, AttributeReference attr) {
        return String.valueOf(ROLAPIDBuilder.build(cube, attr.getLevelReference())) + ".[" + attr.getName() + "]";
    }

    public static String build(CubeBase cube, Level allLevel) {
        return String.valueOf(ROLAPIDBuilder.build(cube, (RelationalHierarchy)allLevel.getParent())) + ".[" + allLevel.getName() + "]";
    }

    public static String build(CubeBase cube, NamedSet namedSet) {
        String name = "";
        if (cube != null) {
            name = "[" + cube.getName() + "].";
        }
        name = String.valueOf(name) + "[" + namedSet.getName() + "]";
        return name;
    }

    public static String build(CubeBase cube, Measure obj) {
        RelationalObject parent = obj.getRelationalParent();
        FmMDException.ASSERT(parent != null, "Trying to build a ROLAP ID for a measure that is not in a measure dimension: " + obj.getID());
        return String.valueOf(ROLAPIDBuilder.build(cube, parent)) + ".[" + obj.getName() + "]";
    }

    public static String build(CubeBase cube, CalculatedMember obj) {
        StringBuilder builder = new StringBuilder();
        String parentMember = obj.getV5MemberParent(cube, true);
        if (!parentMember.equals("")) {
            builder.append(parentMember);
            builder.append(".");
        }
        builder.append("[");
        builder.append(obj.getName());
        builder.append("]");
        return builder.toString();
    }

    public static String build(VirtualObject obj) {
        String id = "";
        BaseObject someObj = obj;
        while (someObj != null) {
            if (someObj instanceof VirtualObject) {
                VirtualObject vObj = someObj;
                if (!id.equals("")) {
                    id = "." + id;
                }
                id = "[" + vObj.getName() + "]" + id;
            } else if (!(someObj instanceof VirtualMeasureFolder)) break;
            someObj = someObj.getParent();
        }
        return id;
    }

    public static String buildShortId(VirtualHierarchy obj) {
        return "[" + ((VirtualDimension)obj.getParent()).getName() + "].[" + obj.getName() + "]";
    }
}

