/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.util;

import com.ibm.cognos.fmeng.fmmd.util.SQLParseResult;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLParser {
    private final String m_ValidTableName = "([A-Za-z0-9_@$#\u0080-\uffff]+)";
    private final String m_DBPattern = "\\[([A-Za-z0-9_@$#\\s\\.\u0080-\u9fff]+)\\]";
    private final Pattern m_hasSchema = Pattern.compile("\\[([A-Za-z0-9_@$#\\s\\.\u0080-\u9fff]+)\\]");
    private final Pattern m_TablePattern = Pattern.compile("\\[([A-Za-z0-9_@$#\\s\\.\u0080-\u9fff]+)\\]\\.([A-Za-z0-9_@$#\u0080-\uffff]+)");
    private final Pattern m_TablePattern2 = Pattern.compile("\\[([A-Za-z0-9_@$#\\s\\.\u0080-\u9fff]+)\\]\\.&quot;([A-Za-z0-9_@$#\u0080-\uffff]+)&quot;");
    private final Pattern m_TablePattern3 = Pattern.compile("\\[([A-Za-z0-9_@$#\\s\\.\u0080-\u9fff]+)\\]\\.&apos;([A-Za-z0-9_@$#\u0080-\uffff]+)&apos;");
    private final Pattern m_TablePattern4 = Pattern.compile("\\[([A-Za-z0-9_@$#\\s\\.\u0080-\u9fff]+)\\]\\.'([A-Za-z0-9_@$#\u0080-\uffff]+)'");
    private final Pattern m_TablePattern5 = Pattern.compile("\\[([A-Za-z0-9_@$#\\s\\.\u0080-\u9fff]+)\\]\\.\"([A-Za-z0-9_@$#\u0080-\uffff]+)\"");
    private final Pattern m_TableOnlyPattern = Pattern.compile("[Ff][Rr][Oo][Mm]\\s+([A-Za-z0-9_@$#\u0080-\uffff]+)");

    public SQLParseResult parse(String SQL2) {
        return this.parse(SQL2, null);
    }

    public SQLParseResult parse(String SQL2, Set<String> datasourceNames) {
        SQLParseResult dst = new SQLParseResult();
        Matcher schemaMatch = this.m_hasSchema.matcher(SQL2);
        if (schemaMatch.find()) {
            Matcher tableMatch = this.m_TablePattern.matcher(SQL2);
            if (tableMatch.find() && tableMatch.groupCount() >= 2) {
                dst.set(tableMatch.group(1), tableMatch.group(2));
            }
            if (!dst.isSet() && (tableMatch = this.m_TablePattern2.matcher(SQL2)).find() && tableMatch.groupCount() >= 2) {
                dst.set(tableMatch.group(1), tableMatch.group(2));
            }
            if (!dst.isSet() && (tableMatch = this.m_TablePattern3.matcher(SQL2)).find() && tableMatch.groupCount() >= 2) {
                dst.set(tableMatch.group(1), tableMatch.group(2));
            }
            if (!dst.isSet() && (tableMatch = this.m_TablePattern4.matcher(SQL2)).find() && tableMatch.groupCount() >= 2) {
                dst.set(tableMatch.group(1), tableMatch.group(2));
            }
            if (!dst.isSet() && (tableMatch = this.m_TablePattern5.matcher(SQL2)).find() && tableMatch.groupCount() >= 2) {
                dst.set(tableMatch.group(1), tableMatch.group(2));
            }
        } else {
            Matcher tableMatch = this.m_TableOnlyPattern.matcher(SQL2);
            if (tableMatch.find() && tableMatch.groupCount() >= 1 && datasourceNames != null && datasourceNames.size() == 1) {
                Iterator<String> it = datasourceNames.iterator();
                dst.set(it.next(), tableMatch.group(1));
            }
        }
        return dst;
    }
}

