/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperatorType implements Enumerator
{
    NONE(0, "none", "none"),
    EQUALS(1, "equals", "equals"),
    NOT_EQUALS(2, "notEquals", "notEquals"),
    GREATER_THAN(3, "greaterThan", "greaterThan"),
    LESS_THAN(4, "lessThan", "lessThan"),
    GREATER_THAN_OR_EQUALS(5, "greaterThanOrEquals", "greaterThanOrEquals"),
    LESS_THAN_OR_EQUALS(6, "lessThanOrEquals", "lessThanOrEquals");

    public static final int NONE_VALUE = 0;
    public static final int EQUALS_VALUE = 1;
    public static final int NOT_EQUALS_VALUE = 2;
    public static final int GREATER_THAN_VALUE = 3;
    public static final int LESS_THAN_VALUE = 4;
    public static final int GREATER_THAN_OR_EQUALS_VALUE = 5;
    public static final int LESS_THAN_OR_EQUALS_VALUE = 6;
    private static final OperatorType[] VALUES_ARRAY;
    public static final List<OperatorType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OperatorType[]{NONE, EQUALS, NOT_EQUALS, GREATER_THAN, LESS_THAN, GREATER_THAN_OR_EQUALS, LESS_THAN_OR_EQUALS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OperatorType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperatorType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperatorType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperatorType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperatorType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return EQUALS;
            }
            case 2: {
                return NOT_EQUALS;
            }
            case 3: {
                return GREATER_THAN;
            }
            case 4: {
                return LESS_THAN;
            }
            case 5: {
                return GREATER_THAN_OR_EQUALS;
            }
            case 6: {
                return LESS_THAN_OR_EQUALS;
            }
        }
        return null;
    }

    private OperatorType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

