/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StatusType implements Enumerator
{
    VALID(0, "valid", "valid"),
    INVALID(1, "invalid", "invalid"),
    NEEDS_REEVALUATION(2, "needsReevaluation", "needsReevaluation"),
    WARNING(3, "warning", "warning"),
    CHILD_INVALID(4, "childInvalid", "childInvalid"),
    CHILD_WARNING(5, "childWarning", "childWarning"),
    CHILD_INVALID_THIS_WARNING(6, "childInvalidThisWarning", "childInvalidThisWarning"),
    PERFORMANCE(7, "performance", "performance");

    public static final int VALID_VALUE = 0;
    public static final int INVALID_VALUE = 1;
    public static final int NEEDS_REEVALUATION_VALUE = 2;
    public static final int WARNING_VALUE = 3;
    public static final int CHILD_INVALID_VALUE = 4;
    public static final int CHILD_WARNING_VALUE = 5;
    public static final int CHILD_INVALID_THIS_WARNING_VALUE = 6;
    public static final int PERFORMANCE_VALUE = 7;
    private static final StatusType[] VALUES_ARRAY;
    public static final List<StatusType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StatusType[]{VALID, INVALID, NEEDS_REEVALUATION, WARNING, CHILD_INVALID, CHILD_WARNING, CHILD_INVALID_THIS_WARNING, PERFORMANCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StatusType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StatusType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StatusType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StatusType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StatusType get(int value) {
        switch (value) {
            case 0: {
                return VALID;
            }
            case 1: {
                return INVALID;
            }
            case 2: {
                return NEEDS_REEVALUATION;
            }
            case 3: {
                return WARNING;
            }
            case 4: {
                return CHILD_INVALID;
            }
            case 5: {
                return CHILD_WARNING;
            }
            case 6: {
                return CHILD_INVALID_THIS_WARNING;
            }
            case 7: {
                return PERFORMANCE;
            }
        }
        return null;
    }

    private StatusType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

