/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt;

import com.ibm.cognos.fmeng.fmmd.helpers.DomHelper;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.imprt.ImportUtility;
import com.ibm.cognos.fmeng.imprt.relational.browse.RelDbBrowser;
import com.ibm.cognos.fmeng.imprt.relational.browse.RelmdBrowser;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class FmImportManager {
    private static FmImportManager m_importMgr = new FmImportManager();

    public static FmImportManager getInstance() {
        return m_importMgr;
    }

    private FmImportManager() {
    }

    public Element doBrowse(FMMDSession session, Element browseSpec) {
        Element updatedSpec = null;
        if (browseSpec == null) {
            updatedSpec = this.DoBrowseUsingCMDataSource(session, browseSpec);
        } else {
            InterfaceType browseType = this.getBrowseDataSrcType(browseSpec);
            RelDbBrowser browser = null;
            if (browseType == InterfaceType.kInterfaceTypeRelational) {
                browser = new RelDbBrowser(session, new RelmdBrowser(session));
                updatedSpec = browser.browse(browseSpec);
            } else {
                FmMDException.ASSERT(false, "OLAP import is not supported yet.");
            }
        }
        return updatedSpec;
    }

    private InterfaceType getBrowseDataSrcType(Element browseSpec) {
        String dbType;
        InterfaceType type = InterfaceType.kInterfaceTypeRelational;
        Element token = ImportUtility.getBrowsedItem(browseSpec);
        Element databaseElement = ImportUtility.getParentElement(token, "database");
        if (databaseElement != null && (dbType = databaseElement.attributeValue("dbType")) != null) {
            type = this.getInterfaceType(dbType);
        }
        return type;
    }

    public Element DoBrowseUsingCMDataSource(FMMDSession session, Element browseSpec) {
        Element updatedSpec = null;
        if (browseSpec == null) {
            browseSpec = DomHelper.stringToDom4j("<importSpec/>");
            CmHelper cmHelper = null;
            String cmDataSourceName = "";
            String cmDataSourceType = "";
            try {
                cmHelper = CmHelper.get(session, session.getPassport());
                Map<String, String> cmDataSources = cmHelper.getCmDataSources();
                Set<Map.Entry<String, String>> set = cmDataSources.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    cmDataSourceName = entry.getKey();
                    cmDataSourceType = entry.getValue();
                    ImportUtility.addChildItem(browseSpec, cmDataSourceName, "database", "false", "", cmDataSourceType);
                    updatedSpec = browseSpec;
                }
            }
            catch (MalformedURLException e) {
                FmEngApplicationLog.getApplicationLog().logException(e);
            }
            catch (IOException e) {
                FmEngApplicationLog.getApplicationLog().logException(e);
            }
        } else {
            updatedSpec = browseSpec;
        }
        return updatedSpec;
    }

    public void doReleaseDataSources(FMMDSession session) {
    }

    private InterfaceType getInterfaceType(String dataSourceCode) {
        InterfaceType interfaceType = InterfaceType.kInterfaceTypeRelational;
        if ("BW".equals(dataSourceCode)) {
            interfaceType = InterfaceType.kInterfaceTypeSAPBW;
        }
        if ("PC".equals(dataSourceCode)) {
            interfaceType = InterfaceType.kInterfaceTypeOLAP;
        }
        return interfaceType;
    }

    public InterfaceType getInterfaceTypeForImportSpec(Element importSpec) {
        String dataSrcType = null;
        List fndElements = importSpec.selectNodes("//item[@Type='database' and @Value='partial']");
        FmMDException.ASSERT(fndElements.size() == 1, "Import spec is invalid, only one data source item may be selected.");
        if (fndElements.size() > 0) {
            Element dbItem = (Element)fndElements.get(0);
            dataSrcType = dbItem.attributeValue("dbType");
        }
        if (dataSrcType == null || dataSrcType.length() == 0) {
            throw new FmMDException("BMT_MD_IMPORT_NODE_TYPE_INVALID");
        }
        return this.getInterfaceType(dataSrcType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InterfaceType {
        kInterfaceTypeRelational,
        kInterfaceTypeSAPBW,
        kInterfaceTypeOLAP;

    }
}

