/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt;

import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmImportSpecHelper {
    Element m_importSpec = null;

    public static FmImportSpecHelper create(Element importSpec) {
        FmImportSpecHelper helper = new FmImportSpecHelper();
        helper.initialize(importSpec);
        return helper;
    }

    private FmImportSpecHelper() {
    }

    private void initialize(Element importSpec) {
        this.m_importSpec = importSpec;
    }

    public ESelectionState getDatabaseIncludeState(String dataSourceName) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        return this.queryForState(queryStr.toString());
    }

    public ESelectionState getCatalogIncludeState(String dataSourceName, String catName) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        this.addItemXPath(queryStr, catName, "catalog");
        return this.queryForState(queryStr.toString());
    }

    public ESelectionState getSchemaIncludeState(String dataSourceName, String catName, String schemaName) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        if (catName.length() > 0) {
            this.addItemXPath(queryStr, catName, "catalog");
        }
        this.addItemXPath(queryStr, schemaName, "schema");
        return this.queryForState(queryStr.toString());
    }

    public ESelectionState getTableIncludeState(String dataSourceName, String catName, String schemaName, String tablename) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        if (catName.length() > 0) {
            this.addItemXPath(queryStr, catName, "catalog");
        }
        this.addItemXPath(queryStr, schemaName, "schema");
        this.addItemXPath(queryStr, null, "tables");
        this.addItemXPath(queryStr, tablename, "table");
        return this.queryForState(queryStr.toString());
    }

    public ESelectionState getViewIncludeState(String dataSourceName, String catName, String schemaName, String viewname) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        if (catName.length() > 0) {
            this.addItemXPath(queryStr, catName, "catalog");
        }
        this.addItemXPath(queryStr, schemaName, "schema");
        this.addItemXPath(queryStr, null, "views");
        this.addItemXPath(queryStr, viewname, "view");
        return this.queryForState(queryStr.toString());
    }

    public ESelectionState getAllTablesIncludeState(String dataSourceName, String catName, String schemaName) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        if (catName.length() > 0) {
            this.addItemXPath(queryStr, catName, "catalog");
        }
        this.addItemXPath(queryStr, schemaName, "schema");
        this.addItemXPath(queryStr, null, "tables");
        return this.queryForState(queryStr.toString());
    }

    public ESelectionState getAllViewsIncludeState(String dataSourceName, String catName, String schemaName) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        if (catName.length() > 0) {
            this.addItemXPath(queryStr, catName, "catalog");
        }
        this.addItemXPath(queryStr, schemaName, "schema");
        this.addItemXPath(queryStr, null, "views");
        return this.queryForState(queryStr.toString());
    }

    public ESelectionState getAllSynonymsIncludeState(String dataSourceName, String catName, String schemaName) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        if (catName.length() > 0) {
            this.addItemXPath(queryStr, catName, "catalog");
        }
        this.addItemXPath(queryStr, schemaName, "schema");
        this.addItemXPath(queryStr, null, "synonyms");
        return this.queryForState(queryStr.toString());
    }

    public ESelectionState getAllProceduresIncludeState(String dataSourceName, String catName, String schemaName) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        if (catName.length() > 0) {
            this.addItemXPath(queryStr, catName, "catalog");
        }
        this.addItemXPath(queryStr, schemaName, "schema");
        this.addItemXPath(queryStr, null, "procedures");
        return this.queryForState(queryStr.toString());
    }

    public ESelectionState getAllFunctionsIncludeState(String dataSourceName, String catName, String schemaName) {
        StringBuffer queryStr = new StringBuffer();
        this.addItemXPath(queryStr, dataSourceName, "database");
        if (catName.length() > 0) {
            this.addItemXPath(queryStr, catName, "catalog");
        }
        this.addItemXPath(queryStr, schemaName, "schema");
        this.addItemXPath(queryStr, null, "functions");
        return this.queryForState(queryStr.toString());
    }

    public String getDataSourceName() {
        Element importSpec = this.m_importSpec;
        String elmType = importSpec.attributeValue("Type");
        String dsName = null;
        while (!"database".equals(elmType) && importSpec != null) {
            importSpec = importSpec.getParent();
            elmType = importSpec.attributeValue("Type");
        }
        if (importSpec != null) {
            dsName = importSpec.attributeValue("Name");
        }
        return dsName;
    }

    public ESelectionState getRootSelectionState() {
        String value = this.m_importSpec.attributeValue("Value");
        return this.selectStateToString(value);
    }

    private void addItemXPath(StringBuffer queryStr, String name, String type) {
        queryStr.append("/item[");
        if (name != null && name.length() > 0) {
            queryStr.append("@Name='");
            queryStr.append(name);
            queryStr.append("' and ");
        }
        queryStr.append("@Type='");
        queryStr.append(type);
        queryStr.append("']");
    }

    private ESelectionState selectStateToString(String value) {
        ESelectionState state = ESelectionState.kNotSelected;
        if (value.equals("partial")) {
            state = ESelectionState.kPartial;
        } else if (value.equals("true")) {
            state = ESelectionState.kSelected;
        }
        return state;
    }

    private ESelectionState queryForState(String xpath) {
        ESelectionState state = ESelectionState.kNotSelected;
        List nodes = this.m_importSpec.selectNodes(xpath);
        if (nodes.size() > 0) {
            String value = ((Element)nodes.get(0)).attributeValue("Value");
            state = this.selectStateToString(value);
        }
        return state;
    }

    public List<Element> getAllSelected(String ... type) {
        StringBuffer queryString = new StringBuffer("//item[");
        queryString.append("(");
        int i = 0;
        while (i < type.length) {
            queryString.append("@Type='");
            queryString.append(type[i]);
            queryString.append("'");
            if (i + 1 < type.length) {
                queryString.append(" or ");
            }
            ++i;
        }
        queryString.append(") and (@Value='partial' or @Value='true')]");
        return this.m_importSpec.selectNodes(queryString.toString());
    }

    public boolean isType(String string, Element elem) {
        return string.equals(elem.attributeValue("Type"));
    }

    public String getUniqueName(Element elem) {
        return elem.attributeValue("uniqueName");
    }

    public String getAttribute(String attributeName) {
        return this.m_importSpec.attributeValue(attributeName);
    }

    public String getName() {
        return this.m_importSpec.attributeValue("Name");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ESelectionState {
        kSelected,
        kPartial,
        kNotSelected;

    }
}

